/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl#getRuntimeId <em>Runtime Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl#getTimezone <em>Timezone</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl#getPort <em>Port</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl#getDeltaTime <em>Delta Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl#getIpAddress <em>Ip Address</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl#getMonitor <em>Monitor</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl#getProcessProxies <em>Process Proxies</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCNodeImpl extends EObjectImpl implements TRCNode {
	/**
	 * The default value of the '{@link #getRuntimeId() <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimeId()
	 * @generated
	 * @ordered
	 */
	protected static final String RUNTIME_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRuntimeId() <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimeId()
	 * @generated
	 * @ordered
	 */
	protected String runtimeId = RUNTIME_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getTimezone() <em>Timezone</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimezone()
	 * @generated
	 * @ordered
	 */
	protected static final double TIMEZONE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTimezone() <em>Timezone</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimezone()
	 * @generated
	 * @ordered
	 */
	protected double timezone = TIMEZONE_EDEFAULT;

	/**
	 * The default value of the '{@link #getPort() <em>Port</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPort()
	 * @generated
	 * @ordered
	 */
	protected static final int PORT_EDEFAULT = 10002;

	/**
	 * The cached value of the '{@link #getPort() <em>Port</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPort()
	 * @generated
	 * @ordered
	 */
	protected int port = PORT_EDEFAULT;

	/**
	 * The default value of the '{@link #getDeltaTime() <em>Delta Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeltaTime()
	 * @generated
	 * @ordered
	 */
	protected static final double DELTA_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getDeltaTime() <em>Delta Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeltaTime()
	 * @generated
	 * @ordered
	 */
	protected double deltaTime = DELTA_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getIpAddress() <em>Ip Address</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIpAddress()
	 * @generated
	 * @ordered
	 */
	protected static final String IP_ADDRESS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIpAddress() <em>Ip Address</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIpAddress()
	 * @generated
	 * @ordered
	 */
	protected String ipAddress = IP_ADDRESS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMonitor() <em>Monitor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMonitor()
	 * @generated
	 * @ordered
	 */
	protected TRCMonitor monitor = null;

	/**
	 * The cached value of the '{@link #getProcessProxies() <em>Process Proxies</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessProxies()
	 * @generated
	 * @ordered
	 */
	protected EList processProxies = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCNodeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return HierarchyPackage.eINSTANCE.getTRCNode();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getRuntimeId() {
		return runtimeId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRuntimeId(String newRuntimeId) {
		String oldRuntimeId = runtimeId;
		runtimeId = newRuntimeId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_NODE__RUNTIME_ID, oldRuntimeId, runtimeId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getTimezone() {
		return timezone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimezone(double newTimezone) {
		double oldTimezone = timezone;
		timezone = newTimezone;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_NODE__TIMEZONE, oldTimezone, timezone));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getPort() {
		return port;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPort(int newPort) {
		int oldPort = port;
		port = newPort;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_NODE__PORT, oldPort, port));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getDeltaTime() {
		return deltaTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeltaTime(double newDeltaTime) {
		double oldDeltaTime = deltaTime;
		deltaTime = newDeltaTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_NODE__DELTA_TIME, oldDeltaTime, deltaTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_NODE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_NODE__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getIpAddress() {
		return ipAddress;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIpAddress(String newIpAddress) {
		String oldIpAddress = ipAddress;
		ipAddress = newIpAddress;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_NODE__IP_ADDRESS, oldIpAddress, ipAddress));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getProcessProxies() {
		if (processProxies == null) {
			processProxies = new EObjectWithInverseResolvingEList(TRCProcessProxy.class, this, HierarchyPackage.TRC_NODE__PROCESS_PROXIES, HierarchyPackage.TRC_PROCESS_PROXY__NODE);
		}
		return processProxies;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMonitor getMonitor() {
		if (monitor != null && monitor.eIsProxy()) {
			TRCMonitor oldMonitor = monitor;
			monitor = (TRCMonitor)EcoreUtil.resolve(monitor, this);
			if (monitor != oldMonitor) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.TRC_NODE__MONITOR, oldMonitor, monitor));
			}
		}
		return monitor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMonitor basicGetMonitor() {
		return monitor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetMonitor(TRCMonitor newMonitor, NotificationChain msgs) {
		TRCMonitor oldMonitor = monitor;
		monitor = newMonitor;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_NODE__MONITOR, oldMonitor, newMonitor);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMonitor(TRCMonitor newMonitor) {
		if (newMonitor != monitor) {
			NotificationChain msgs = null;
			if (monitor != null)
				msgs = ((InternalEObject)monitor).eInverseRemove(this, HierarchyPackage.TRC_MONITOR__NODES, TRCMonitor.class, msgs);
			if (newMonitor != null)
				msgs = ((InternalEObject)newMonitor).eInverseAdd(this, HierarchyPackage.TRC_MONITOR__NODES, TRCMonitor.class, msgs);
			msgs = basicSetMonitor(newMonitor, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_NODE__MONITOR, newMonitor, newMonitor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_NODE__MONITOR:
					if (monitor != null)
						msgs = ((InternalEObject)monitor).eInverseRemove(this, HierarchyPackage.TRC_MONITOR__NODES, TRCMonitor.class, msgs);
					return basicSetMonitor((TRCMonitor)otherEnd, msgs);
				case HierarchyPackage.TRC_NODE__PROCESS_PROXIES:
					return ((InternalEList)getProcessProxies()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_NODE__MONITOR:
					return basicSetMonitor(null, msgs);
				case HierarchyPackage.TRC_NODE__PROCESS_PROXIES:
					return ((InternalEList)getProcessProxies()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_NODE__RUNTIME_ID:
				return getRuntimeId();
			case HierarchyPackage.TRC_NODE__TIMEZONE:
				return new Double(getTimezone());
			case HierarchyPackage.TRC_NODE__PORT:
				return new Integer(getPort());
			case HierarchyPackage.TRC_NODE__DELTA_TIME:
				return new Double(getDeltaTime());
			case HierarchyPackage.TRC_NODE__NAME:
				return getName();
			case HierarchyPackage.TRC_NODE__DESCRIPTION:
				return getDescription();
			case HierarchyPackage.TRC_NODE__IP_ADDRESS:
				return getIpAddress();
			case HierarchyPackage.TRC_NODE__MONITOR:
				if (resolve) return getMonitor();
				return basicGetMonitor();
			case HierarchyPackage.TRC_NODE__PROCESS_PROXIES:
				return getProcessProxies();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_NODE__RUNTIME_ID:
				setRuntimeId((String)newValue);
				return;
			case HierarchyPackage.TRC_NODE__TIMEZONE:
				setTimezone(((Double)newValue).doubleValue());
				return;
			case HierarchyPackage.TRC_NODE__PORT:
				setPort(((Integer)newValue).intValue());
				return;
			case HierarchyPackage.TRC_NODE__DELTA_TIME:
				setDeltaTime(((Double)newValue).doubleValue());
				return;
			case HierarchyPackage.TRC_NODE__NAME:
				setName((String)newValue);
				return;
			case HierarchyPackage.TRC_NODE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case HierarchyPackage.TRC_NODE__IP_ADDRESS:
				setIpAddress((String)newValue);
				return;
			case HierarchyPackage.TRC_NODE__MONITOR:
				setMonitor((TRCMonitor)newValue);
				return;
			case HierarchyPackage.TRC_NODE__PROCESS_PROXIES:
				getProcessProxies().clear();
				getProcessProxies().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_NODE__RUNTIME_ID:
				setRuntimeId(RUNTIME_ID_EDEFAULT);
				return;
			case HierarchyPackage.TRC_NODE__TIMEZONE:
				setTimezone(TIMEZONE_EDEFAULT);
				return;
			case HierarchyPackage.TRC_NODE__PORT:
				setPort(PORT_EDEFAULT);
				return;
			case HierarchyPackage.TRC_NODE__DELTA_TIME:
				setDeltaTime(DELTA_TIME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_NODE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_NODE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case HierarchyPackage.TRC_NODE__IP_ADDRESS:
				setIpAddress(IP_ADDRESS_EDEFAULT);
				return;
			case HierarchyPackage.TRC_NODE__MONITOR:
				setMonitor((TRCMonitor)null);
				return;
			case HierarchyPackage.TRC_NODE__PROCESS_PROXIES:
				getProcessProxies().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_NODE__RUNTIME_ID:
				return RUNTIME_ID_EDEFAULT == null ? runtimeId != null : !RUNTIME_ID_EDEFAULT.equals(runtimeId);
			case HierarchyPackage.TRC_NODE__TIMEZONE:
				return timezone != TIMEZONE_EDEFAULT;
			case HierarchyPackage.TRC_NODE__PORT:
				return port != PORT_EDEFAULT;
			case HierarchyPackage.TRC_NODE__DELTA_TIME:
				return deltaTime != DELTA_TIME_EDEFAULT;
			case HierarchyPackage.TRC_NODE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case HierarchyPackage.TRC_NODE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case HierarchyPackage.TRC_NODE__IP_ADDRESS:
				return IP_ADDRESS_EDEFAULT == null ? ipAddress != null : !IP_ADDRESS_EDEFAULT.equals(ipAddress);
			case HierarchyPackage.TRC_NODE__MONITOR:
				return monitor != null;
			case HierarchyPackage.TRC_NODE__PROCESS_PROXIES:
				return processProxies != null && !processProxies.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (runtimeId: ");
		result.append(runtimeId);
		result.append(", timezone: ");
		result.append(timezone);
		result.append(", port: ");
		result.append(port);
		result.append(", deltaTime: ");
		result.append(deltaTime);
		result.append(", name: ");
		result.append(name);
		result.append(", description: ");
		result.append(description);
		result.append(", ipAddress: ");
		result.append(ipAddress);
		result.append(')');
		return result.toString();
	}

} //TRCNodeImpl
