/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;


public class HierarchyResourceFactoryImpl extends XMIResourceFactoryImpl {
    //~ Constructors -------------------------------------------------------------------------------

    public HierarchyResourceFactoryImpl() {
        super();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public Resource createResource(URI uri) {
        HierarchyXMIResourceImpl r = new HierarchyXMIResourceImpl(uri);

        r.setUseZip(true);
        r.setEncoding("UTF-8");

        return r;
    }
}
