/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.xmi.impl.XMLString;


/*
 * Calling sequence is:
 * startElement()
 *   addAttrribute() 0 or more times
 *   startAttribute(), addAttributeContent(), and endAttribute(), 0 or more times
 *   endEmptyElement() or endContentElement()
 *   startElement()  0 or more times
 * endElement()
 */
public class HierarchyXMLString extends XMLString {
    //~ Instance fields ----------------------------------------------------------------------------

    protected List elementNames;
    protected List indents;
    protected boolean lastElementIsStart;
    protected int currentLineWidth;
    protected int lineWidth;
    protected int markedLineWidth;
    private OutputStreamWriter outputStreamWriter = null;

    //~ Constructors -------------------------------------------------------------------------------

    public HierarchyXMLString(OutputStreamWriter outputStreamWriter) {
        super(80);
        this.outputStreamWriter = outputStreamWriter;
        elementNames = new BasicEList();
        indents = new org.eclipse.emf.common.util.BasicEList();
        indents.add("");
    }

    //~ Methods ------------------------------------------------------------------------------------

    /**
     * Sets the outputStreamWriter.
     * @param outputStreamWriter The outputStreamWriter to set
     */
    public void setOutputStreamWriter(OutputStreamWriter outputStreamWriter) {
        this.outputStreamWriter = outputStreamWriter;
    }

    /**
     * @return OutputStreamWriter
     */
    public OutputStreamWriter getOutputStreamWriter() {
        return outputStreamWriter;
    }

    public void add(String newString) {
        write(newString);
    }

    public void addAttribute(String name, String value) {
        add(" ");
        add(name);
        add("=\"");
        add(value);
        add("\"");
    }

    public void addAttributeContent(String content) {
        add(content);
    }

    public void addAttributeNS(String prefix, String localName, String value) {
        add(" ");
        add(prefix);
        add(":");
        add(localName);
        add("=\"");
        add(value);
        add("\"");
    }

    public void addLine() {
        add("\n");
    }

    public void endAttribute() {
        add("\"");
    }

    public void endContentElement(String content) {
        add(">");
        add(content);
        add("</");

        String name = removeLast();

        add(name);
        add(">");
        addLine();
        lastElementIsStart = false;
    }

    public void endElement() {
        if (lastElementIsStart) {
            endEmptyElement();
        } else {
            add(getElementIndent());
            add("</");

            String name = removeLast();

            add(name);
            add(">");
            addLine();
            lastElementIsStart = false;
        }
    }

    public void endEmptyElement() {
        removeLast();
        add("/>");
        addLine();
        lastElementIsStart = false;
    }

    /**
     * Method iterator.
     */
    public Iterator iterator() {
        return null;
    }

    public Object mark() {
        return null;
    }

    public void resetToMark(Object mark) {
    }

    public void startAttribute(String name) {
        add(" ");
        add(name);
        add("=\"");
    }

    public void startElement(String name) {
        if (lastElementIsStart) {
            closeStartElement();
        }

        elementNames.add(name);
        add(getElementIndent());
        add("<");
        add(name);
        lastElementIsStart = true;
    }

    protected String getAttributeIndent() {
        int depth = elementNames.size() + 1;

        for (int i = indents.size() - 1; i < depth; ++i) {
            indents.add(indents.get(i) + "  ");
        }

        return (String) indents.get(depth);
    }

    protected String getElementIndent() {
        int depth = elementNames.size() - 1;

        for (int i = indents.size() - 1; i < depth; ++i) {
            indents.add(indents.get(i) + "  ");
        }

        return (String) indents.get(depth);
    }

    protected void closeStartElement() {
        add(">");
        addLine();
    }

    protected String removeLast() {
        int end = elementNames.size();

        return (String) elementNames.remove(end - 1);
    }

    private void write(String newString) {
        try {
            outputStreamWriter.write(newString);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
