/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.*;
import org.eclipse.ui.part.IPage;

/**
 * Insert the type's description here.
 * Creation date: (06/14/2000 2:49:21 PM)
 * @author: Administrator
 */
public class MethodStatisticViewer extends TraceViewer
{
   protected Action _openSource;      
   protected Action _percentMode;
   protected Action _deltaColumns;   
   protected Action _printColumns;
   protected static final String _title = TraceUIPlugin.getString("STR_METH_ST_TITLE");   
     
/**
 * ClassStatisticViewer constructor comment.
 */
public MethodStatisticViewer() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (08/01/2000 4:17:37 PM)
 * @return com.ibm.itp.jinsight.adapter.TraceViewerPage
 */
public TraceViewerPage createPage(EObject mofObject)
{
	return new MethodStatisticPage(mofObject, this);
}
/**
 * @see IWorkbenchPart#dispose
 */
public void dispose()
{
	Enumeration pages = _pages.elements();   
	while(pages.hasMoreElements())
	{
		IPage page = (IPage) pages.nextElement();

		if(page instanceof MethodStatisticPage)
		  ((MethodStatisticPage)page).dispose();
	}
	
	_openSource = null;
	_percentMode = null;
	_printColumns = null;

	super.dispose();
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 2:54:24 PM)
 */
public void makeActions()
{
	if(isInitializedMenu())
	  return; //create the toolbar only once

	initializedMenu(true);
	
 	String strShowPercent = TraceUIPlugin.getString("SHOW_PERCENT");  	  						
	_percentMode = new Action(strShowPercent)
	{
		public void run()
		{
			MethodStatisticPage page = (MethodStatisticPage)getCurrentPage();

			if(page == null)
			  return;

			page.getView().getShowPercentAction().run();      
		}
		public int getStyle() { return IAction.AS_CHECK_BOX; }

	};

	String strShowDelta = TraceUIPlugin.getString("STR_ST_SHOW_DELTA_COLUMNS");	
	_deltaColumns = new Action(strShowDelta)
	{
		public void run()
		{
			MethodStatisticPage page = (MethodStatisticPage)getCurrentPage();

			if(page == null)
			  return;
			page.getView().getDeltaColumnsAction().run();      
		}
		
		public int getStyle() { return IAction.AS_CHECK_BOX; }
		
	
	};

	_deltaColumns.setText(strShowDelta);
	TracePluginImages.setImageDescriptors(_deltaColumns,TracePluginImages.T_LCL,TracePluginImages.IMG_DELTACOLUMNS);
	_deltaColumns.setDescription(strShowDelta);   
	_deltaColumns.setToolTipText(strShowDelta);
	_deltaColumns.setEnabled(true);

	_percentMode.setText(strShowPercent);
	TracePluginImages.setImageDescriptors(_percentMode,TracePluginImages.T_LCL,TracePluginImages.IMG_PERCENT);			
	_percentMode.setDescription(strShowPercent);   
	_percentMode.setToolTipText(strShowPercent);
	_percentMode.setEnabled(true);
	
	String strPrintColumns = TraceUIPlugin.getString("STR_ST_PRINT_COL");
	_printColumns = new Action(strPrintColumns) {
		public void run() {
			MethodStatisticPage page = (MethodStatisticPage) getCurrentPage();

			if (page == null)
				return;

			page.getView().getPrintColumnsAction().run();
		}
	};
	_printColumns.setText(strPrintColumns);
	TracePluginImages.setImageDescriptors(_printColumns, TracePluginImages.T_LCL, TracePluginImages.IMG_PRINTCOLUMNS);
	_printColumns.setDescription(strPrintColumns);
	_printColumns.setToolTipText(strPrintColumns);
	_printColumns.setEnabled(true);
	
   String openSourceStr = TraceUIPlugin.getString("STR_SOURCE");					
	_openSource = new Action(openSourceStr)
	{
		public void run()
		{
			MethodStatisticPage page = (MethodStatisticPage)getCurrentPage();

			if(page == null)
			  return;
			  
			OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(page.getMOFObject()).getFirstElement());
		}
	};

	_openSource.setText(openSourceStr);
	TracePluginImages.setImageDescriptors(_openSource,TracePluginImages.T_TOOL,TracePluginImages.IMG_SOURCE);	
	_openSource.setDescription(openSourceStr);   
	_openSource.setToolTipText(openSourceStr);
		
	IToolBarManager tbm = getViewSite().getActionBars().getToolBarManager();
	
	tbm.removeAll();
	tbm.add(new Separator());
	tbm.add(_openSource);	
	tbm.add(new Separator());
	tbm.add(_percentMode);
	tbm.add(_deltaColumns);		
	tbm.add(_printColumns);
	tbm.add(new Separator());

	// require update because toolbar control has been created by this point,
	// but manager does not update it automatically once it has been created
	getViewSite().getActionBars().updateActionBars();           
}
public Action percentMode() {
	return _percentMode;
}

public Action deltaColumns() {
	return _deltaColumns;
}

/**
 * Insert the method's description here.
 * Creation date: (8/21/2001 4:20:37 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action openSource() {
	return _openSource;
}
/**
 * Insert the method's description here.
 * Creation date: (10/5/2001 11:42:53 AM)
 */
public void setFocus() {

	MethodStatisticPage page = (MethodStatisticPage)getCurrentPage();
	if (page!=null){
		
		page.setFocus();
/*
		JInsight model = page.getView().getModel();
		if(model!=null){
			SelectionModel selModel= model.getSelectionModel();
			model.getSelectionEvent().deliver(new SelectionEvent(selModel));
		}
*/		
	}
}


/*
 * Returns the object that should be viewd if
 * true if the selObject is selected in the monitors view
 * For example, if the process node is selected, the view should display
 * the profiling data if trace collects profiling data
 * 
 */
public EObject getObjectToView(EObject selObject)
{
	if(selObject == null)
	  return selObject;

	if(selObject instanceof TRCProcessProxy)
	{
		int nbOfAgents = 0;
		TRCAgentProxy a = null;
		EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
		for(int idx=0; idx<agents.size(); idx++)
		{
			TRCAgentProxy agent = (TRCAgentProxy) agents.get(idx);
			if(agent == null || agent.eIsProxy())
				continue;
			if(agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE))
			{
				nbOfAgents++;
				a = agent;
			}
		}
		
		if(nbOfAgents==1)
		  return a;
	}

	return selObject;
}

/*
 * Initial title view 
 */
 public String getViewTitle()
 {
 	return _title;
 }

}
