/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.jface.action.*;
import org.eclipse.ui.part.IPage;

/**
 * Insert the type's description here.
 * Creation date: (06/14/2000 2:49:21 PM)
 * @author: Administrator
 */
public class PatternViewer extends TraceViewer
{
   protected Action _reset;
   protected Action _showRawTime;
   private Action _zoomInAction;
   private Action _zoomOutAction;
   private Action _stdSelectAction;
   protected Action _showCompensatedTime;
   private   boolean _stdSelect = true;
   private   boolean _zoomIn = false;
   private   boolean _zoomOut = false;
      
/**
 * HistogramEditor constructor comment.
 */
public PatternViewer() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (08/01/2000 4:17:37 PM)
 * @return com.ibm.itp.jinsight.adapter.TraceViewerPage
 */
public TraceViewerPage createPage(EObject mofObject)
{
	return  new PatternPage(mofObject, this);
}
/**
 * @see IWorkbenchPart#dispose
 */
public void dispose()
{
	Enumeration pages = _pages.elements(); 
	while(pages.hasMoreElements())
	{
		IPage page = (IPage) pages.nextElement();

		if(page instanceof PatternPage)
		  ((PatternPage)page).dispose();
	}

	_showCompensatedTime = null;
	_showRawTime = null;
	_stdSelectAction = null;
	_zoomInAction = null;
	_zoomOutAction = null;

	super.dispose();    
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 2:54:24 PM)
 */
public void makeActions()
{
	if(isInitializedMenu())
	  return; //create the toolbar only once

	initializedMenu(true);
	
    String compTime = TraceUIPlugin.getString("STR_COMPENSATED_TIME");
	_showCompensatedTime = new Action(compTime)
	{
		public void run()
		{
			TraceUIPlugin.getDefault().getPreferenceStore()
				.setValue(TraceConstants.TIME_OPTION, TraceConstants.COMPENSATED_TIME);
			
			TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
			
		}
	};      
	_showCompensatedTime.setText(compTime);
	_showCompensatedTime.setDescription(compTime);
	_showCompensatedTime.setToolTipText(compTime);   
	int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.TIME_OPTION);
	_showCompensatedTime.setChecked(ref == TraceConstants.COMPENSATED_TIME);         
	
    String rawTime = TraceUIPlugin.getString("STR_RAW_TIME");
	_showRawTime = new Action(rawTime)
	{
		public void run()
		{
			TraceUIPlugin.getDefault().getPreferenceStore()
				.setValue(TraceConstants.TIME_OPTION, TraceConstants.RAW_TIME);
			
			TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
			
		}
	};      
	_showRawTime.setText(rawTime);
	_showRawTime.setDescription(rawTime);
	_showRawTime.setToolTipText(rawTime);   
	ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.TIME_OPTION);
	_showRawTime.setChecked(ref == TraceConstants.RAW_TIME);         
		
   String strHome = TraceUIPlugin.getString("STR_HOME");			
	_reset = new Action(strHome)
	{
		public void run()
		{
			PatternPage page = (PatternPage)getCurrentPage();

			if(page == null)
			  return;
			  
			page.getView().update();
		}
	};      
	_reset.setText(strHome);
	TracePluginImages.setImageDescriptors(_reset,TracePluginImages.T_TOOL,TracePluginImages.IMG_HOME);		
	_reset.setDescription(strHome);
	_reset.setToolTipText(strHome);         

	String strStdSelect = TraceUIPlugin.getString("STR_STD_SELECT");				
	_stdSelectAction = new Action(strStdSelect)
	{
		public void run()
		{
			PatternPage page = (PatternPage)getCurrentPage();

			if(page == null)
			  return;
			  
			_stdSelect = true;
			_zoomIn = !_stdSelect;
			_zoomOut = !_stdSelect;		 

			_stdSelectAction.setChecked(true);
			_zoomInAction.setChecked(false);			
			_zoomOutAction.setChecked(false);
				
			page.getView().zoomIn(_zoomIn);
			page.getView().zoomOut(_zoomOut);												
		}
		
		public int getStyle() { return IAction.AS_CHECK_BOX; }
		
	};
	
	_stdSelectAction.setText(strStdSelect);
	TracePluginImages.setImageDescriptors(_stdSelectAction,TracePluginImages.T_LCL,TracePluginImages.IMG_RESTORE_ORG);		
	_stdSelectAction.setDescription(strStdSelect);
	_stdSelectAction.setToolTipText(strStdSelect);

	
	String strZoomIn = TraceUIPlugin.getString("STR_ZOOM_IN");				
	_zoomInAction = new Action(strZoomIn)
	{
		public void run()
		{
			PatternPage page = (PatternPage)getCurrentPage();

			if(page == null)
			  return;
			  
			_zoomIn = isChecked();
			if (_zoomIn==false)
			{
				_stdSelect = true;
			}
			else {
				_stdSelect = !_zoomIn;
				_zoomOut = !_zoomIn;
			}			 
			if(_zoomIn) 
			{				
				_stdSelectAction.setChecked(false);
				_zoomOutAction.setChecked(false);
			}
			else
				_stdSelectAction.setChecked(true);
					
			page.getView().zoomIn(_zoomIn);												
		}
		
		public int getStyle() { return IAction.AS_CHECK_BOX; }
		
	};

	_zoomInAction.setText(strZoomIn);
	TracePluginImages.setImageDescriptors(_zoomInAction,TracePluginImages.T_LCL,TracePluginImages.IMG_ZOOMIN);		
	_zoomInAction.setDescription(strZoomIn);
	_zoomInAction.setToolTipText(strZoomIn);         

    String strZoomOut = TraceUIPlugin.getString("STR_ZOOM_OUT");
	_zoomOutAction = new Action(strZoomOut)
	{
		public void run()
		{
			PatternPage page = (PatternPage)getCurrentPage();

			if(page == null)
			  return;
			  			
			_zoomOut = isChecked();
			if (_zoomOut==false)
			{
				_stdSelect = true;
			}
			else {
				_stdSelect = !_zoomOut;
				_zoomIn = !_zoomOut;
			}
			 
			if(_zoomOut) 
			{
				_stdSelectAction.setChecked(false);
				_zoomInAction.setChecked(false);
			}
			else
				_stdSelectAction.setChecked(true);
			
			page.getView().zoomOut(_zoomOut);						
		}
		
		public int getStyle() { return IAction.AS_CHECK_BOX; }
		
	};

	_zoomOutAction.setText(strZoomOut);
	TracePluginImages.setImageDescriptors(_zoomOutAction,TracePluginImages.T_LCL,TracePluginImages.IMG_ZOOMOUT);			
	_zoomOutAction.setDescription(strZoomOut);   
	_zoomOutAction.setToolTipText(strZoomOut);                   
	
	Action openColorDialog = new Action(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"))
	{
		public void run()
		{
			GraphColorDialog dialog =
				new GraphColorDialog(
					getViewSite().getShell(),
					TraceUIPlugin.getString("STR_GRAPH_COLOR_DLG"),
					null);
			dialog.open();
		}
	};

	openColorDialog.setText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
	TracePluginImages.setImageDescriptors(openColorDialog,TracePluginImages.T_TOOL,TracePluginImages.IMG_COLORS);	
	openColorDialog.setDescription(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));   
	openColorDialog.setToolTipText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));

	IToolBarManager tbm = getViewSite().getActionBars().getToolBarManager();
	IMenuManager menu = getViewSite().getActionBars().getMenuManager();
	MenuManager submenu = new MenuManager(TraceUIPlugin.getString("STR_SHOW_TIME"));
	menu.add(submenu);

	submenu.add(_showCompensatedTime);
	submenu.add(_showRawTime);
	
	tbm.removeAll();
	tbm.add(new Separator());
	tbm.add(_stdSelectAction);
	tbm.add(_zoomInAction);
	tbm.add(_zoomOutAction);
	tbm.add(new Separator());
	tbm.add(_reset);			
	tbm.add(new Separator());
    tbm.add(openColorDialog);
	// require update because toolbar control has been created by this point,
	// but manager does not update it automatically once it has been created
	getViewSite().getActionBars().updateActionBars();           
}
/**
 * Insert the method's description here.
 * Creation date: (8/1/2001 6:25:59 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action baseTime() {
	return _showCompensatedTime;
}
/**
 * Insert the method's description here.
 * Creation date: (8/1/2001 6:25:59 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action rawTime() {
	return _showRawTime;
}

/**
 * Insert the method's description here.
 * Creation date: (10/5/2001 11:42:53 AM)
 */
public void setFocus() {
	
	if (getCurrentPage()!=null)
	((PatternPage)getCurrentPage()).setFocus();

}



/*
 * Returns the object that should be viewd if
 * true if the selObject is selected in the monitors view
 * For example, if the process node is selected, the view should display
 * the profiling data if trace collects profiling data
 * 
 */
public EObject getObjectToView(EObject selObject)
{
	if(selObject == null)
	  return selObject;

	if(selObject instanceof TRCProcessProxy)
	{
		int nbOfAgents = 0;
		TRCAgentProxy a = null;
		EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
		for(int idx=0; idx<agents.size(); idx++)
		{
			TRCAgentProxy agent = (TRCAgentProxy) agents.get(idx);
			if(agent == null || agent.eIsProxy())
				continue;
			if(agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE))
			{
				nbOfAgents++;
				a = agent;
			}
		}
		
		if(nbOfAgents==1)
		  return a;
	}

	return selObject;
}

/*
 * Initial title view 
 */
 public String getViewTitle()
 {
 	return TraceUIPlugin.getString("STR_EXEC_TITLE");
 }

 public void initializeActionBar()
 {
	_stdSelectAction.setChecked(true); 	
 }
}
