/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.internal.SinglePattern;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
* CONTEXT_ID mthi0000 for method invocation view
*/

/**
 * Insert the type's description here.
 * Creation date: (06/14/2000 12:34:21 PM)
 * @author: Administrator
 */
public class SinglePatternPage extends TraceViewerPage
{
	protected SinglePattern _view;
	
/**
 */
public SinglePatternPage( EObject mofObject, TraceViewer _viewer)
{
	super(mofObject, _viewer);
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 5:15:22 PM)
 * @return com.ibm.jface.action.Action
 */
public Action callee() {
	return ((SinglePatternViewer)_viewer).callee();
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 5:15:22 PM)
 * @return com.ibm.jface.action.Action
 */
public Action caller() {
	return ((SinglePatternViewer)_viewer).caller();
}

public Action baseTime() {
	return((SinglePatternViewer)_viewer).baseTime();
}

public Action rawTime() {
	return((SinglePatternViewer)_viewer).rawTime();
}

/**
 * Insert the method's description here.
 * Creation date: (06/14/2000 12:38:21 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public void createControl(Composite parent)
{
	_view = new SinglePattern(parent, this);
	_view.initialize();

	setContextMenu(_view.getCanvas().canvas(), _view);
	makeActions();

   	org.eclipse.ui.help.WorkbenchHelp.setHelp(
	this.getControl(),
	TraceUIPlugin.getPluginId()+".mthi0000");
}
/**
 * @see IPage#dispose
 */
public void dispose()
{
	if(_view != null && _view.getControl() != null)
		super.dispose();
	
	if(_view != null)
	  _view.dispose();
	  
	_mofObject = null;  
	_view = null;		  
}
/**
 * Returns the SWT control for this page
 *
 * @return the SWT control for this page
 */
public Control getControl() {
	return _view.getControl();
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 3:47:24 PM)
 * @return com.ibm.etools.trace.views.SinglePattern
 */
public SinglePattern getView() {
	return _view;
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 2:54:24 PM)
 */
public void makeActions()
{
	_viewer.makeActions();
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 5:15:22 PM)
 * @return com.ibm.jface.action.Action
 */
public Action next() {
	return ((SinglePatternViewer)_viewer).next();
}
/**
 * Insert the method's description here.
 * Creation date: (8/1/2001 6:31:38 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action openSource() {
	return ((SinglePatternViewer)_viewer).openSource();
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 5:15:22 PM)
 * @return com.ibm.jface.action.Action
 */
public Action previous() {
	return ((SinglePatternViewer)_viewer).previous();
}
/**
 * Insert the method's description here.
 * Creation date: (6/5/2001 2:45:25 PM)
 */
public void refreshPage()
{
	getView().refresh();
}
/**
 * Insert the method's description here.
 * Creation date: (6/5/2001 2:45:25 PM)
 */
public void selectionChanged()
{
	getView().selectionChanged();
}
/**
 * Sets focus to a part in the page.
 */
public void setFocus() {
	_view.getControl().setFocus();
}
/**
 * Insert the method's description here.
 * Creation date: (08/14/2000 5:50:25 PM)
 */
public void update(boolean newPage)
{
	if(_view != null)   
		_view.update(true);
}
/**
 * Insert the method's description here.
 * Creation date: (08/14/2000 5:50:25 PM)
 */
public Action updateBtn()
{
	return ((SinglePatternViewer)_viewer).updateBtn();
}

/**
 * Contribute to the view popup menu
 * @param menu
 */
public void fillContextMenu(IMenuManager menu)
{	
	if(_view != null)
	{
		_view.menuAboutToShow(menu);
	}
}

public boolean isEmpty()
{
	return false;
}

}
