/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.preferences.internal;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;

public class TraceCollectionPreferencePage {

	private TraceProfileCollectionsUI _options;
	private IPreferenceStore _preferenceStore;
	private PreferencePage _preferencePage;

	public TraceCollectionPreferencePage(IPreferenceStore preferenceStore, PreferencePage preferencePage) {
		super();
		_preferenceStore = preferenceStore;
		_preferencePage = preferencePage;
	}

	protected Control createContents(Composite parent) {
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		TraceUIPlugin.getPluginId()+".topp0001");
		
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);

		_options = new TraceProfileCollectionsUI();
		_options.createControl(composite);
		_options.setPreferencePage(_preferencePage);

		_options.enableButtons();

		return composite;
	}

	protected IPreferenceStore doGetPreferenceStore() {
		return _preferenceStore;
	}
	public void init(IWorkbench workbench) {
	}

	private void initializeDefaults() {
		_options.setLimitInvocations(
			_preferenceStore.getDefaultBoolean(
				TraceConstants.LIMIT_TRACE_INVOC_OPTION));
		_options.setLimitInvocNb(
			_preferenceStore.getDefaultString(TraceConstants.LIMIT_INVOC_NB));

		_options.setLimitTime(
			_preferenceStore.getDefaultBoolean(
				TraceConstants.LIMIT_TRACE_TIME_OPTION));
		_options.setLimitTimeNb(
			_preferenceStore.getDefaultString(TraceConstants.LIMIT_TIME_NB));
	}

	protected void performDefaults() {
		initializeDefaults();
	}

	public boolean performOk() {
		storeValues();
		UIPlugin.getDefault().savePluginPreferences();
		return true;
	}

	private void storeValues() {
		_preferenceStore.setValue(
			TraceConstants.LIMIT_TRACE_INVOC_OPTION,
			_options.getLimitInvocations());
		_preferenceStore.setValue(
			TraceConstants.LIMIT_TRACE_TIME_OPTION,
			_options.getLimitTime());
		_preferenceStore.setValue(
			TraceConstants.LIMIT_INVOC_NB,
			_options.getLimitInvocNb());
		_preferenceStore.setValue(
			TraceConstants.LIMIT_TIME_NB,
			_options.getLimitTimeNb());
	}
}
