/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.remote;

public class QueueManager {

    private String[] _queue = new String[100];
    private int _lastMessageIndex = -1;
    private boolean _rolledOver = false;

    public synchronized void flushCurrentQueue(RemoteComponentSkeleton aAgent) {
        //** flush oldest portion of queue first, then loop
        //** back to the begining to get the latest. Each time you log
        //** null the message location.
        try {
            if (_rolledOver) {
                for (int i = _lastMessageIndex + 1; i < _queue.length; i++) {
                    if (_queue[i] != null) {
                        aAgent.logMessageUTF8(_queue[i]);
                    }
                    _queue[i] = null;
                }
            }
            for (int i = 0; i <= _lastMessageIndex; i++) {
                aAgent.logMessageUTF8(_queue[i]);
                _queue[i] = null;
            }
            //** clean up
            _rolledOver = false;
            _lastMessageIndex = -1;

        }
        catch (Exception e) {
            e.printStackTrace();
        }

    }

    public synchronized void insertInQueue(String logRecord) {
        _queue[++_lastMessageIndex] = logRecord;
        if (_lastMessageIndex == (_queue.length - 1)) {
            _lastMessageIndex = -1;
            _rolledOver = true;
        }

    }

    public boolean isFlushNeeded() {
        //** if the queue is not empty, we need to flush it.
        return !(_lastMessageIndex == -1) || _rolledOver;
    }
}
