/*
 * Created on May 3, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.hyades.trace.internal.ui;

import java.util.*;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyFactoryImpl;
import org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleDataProcessor;
import org.eclipse.hyades.trace.ui.internal.console.ConsoleManager;
import org.eclipse.hyades.trace.ui.internal.util.ColorManager;
import org.eclipse.hyades.trace.ui.internal.util.TraceManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

/**
 * @author popescu
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TraceUIManager
							implements ISelectionListener, ISelectionChangedListener

{

    private static TraceUIManager traceUIManager;
    
	protected ResourceSet resourceSet;
	protected HierarchyFactory factory;
	protected TraceManager fTraceManager;
	protected ConsoleManager fConsoleManager;

	protected HashMap fSelectionModel = new HashMap();
	protected ProfileEvent fProfileEvent = new ProfileEvent();
	protected ViewSelectionChangedEvent pdViewEvent = new ViewSelectionChangedEvent();
	protected ProfileEvent updateModelEvent =
		new ProfileEvent(ProfileEvent.UPDATE_MODEL);
	protected ProfileEvent refreshViewsEvent =
		new ProfileEvent(ProfileEvent.REFRESH_VIEWS);

    private TraceUIManager()
    {
    }
    
	/**
	 * The collection of profile event listeners.
	 */
	protected ListenerList fProfileEventListeners = new ListenerList(20);

	/**
	 * The collection of problem determination view event listeners.
	 */
	protected ListenerList fPDViewEventListeners = new ListenerList(20);

	/**
	 * The desktop parts that contain the selections
	 */
	protected List fSelectionParts = new ArrayList(2);

	/**
	 * The selection providers for the trace UI
	 */
	protected List fSelectionProviders = new ArrayList(2);

	/**
	 * The list of selection listeners for the trace UI
	 */
	protected ListenerList fListeners = new ListenerList(2);

    /**
     * list of delete listeners
     */
	protected ArrayList fDeleteListener = new ArrayList(1);

    /**
     * 
     * @return traceUIManager singleton
     */
    public static TraceUIManager getTraceUIManager()
    {
    	if(traceUIManager == null)
    	  traceUIManager = new TraceUIManager();
    	   
    	return traceUIManager;   
    }
    
    /**
     * 
     * @return console manager
     */
	public ConsoleManager getConsoleManager() {
		if (fConsoleManager == null)
			fConsoleManager = new ConsoleManager();

		return fConsoleManager;
	}

	/**
	 * Adds an <code>ISelectionListener</code> to the trace selection manager.
	 */
	public void addSelectionListener(ISelectionListener l) {
		fListeners.add(l);
	}

	/**
	 * Remove an <code>ISelectionListener</code> to the trace selection manager.
	 */
	public void removeSelectionListener(ISelectionListener l) {
		fListeners.remove(l);
	}

	/**
	 * Adds the selection provider for the debug UI.
	 */
	public void addSelectionProvider(
		ISelectionProvider provider,
		IWorkbenchPart part) {
		fSelectionProviders.add(provider);
		fSelectionParts.add(part);
		provider.addSelectionChangedListener(this);
	}

	/**
	 * Remove the console for this process
	 * @param process
	 */
	public void deregisterLaunchProcess(TRCProcessProxy process) {
		getConsoleManager().deregisterLaunchProcess(process);
	}

	/**
	 * Returns the color manager to use in the debug UI
	 */
	public ColorManager getColorManager() {
		return fConsoleManager.getColorManager();
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (12/28/2000 1:05:55 PM)
	 * @return com.ibm.etools.perftrace.PerftraceFactory
	 */
	public HierarchyFactory getPerftraceFactory() {
		return factory;
	} 	/**
	 * 
	 * @return ResourceSet
	 */
	public ResourceSet getResourceSet() {
		
		if(resourceSet == null)
		{			
			HierarchyPackageImpl.init();
			factory = new HierarchyFactoryImpl();

			// init resourceSet
			resourceSet = HierarchyResourceSetImpl.getInstance();			
		}
		
		return resourceSet;
		
	}
	
	/**
	 * Returns trace manager.
	 */
	public TraceManager getTraceManager() {

		if (fTraceManager == null)
			fTraceManager = new TraceManager();

		return fTraceManager;
	}
	
	/**
	 * 
	 * @param console
	 */
	public void registerLaunchProcess(ConsoleDataProcessor console) {
		getConsoleManager().registerLaunchProcess(console);
	}

	/**
	 * Removes the selection provider from the debug UI.
	 */
	public void removeSelectionProvider(
		ISelectionProvider provider,
		IWorkbenchPart part) {
		fSelectionProviders.remove(provider);
		fSelectionParts.remove(part);
		provider.removeSelectionChangedListener(this);
		selectionChanged(null);
	}
	
	/**
	 * Selection has changed in the debug selection provider.
	 * Notify the listeners.
	 */
	public void selectionChanged(SelectionChangedEvent event) {

		Object[] copiedListeners = fListeners.getListeners();
		ISelection selection = null;
		ISelectionProvider provider = null;
		IWorkbenchPart part = null;
		if (event != null) {
			selection = event.getSelection();
			provider = (ISelectionProvider) event.getSource();
			int index = fSelectionProviders.indexOf(provider);
			if (index == -1) {
				return;
			}
			part = (IWorkbenchPart) fSelectionParts.get(index);
		}
		for (int i = 0; i < copiedListeners.length; i++) {
			((ISelectionListener) copiedListeners[i]).selectionChanged(
				part,
				selection);
		}

	}
	/**
	 * @see ISelectionListener
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection sel) {
		getConsoleManager().selectionChanged(part, sel);
	}

	/**
	 * Dispose all resources on this plugin shut down
	 */
	public void dispose() {
		
		if(fConsoleManager != null)
			fConsoleManager.getColorManager().dispose();
		
		fListeners.clear();
		fDeleteListener.clear();
		fSelectionParts.clear();
		fSelectionProviders.clear();
		resourceSet = null;
		factory = null;
		
		fPDViewEventListeners.clear();
		fDeleteListener.clear();
		fProfileEventListeners.clear();
		fSelectionModel.clear();
		fProfileEvent = null;
		pdViewEvent = null;
		refreshViewsEvent = null;
		updateModelEvent = null;		
		
		if(fTraceManager != null)
			fTraceManager.getTraces().clear();
		fTraceManager = null;
	}
	
	/**
	 * Adds the given listener to the collection of registered profile
	 * event listeners. Has no effect if an identical listener is already
	 * registered.
	 *
	 * @param listener the listener to add
	 */
	public void addProfileEventListener(IProfileEventListener listener) {
		fProfileEventListeners.add(listener);
	}
	
	/**
	 * Removes the given listener from the collection of registered profile
	 * event listeners. Has no effect if an identical listener is not already
	 * registered.
	 *
	 * @param listener the listener to remove
	 */
	public void removeProfileEventListener(IProfileEventListener listener) {
		fProfileEventListeners.remove(listener);
	}

	
	/**
	 * Insert the method's description here.
	 * Creation date: (5/25/2001 3:24:32 PM)
	 * @param listener com.ibm.etools.pd.core.IDeleteListener
	 */
	public void addDeleteListener(IDeleteListener listener) {
		fDeleteListener.add(listener);
	}


	/**
	 * Adds the given listener to the collection of registered pd view
	 * event listeners. Has no effect if an identical listener is already
	 * registered.
	 *
	 * @param listener the listener to add
	 */
	public void addViewSelectionChangedListener(IViewSelectionChangedListener listener) {
		fPDViewEventListeners.add(listener);
	}


	/**
	 * 
	 * @param mofObject
	 * @param model
	 */
	public void addSelectionModel(EObject mofObject, ITraceSelection model) {
		fSelectionModel.put(mofObject, model);
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (5/25/2001 3:25:42 PM)
	 * @return java.util.ArrayList
	 */
	public ArrayList getDeleteListeners() {
		return fDeleteListener;
	}

	public ViewSelectionChangedEvent getViewSelectionChangedEvent() {
		return pdViewEvent;
	}


	public ProfileEvent getProfileEvent() {
		return fProfileEvent;
	}


	/**
	 * @return ProfileEvent
	 */
	public ProfileEvent getRefreshViewEvent(Object source) {
		refreshViewsEvent.setSource(source);
		return refreshViewsEvent;
	}


	/**
	 * 
	 * @param mofObject
	 * @return SelectionModel
	 */
	public ITraceSelection getSelectionModel(EObject mofObject) {

		Object model = fSelectionModel.get(mofObject);
		if (model == null) {
			model = new TraceSelection();
			fSelectionModel.put(mofObject, model);
		}

		return (ITraceSelection) model;
	}


	/**
	 * @return ProfileEvent
	 */
	public ProfileEvent getUpdateModelEvent(Object source) {
		updateModelEvent.setSource(source);
		return updateModelEvent;
	}


	/**
	 * 
	 * @param event
	 */
	public void notifyViewSelectionChangedListener(ViewSelectionChangedEvent event) {
		Object[] listeners = fPDViewEventListeners.getListeners();
		for (int idx = 0; idx < listeners.length; idx++) {
			((IViewSelectionChangedListener) listeners[idx]).handleViewSelectionChangedEvent(event);
		}
	}


	/**
	 * 
	 * @param event
	 */
	public void notifyProfileEventListener(ProfileEvent event) {
		Object[] listeners = fProfileEventListeners.getListeners();
		for (int idx = 0; idx < listeners.length; idx++) {
			((IProfileEventListener) listeners[idx]).handleProfileEvent(event);
		}
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (10/03/2002 3:24:32 PM)
	 * @param listener com.ibm.etools.pd.core.IDeleteListener
	 */
	public void removeDeleteListener(IDeleteListener listener) {
		fDeleteListener.remove(listener);
	}


	/**
	 * Removes the given listener from the collection of registered pd view
	 * event listeners. Has no effect if an identical listener is not already
	 * registered.
	 *
	 * @param listener the listener to remove
	 */
	public void removeViewSelectionChangedListener(IViewSelectionChangedListener listener) {
		fPDViewEventListeners.remove(listener);
	}


	/**
	 * 
	 * @param mofObject
	 */
	public void removeSelectionModel(EObject mofObject) {
		fSelectionModel.remove(mofObject);
	}

}
