/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

import java.util.*;
import java.text.*;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.security.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;

/**
 * This class provides static methods for some of the
 * very used IString operations
 */

public class HyadesUtil
{
	/**
	 * Test the RAC connection on a host with given port number
	 */
	public static final int CONNECTION_SUCCESS = 0;
	public static final int CONNECTION_CONTROLLER_ERROR = 1;
	public static final int CONNECTION_HOST_ERROR = 2;
	public static final int CONNECTION_PORT_ERROR = 3;
	
  private static StringBuffer tmpBuffer = new StringBuffer();

   // change all occurrences of oldPat to newPat
   public  static String change(String in, String oldPat, String newPat)
   {
	  if (oldPat.length() == 0)
		 return in;
	  if (oldPat.length() == 1 && newPat.length() == 1)
		 return in.replace(oldPat.charAt(0), newPat.charAt(0));

	  int lastIndex = 0;
	  int newIndex = 0;
	  tmpBuffer.setLength(0);
	  
	  for(;;)
	  {
		 newIndex = in.indexOf(oldPat, lastIndex);
		 if (newIndex != -1)
		 {
			tmpBuffer.append(in.substring(lastIndex, newIndex)).append(newPat);
			lastIndex = newIndex + oldPat.length();
		 }
		 else
		 {
			tmpBuffer.append(in.substring(lastIndex));
			break;
		 }
	  }
	  return tmpBuffer.toString();
   }   
         /**
 * Insert the method's description here.
 * Creation date: (4/19/2001 4:59:39 PM)
 * @return java.lang.String
 * @param process com.ibm.etools.perftrace.TRCAgent
 */
public static String getAgentName(TRCAgentProxy agent)
{
	String type = agent.getType();
	String name = agent.getName();
	if(name == null)
	  name = "";
	  
	if(type.equals(HyadesConstants.PROFILE_AGENT_TYPE))
	{
		if(!name.equals(HyadesConstants.J2EE_AGENT_NAME))
			name = UIPlugin.getResourceString("TRACE_NAME");
	}
	else if(type.equals(HyadesConstants.LOG_AGENT_TYPE))
	{
			if(name.equals(""))
				name = UIPlugin.getResourceString("LOG_NAME");
	}
	 	
	if (agent.getStartTime() > 0)
	{
		Date date = new Date((long)agent.getStartTime() * 1000);
		String timestamp = DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.MEDIUM).format(date);
		name += " (" + timestamp + ")";
	}
	
	return name;
}
/**
 * Insert the method's description here.
 * Creation date: (4/19/2001 4:59:39 PM)
 * @return java.lang.String
 * @param process com.ibm.etools.perftrace.TRCProcess
 */
public static String getProcessName(TRCProcessProxy process)
{
	tmpBuffer.setLength(0);
	
	return tmpBuffer.append(process.getName()).append(" [ PID:").append(process.getPid()).append(" ]").toString();

}
   public static String getAgentLabel(TRCAgentProxy a)
   {
   	  tmpBuffer.setLength(0);
   	  
	  if (a.isActive() && a.isMonitored()) tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_MONITORED"));	  	        
	  else if (a.isActive() && a.isAttached()) tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_ATTACHED"));
	  else if (a.isActive()) tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_DETACTED"));	  
	  else tmpBuffer.append("<").append(UIPlugin.getResourceString("AGENT_TERMINATED"));
	  
	  if(a.isCollectionData())
	      tmpBuffer.append(UIPlugin.getResourceString("STR_COLLECTING")).append(">");
	  else
	      tmpBuffer.append(">");    
	  	  
	  return tmpBuffer.toString();   	  
   }  
          
   public static int testConnection(String host, String port,boolean message)
   {
	   if (host == null || host.trim() == "" || port == null || port.trim() == "")
	   {
		   String text = UIPlugin.getResourceString("INVALID_HOST");
		   Status err = new Status(Status.WARNING,ResourcesPlugin.PI_RESOURCES,IResourceStatus.WARNING,text,null);
		   ErrorDialog.openError(UIPlugin.getActiveWorkbenchShell(),UIPlugin.getResourceString("STR_TITLE_MSG")
		               ,UIPlugin.getResourceString("CONNECT_ERROR_"),err);
		
		   return CONNECTION_HOST_ERROR;
	   }
	
	   IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();	
	   ConnectUtil util = new ConnectUtil(host, port, store.getString(HyadesConstants.SECURE_USERID), UIPlugin.getDefault());
	   int result = util.connect();
	   if(result == ConnectUtil.CONNECTION_SUCCESS)
	   {//store the user id
		   store.setValue(HyadesConstants.SECURE_USERID, util.getUserId());
		
		   if(message)
		   {
			   String text = UIPlugin.getResourceString("CONNECTION_SUCCESS_TEXT");
			   MessageDialog.openInformation(UIPlugin.getActiveWorkbenchShell(),UIPlugin.getResourceString("STR_HYADES_MSG"),text);
		   }
		
	   }
	
	   return result;
   }

   /**
	* 
	* @return selected trace or log object in the Profiling Monitors view
	*/
   public static EObject getSelectedObject()
   {
	   IWorkbenchPage page = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
	   if(page == null || !page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE) )
		 return null;
	  
	   IViewPart monitorsView = page.findView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
	   if(monitorsView == null || !(monitorsView instanceof PDProjectExplorer))
		 return null;  
	  
	   TreeItem item = null;  
	   PDProjectViewer viewer = ((PDProjectExplorer)monitorsView).getViewer();
	   if(viewer != null)
		  item = viewer.getTreeSelection();
	   
	   if(item == null || !(item.getData() instanceof EObject))
		 return null;
	  
	   return (EObject)item.getData();  
   }
   
}
