/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.console;

import org.eclipse.hyades.internal.execution.local.common.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;

public class ConsoleDataProcessor implements DataProcessor 
{						
	private TRCProcessProxy fProcess;
	private Console         fConsole;
/**
 * XMLDataProcessor constructor comment.
 */
public ConsoleDataProcessor(TRCProcessProxy process)
{
	super();

	fProcess = process;
}
/**
 * Insert the method's description here.
 * Creation date: (5/23/2001 2:09:04 PM)
 * @return com.ibm.etools.perftrace.TRCProcessProxy
 */
public TRCProcessProxy getProcess() {
	return fProcess;
}
/**
 * Insert the method's description here.
 * Creation date: (3/1/01 12:06:07 PM)
 * @param buffer byte[]
 * @param length int
 * @param peer java.net.InetAddress
 */
public void incommingData(byte[] buffer, int length, java.net.InetAddress peer)
{
	TraceConsoleDocument doc = (TraceConsoleDocument)UIPlugin.getDefault().getConsoleManager().getConsoleDocument(fProcess);
	if(doc != null)
	{
		doc.streamAppended(makeString(buffer, 0, length), 0);
	}
}
/**
 * Insert the method's description here.
 * Creation date: (3/1/01 12:06:07 PM)
 * @param buffer char[]
 * @param length int
 * @param peer java.net.InetAddress
 */
public void incommingData(char[] buffer, int length, java.net.InetAddress peer) {
	/* This is incredably inefficient, will have to change everything to binary data */
	byte[] newBuffer=new byte[length];
	for(int i=0; i<length; i++) {
		newBuffer[i]=(byte)buffer[i];
	}
	
	TraceConsoleDocument doc = (TraceConsoleDocument)UIPlugin.getDefault().getConsoleManager().getConsoleDocument(fProcess);
	if(doc != null)
	{
		doc.streamAppended(new String(buffer, 0, length), 0);
	}
	
}
/**
 * Insert the method's description here.
 * Creation date: (3/1/01 12:06:07 PM)
 * @param data byte[]
 * @param length int
 * @param peer java.net.InetAddress
 */
public void invalidDataType(byte[] data, int length, java.net.InetAddress peer) {}
private String makeString(byte[] data, int offset, int length) {
	if(data==null) {
		return null;
	}
	try {
		return new String(data, offset, length/*, "UTF8"*/);
	} catch (Exception ex) {
		return null;
	}
}
/**
 * Insert the method's description here.
 * Creation date: (5/29/2001 10:36:51 AM)
 * @param console com.ibm.etools.logging.tracing.common.Console
 */
public void setConsole(Console console)
{
	fConsole = console;
}
/**
 * Insert the method's description here.
 * Creation date: (5/24/2001 2:11:28 PM)
 * @param process com.ibm.etools.perftrace.TRCProcessProxy
 */
public void setProcess(TRCProcessProxy process)
{
	fProcess = process;
}
/**
 * Insert the method's description here.
 * Creation date: (3/1/01 12:06:07 PM)
 */
public void waitingForData() {}
/**
 * Insert the method's description here.
 * Creation date: (5/29/2001 10:37:34 AM)
 * @param text java.lang.String
 */
public void write(String text)
{
	if(fConsole != null && text != null)
	  fConsole.write(text);
}

public void dispose()
{
	fProcess = null;
	
	fConsole.close();
	fConsole = null;
}
}
