/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import java.io.*;
import java.util.*;

import org.eclipse.swt.layout.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.window.Window;

/*
* CONTEXT_ID lpui0000 for classname entry field in launch process ui
*/
/*
* CONTEXT_ID lpui0001 for classpath entry field in launch process ui
*/
/*
* CONTEXT_ID lpui0005 for parameters entry field in launch process ui
*/
/*
* CONTEXT_ID lpui0006 for vm arguments entry field in launch process ui
*/

public class LaunchProcessUI implements SelectionListener
{
	private Composite _classGroup;
	private Composite _paramGroup;
	private Text      _classname;
	private Text      _parameters; 
	private Text      _classpath;
	private Text      _vmArgs;
	private Button    _browseClass;
	private Button    _browseDirPath;
	private Button    _browseJarPath; 
	private Button    _envButton; 
	private ArrayList _envData;
	private boolean  _envEditEnable; 
	private Shell shell;
		
  public LaunchProcessUI()    
  {
	super();
	_envData = new ArrayList();
  }  
/**
 * Insert the method's description here.
 * Creation date: (8/10/2001 12:39:10 PM)
 * @return org.eclipse.swt.widgets.Composite
 * @param parent org.eclipse.swt.widgets.Composite
 */
public Composite createArgumentsControl(Composite parent)
{
	GridData gd;
	
	_paramGroup = new Composite( parent, SWT.NULL );   
	_paramGroup.setLayoutData( GridUtil.createHorizontalFill() );	
	GridLayout layout = new GridLayout();
	layout.numColumns = 2;  
	layout.verticalSpacing=3;
	gd = GridUtil.createFill();
	_paramGroup.setLayoutData(gd);	
	   
	_paramGroup.setLayout( layout );
		
	Label label = new Label(_paramGroup, SWT.NULL);
	gd = new GridData();
	gd.verticalAlignment = GridData.BEGINNING;  
	label.setText(UIPlugin.getResourceString("CLASSPATH"));
	label.setLayoutData(gd);

	Composite pathGroup = new Composite(_paramGroup, SWT.NULL);
	layout = new GridLayout();
	layout.numColumns = 2;  
	layout.verticalSpacing=5;
	gd = GridUtil.createHorizontalFill();
	pathGroup.setLayoutData(gd);
	pathGroup.setLayout(layout);	
	   	   
	_classpath = new Text(pathGroup, SWT.BORDER|SWT.MULTI|SWT.H_SCROLL|SWT.V_SCROLL|SWT.WRAP);
	gd = GridUtil.createFill();
	gd.heightHint = 50;
	gd.widthHint = 90;	
	_classpath.setLayoutData(gd);

    Composite btnGroup = new Composite(pathGroup, SWT.NULL);
	gd = GridUtil.createVerticalFill();
	layout = new GridLayout();
	layout.numColumns = 1;
	btnGroup.setLayoutData(gd);
	btnGroup.setLayout(layout);
    
	_browseDirPath = new Button(btnGroup,  SWT.CENTER | SWT.PUSH);
	
	gd = new GridData();
	gd.horizontalAlignment = GridData.FILL;
	gd.verticalAlignment = GridData.FILL;               	
	_browseDirPath.setLayoutData(gd);
	
	_browseDirPath.setText(UIPlugin.getResourceString("ADD_DIRECTORY"));
	_browseJarPath = new Button(btnGroup,  SWT.CENTER | SWT.PUSH);
	
	gd = new GridData();
	gd.horizontalAlignment = GridData.FILL;
	gd.verticalAlignment = GridData.VERTICAL_ALIGN_BEGINNING;  
	
	_browseJarPath.setLayoutData(gd);
	
	_browseJarPath.setText(UIPlugin.getResourceString("ADD_JAR"));

	label = new Label(btnGroup, SWT.NULL);	
	
	label = new Label(_paramGroup, SWT.NULL);	
	label.setText(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PARAMETER"));
	_parameters = new Text(_paramGroup, SWT.SINGLE | SWT.BORDER);
	gd = GridUtil.createHorizontalFill();
	gd.widthHint = 100; //MW:191013 Must set this so that the setText won't do it if
	                    //    the text is larger than the default layout.
	_parameters.setLayoutData(gd);	

	label = new Label(_paramGroup, SWT.NONE); 
	label.setText(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_VM_ARGS"));
	_vmArgs = new Text(_paramGroup, SWT.SINGLE | SWT.BORDER);
	gd = GridUtil.createHorizontalFill();
	gd.widthHint = 100; //MW:191013 Must set this so that the setText won't do it if
	                    //    the text is larger than the default layout.
	_vmArgs.setLayoutData(gd);
	
	_envButton = new Button(_paramGroup, SWT.NULL);
	gd = GridUtil.createHorizontalFill();
	gd.horizontalSpan = 2;
	gd.horizontalAlignment = GridData.END;	
	_envButton.setLayoutData(gd);
	_envButton.setText(UIPlugin.getResourceString("ENV_VARIABLE_BUTTON"));	
	
	//add listeners
	_browseDirPath.addSelectionListener(this);
	_browseJarPath.addSelectionListener(this);  
	_envButton.addSelectionListener(this);  

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_classpath,
		UIPlugin.getPluginId()+".lpui0001");
	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_parameters,
		UIPlugin.getPluginId()+".lpui0005");  

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_vmArgs,
		UIPlugin.getPluginId()+".lpui0006");  
	
	
	return _paramGroup;
}
/**
 * Insert the method's description here.
 * Creation date: (8/10/2001 12:39:10 PM)
 * @return org.eclipse.swt.widgets.Composite
 * @param parent org.eclipse.swt.widgets.Composite
 */
public Composite createClassControl(Composite parent)
{
	_classGroup = new Composite( parent, SWT.NULL );   
	_classGroup.setLayoutData( GridUtil.createHorizontalFill() );	
	GridLayout layout = new GridLayout();
	layout.numColumns = 3;  
	layout.verticalSpacing=2;   
	_classGroup.setLayout( layout );
	
	Label label = new Label(_classGroup, SWT.NONE);
	label.setText(UIPlugin.getResourceString("CLASS_NAME"));
	_classname = new Text(_classGroup, SWT.SINGLE | SWT.BORDER);
	_classname.setLayoutData(GridUtil.createHorizontalFill());
	
	_browseClass = new Button(_classGroup,  SWT.CENTER | SWT.PUSH);
	GridData gd = new GridData();
	gd.horizontalAlignment = GridData.FILL;
	_browseClass.setLayoutData(gd);
	_browseClass.setText(UIPlugin.getResourceString("BROWSE"));	

	//add listeners
	_browseClass.addSelectionListener(this);
	_classname.setFocus();

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_classname,
		UIPlugin.getPluginId()+".lpui0000");
	
	return _classGroup;
}
  public Composite createControl(Composite parent)
  {
	Label label;
 
	Composite content = new Composite(parent, SWT.NULL);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=2;       
	content.setLayout(layout);
	GridData gd = GridUtil.createFill();
	gd.horizontalIndent = 20;
	content.setLayoutData(gd);

	createClassControl(content);
	createArgumentsControl(content);
				
	_classname.setFocus();

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		UIPlugin.getPluginId()+".lpui0000");

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		content,
		UIPlugin.getPluginId()+".lpui0000");
		
	return content;
  }    
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 2:39:07 PM)
 * @param enable boolean
 */
public void enable(boolean enableClassName, boolean enableArgs
				   , boolean enableBrowseClass, boolean enableBrowseArgs, boolean enableEnv)
{
	_classname.setEnabled(enableClassName);
	_browseClass.setEnabled(enableBrowseClass);

	_classpath.setEnabled(enableArgs);		
	_parameters.setEnabled(enableArgs);
	_vmArgs.setEnabled(enableArgs);	
	_browseDirPath.setEnabled(enableBrowseArgs);
	_browseJarPath.setEnabled(enableBrowseArgs);   
	
	_envEditEnable = enableEnv;
	
	if(enableClassName)
	{
	  _classname.setFocus();
	  _classname.selectAll();
	}
}
/**
 * Insert the method's description here.
 * Creation date: (8/10/2001 12:55:58 PM)
 * @return org.eclipse.swt.widgets.Composite
 */
public Composite getClassGroup() {
	return _classGroup;
}
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 12:25:04 PM)
 * @return java.lang.String
 */
public String getClassName() {
	return _classname.getText().trim();
}
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 12:25:04 PM)
 * @return java.lang.String
 */
public String getClassPath()
{
	return _classpath.getText().trim();
}
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 12:25:04 PM)
 */
public Text getClassPathUI() {
	return _classpath;
}
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 12:25:04 PM)
 * @return java.lang.String
 */
public Text getClassUI() {
	return _classname;
}

public Control getBrowseJarButton() {
	return _browseJarPath;
}

public Control getBrowseDirButton() {
	return _browseDirPath;
}
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 12:25:04 PM)
 * @return java.lang.String
 */
public String getParameters() {
	return _parameters.getText().trim();
}
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 12:25:04 PM)
 * @return java.lang.String
 */
public Text getParametersUI() {
	return _parameters;
}
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 12:25:04 PM)
 * @return java.lang.String
 */
public String getVMArgs() {
	return _vmArgs.getText().trim();
}
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 12:25:04 PM)
 * @return Text
 */
public Text getVMArgsUI() {
	return _vmArgs;
}
/**
 * Insert the method's description here.
 * Creation date: (5/8/2001 12:25:04 PM)
 * @return java.lang.String
 */
public ArrayList getEnvData() {
	return _envData;
}

public void setEnvData(ArrayList envData)
{
	_envData=envData;
}
/**
 * Insert the method's description here.
 * Creation date: (08/21/2000 7:49:33 PM)
 * @param event com.ibm.swt.events.SelectionEvent
 */

public void setShell(Shell shell)
{
	this.shell=shell;
}
public void widgetDefaultSelected(SelectionEvent event) {}
/**
 * Insert the method's description here.
 * Creation date: (08/21/2000 7:49:33 PM)
 * @param e com.ibm.swt.events.SelectionEvent
 */
public void widgetSelected(SelectionEvent e)
{
	if (shell==null)
		shell = UIPlugin.getActiveWorkbenchWindow().getShell();
	
	String osName = System.getProperty("os.name");
		
	if(e.widget == _browseClass)
	{
		FileDialog dlg = new FileDialog(shell);
		dlg.setFilterExtensions(new String[] {"*.class"});
		dlg.open();

		String fileName = dlg.getFileName();
		if(fileName != null && !fileName.equals(""))
		{
		  if(fileName.endsWith(".class"))
			   fileName = fileName.substring(0, fileName.length()-6);

		   _classname.setText(fileName);
		   
		   String classpath = dlg.getFilterPath();
			if ((osName != null) && (osName.startsWith("Windows")) && (classpath.endsWith(":")))
			{
			 	classpath += "\\";
			}

			String oldClassPath=_classpath.getText().trim();                   
			oldClassPath=oldClassPath.equals("")||oldClassPath.endsWith(File.pathSeparator)?
						oldClassPath:oldClassPath+File.pathSeparator;
			_classpath.setText(oldClassPath+classpath);

		}       
		
	}
	else if(e.widget == _browseDirPath)
	{
		DirectoryDialog dlg = new DirectoryDialog(shell);
		String classpath = dlg.open();
		
		if(classpath != null && !classpath.equals(""))
		{

			if ((osName != null) && (osName.startsWith("Windows")) && (classpath.endsWith(":")))
			{
				classpath += "\\";
			}

			String oldClassPath=_classpath.getText().trim();
			oldClassPath=oldClassPath.equals("")||oldClassPath.endsWith(File.pathSeparator)?
						oldClassPath:oldClassPath+File.pathSeparator;
			//if(!oldClassPath.equals("")) oldClassPath+="\n";	
			classpath = oldClassPath+classpath;	
			_classpath.setText(classpath);
			_classpath.setFocus();
		}
		
	}
	else if(e.widget == _browseJarPath)
	{
		FileDialog dlg = new FileDialog(shell);
		dlg.setFilterExtensions(new String[] {"*.jar;*.zip"});       
		dlg.open();

		String classpath = dlg.getFileName();

		if(classpath != null && !classpath.equals(""))
		{
			classpath = dlg.getFilterPath() + File.separator + classpath;

			String oldClassPath=_classpath.getText().trim();
			oldClassPath=oldClassPath.equals("")||oldClassPath.endsWith(File.pathSeparator)?
						oldClassPath:oldClassPath+File.pathSeparator;
			classpath = oldClassPath+classpath;					
			_classpath.setText(classpath);
		}               
	}
	else if(e.widget == _envButton)
	{
		EnvironmentDialog dialog =
			new EnvironmentDialog(_envButton.getShell(), UIPlugin.getResourceString("ENV_VARIABLE_TEXT"), _envData, _envEditEnable);
		dialog.open();

		if (dialog.getReturnCode() == Window.OK) {
			if(_envData == null)
			  _envData = new ArrayList();
			  
			_envData.clear();  
			_envData.addAll(dialog.getData());
		}
		
	}
	
}
}
