/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

/*
* CONTEXT_ID tbpp0001 for Enable Profiling checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0002 for Enable JVM RAS information checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0003 for Enable Logging checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0004 for Default Trace Project Name entry field in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0005 for Enable Profiling Tips checkbox in Profiling(Trace) preference page
*/
/*
* CONTEXT_ID tbpp0006 for Local IBM Remote Agent port number entry field in Profiling(Trace) preference page
*/

public class TraceOptionsUI implements SelectionListener, ModifyListener
{
	private Button _enableProf;
	private Button _enableLog;
	private Button _enableInfoMsg;
	private Text _projectName;
	private Text _localPort;
    private PreferencePage _preferencePage;
/**
 * TraceOptionsUI constructor comment.
 */
public TraceOptionsUI(PreferencePage preferencePage) {
	super();
	_preferencePage = preferencePage;
	
}

public TraceOptionsUI() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	GridLayout layout;
	GridData data;
	
	Composite content = new Composite(parent, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 3;
	content.setLayout(layout);
	content.setLayoutData(GridUtil.createHorizontalFill());

	_enableProf = new Button(content, SWT.CHECK);
	_enableProf.setText(UIPlugin.getResourceString("ENABLE_PROFILE_TEXT"));
	data = new GridData();
	data.horizontalSpan = 3;
	_enableProf.setLayoutData(data);
		
	_enableLog = new Button(content, SWT.CHECK);
	_enableLog.setText(UIPlugin.getResourceString("ENABLE_LOGGING"));
	data = new GridData();
	data.horizontalSpan = 3;
	_enableLog.setLayoutData(data);

	_enableInfoMsg = new Button(content, SWT.CHECK);
	_enableInfoMsg.setText(UIPlugin.getResourceString("SHOW_PROFILE_TIPS"));
	data = new GridData();
	data.horizontalSpan = 3;
	_enableInfoMsg.setLayoutData(data);
	
	_enableProf.addSelectionListener(this);
	
	Label desc = new Label(content, SWT.NULL);
	desc.setText(UIPlugin.getResourceString("TRACEOPTIONSUI_TEXT"));
	_projectName = new Text(content, SWT.BORDER);
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;
	_projectName.setLayoutData(data);

	Label portdesc = new Label(content, SWT.NULL);
	portdesc.setText(UIPlugin.getResourceString("RAC_LOCALHOST_PORT_TEXT"));
	_localPort = new Text(content, SWT.BORDER);
	data = GridUtil.createHorizontalFill();
	data.horizontalSpan = 2;
	_localPort.setLayoutData(data);
	_localPort.addModifyListener(this);
		
	initializeValues();
	/*
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_enableProf,
		UIPlugin.getPluginId()+".tbpp0001");

	if(_enableLog.isVisible())
	{
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_enableLog,
			UIPlugin.getPluginId()+".tbpp0003");
	}
	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_projectName,
		UIPlugin.getPluginId()+".tbpp0004");

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_enableInfoMsg,
		UIPlugin.getPluginId()+".tbpp0005");

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_localPort,
		UIPlugin.getPluginId()+".tbpp0006");
*/
	
	return content; 
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 10:44:50 AM)
 * @return boolean
 */
public boolean getLogOption() {
	return _enableLog.getSelection();
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 10:44:50 AM)
 * @return boolean
 */
public boolean getProfOption() {
	return _enableProf.getSelection();
}

public boolean getInfoMsgOption(){
	return _enableInfoMsg.getSelection();
}

/**
 * Insert the method's description here.
 * Creation date: (5/10/2001 5:49:55 PM)
 * @return java.lang.String
 */
public String getProjectName() {
	return _projectName.getText().trim();
}

public String getLocalPortNumber() {
	return _localPort.getText().trim();
}

/**
 * Initializes states of the controls from the preference store.
 */
private void initializeValues()
{
	IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

	setProfOption(store.getBoolean(TraceConstants.PROF_OPTION_KEY));
	setInfoMsgOption(store.getBoolean(TraceConstants.PROFILE_TIPS));	

	_enableLog.setSelection(false);
	_enableLog.setVisible(false);	
	setLogOption(store.getBoolean(TraceConstants.LOG_OPTION_KEY));
	_enableLog.setVisible(true);

	setProjectName(store.getString(TraceConstants.TRACE_PROJECT_NAME));
		
	store = UIPlugin.getDefault().getPreferenceStore();

	setLocalHostPort(store.getString(HyadesConstants.LOCALHOST_PORT));
	
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 10:43:06 AM)
 * @param option boolean
 */
public void setLogOption(boolean option)
{
	_enableLog.setSelection(option);
}

public void setInfoMsgOption(boolean option){
	_enableInfoMsg.setSelection(option);
}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 10:43:06 AM)
 * @param option boolean
 */
public void setProfOption(boolean option)
{
	_enableProf.setSelection(option);
}
/**
 * Insert the method's description here.
 * Creation date: (5/10/2001 5:49:10 PM)
 * @param name java.lang.String
 */
public void setProjectName(String name)
{
	_projectName.setText(name);
}

public void setLocalHostPort(String portNum)
{
	_localPort.setText(portNum);
}
/**
 * Sent when default selection occurs in the control.
 * <p>
 * For example, on some platforms default selection occurs
 * in a List when the user double-clicks an item or types
 * return in a Text.
 * </p>
 *
 * @param e an event containing information about the default selection
 */
public void widgetDefaultSelected(SelectionEvent e)
{}
/**
 * Sent when selection occurs in the control.
 * <p>
 * For example, on some platforms selection occurs in
 * a List when the user selects an item or items.
 * </p>
 *
 * @param e an event containing information about the selection
 */
public void widgetSelected(SelectionEvent e)
{
}

public void modifyText(ModifyEvent e)
{
	if (e.widget == _localPort)
	{
		try
		{
			if (_localPort.getText().trim() == "")
			{
				_preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_EMPTY_PORT"));
				return;
			}
			
			int value = Integer.parseInt(_localPort.getText().trim());
			if (value<0)
			{
				_preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
				_localPort.setFocus();
				return;
			}
			_preferencePage.setErrorMessage(null);
		}
		catch (NumberFormatException nfe)
		{
			if (_preferencePage != null)
				_preferencePage.setErrorMessage(UIPlugin.getResourceString("RAC_INVALID_PORT"));
				_localPort.setFocus();
		}
	}
}
}
