/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import java.util.*;

import org.eclipse.hyades.internal.execution.local.common.*;
import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.security.util.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.preference.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/*
* CONTEXT_ID top0001 for My application is too slow in profile options page
* CONTEXT_ID top0002 for My application uses too much memory in profile options page
* CONTEXT_ID top0003 for Collect execution flow information in profile options page
* CONTEXT_ID top0004 for Show &instance level information in profile options page
* CONTEXT_ID top0005 for Show execution flow details in profile options page
* CONTEXT_ID top0006 for Show heap details in profile options page
* CONTEXT_ID top0007 for Show execution flow graphical details in profile options page
* CONTEXT_ID top0008 for Show execution statistic in profile options page
* CONTEXT_ID top0009 for Boundary class depth: in profile options page
*/

public class TraceProfileOptionsUI implements SelectionListener
									   , ModifyListener 
{
    private Button _appHeapBtn;
    private Label _appHeapLabel;
    
	private Button _heapAdvanced;
	private Composite _detailsHeapGroup;
	private Button _showHeapInstance;
	    
    private Button _appExecBtn;
    private Label _appExecLabel;
    
	private Button _boundary;	
	private Label _traceDepthLabel;
	private Text _traceDepth;
	
	private Button _execAdvanced;
	private Composite _detailsExecGroup;
	private Button _showExecStatistic;
	private Button _showExecFlow;

	private boolean _enableHeap = true;
	
	private WizardPage wizardPage;
	private PreferencePage preferencePage;
	
  public TraceProfileOptionsUI()   
  {
	super();
  }
    
  public Composite createControl(Composite parent)
  {
	GridLayout layout;
		
	Composite result = new Composite(parent, SWT.NONE);  

	layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=2;
	
	GridData data = GridUtil.createFill();
	data.heightHint = 300;
	data.widthHint = 400;  
	
	result.setLayout(layout);
	result.setLayoutData(data);
	
	  Composite grp = new Composite( result, SWT.NULL);
	  data = GridUtil.createHorizontalFill();
	  layout = new GridLayout();
	  layout.numColumns = 1;   
	  grp.setLayout(layout);
	  grp.setLayoutData(data);
	  
	  _appHeapBtn = new Button(grp, SWT.CHECK);
	  _appHeapBtn.setText(UIPlugin.getResourceString("STR_TOO_MUCH_MEMORY"));
	  _appHeapBtn.setLayoutData(GridUtil.createHorizontalFill()); 
	  
	  _appHeapLabel = new Label(grp, SWT.WRAP); 
	  _appHeapLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_HEAP"));
	  data = new GridData();      
	  data.horizontalIndent = 20;
	  data.widthHint = 375;
	  _appHeapLabel.setLayoutData(data); 
	
	  _heapAdvanced = new Button(grp, SWT.NULL);
	  _heapAdvanced.setText(UIPlugin.getResourceString("SHOW_DET"));
	    
	  addHeapOption(grp);
	  _detailsHeapGroup.setVisible(false);      
	  _heapAdvanced.addSelectionListener(this);            
	         
	  _appExecBtn = new Button(grp, SWT.CHECK);
	  _appExecBtn.setText(UIPlugin.getResourceString("STR_APP_TOO_SLOW"));
	  _appExecBtn.setLayoutData(GridUtil.createHorizontalFill()); 
	       
	  _appExecLabel = new Label(grp, SWT.WRAP); 
	  _appExecLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_EXE_TIME"));
	  data = new GridData();      
	  data.horizontalIndent = 20;
	  data.widthHint = 375;
	  _appExecLabel.setLayoutData(data); 
	  
	  _execAdvanced = new Button(grp, SWT.NULL);
	  _execAdvanced.setText(UIPlugin.getResourceString("SHOW_DET2"));
	    
	  addExecutionOption(grp);
	  _detailsExecGroup.setVisible(false);
	  
	  _execAdvanced.addSelectionListener(this);            
	  _appHeapBtn.addSelectionListener(this);      
	  _appExecBtn.addSelectionListener(this);
/*	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_appExecBtn,
		UIPlugin.getPluginId()+".top0001");  
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_appHeapBtn,
		UIPlugin.getPluginId()+".top0002"); 
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_boundary,
		UIPlugin.getPluginId()+".top0003"); 
		
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_showHeapInstance,
		UIPlugin.getPluginId()+".top0004"); 
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_execAdvanced,
		UIPlugin.getPluginId()+".top0005"); 
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_heapAdvanced,
		UIPlugin.getPluginId()+".top0006"); 
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_showExecFlow,
		UIPlugin.getPluginId()+".top0007"); 
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_showExecStatistic,
		UIPlugin.getPluginId()+".top0008"); 
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_traceDepth,
		UIPlugin.getPluginId()+".top0009"); 
*/			
	return result;
  }

   private void addHeapOption(Composite parent)
   {
		GridLayout layout;
		GridData data;
   	
		_detailsHeapGroup = new Composite(parent, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalIndent = 20;
	   	_detailsHeapGroup.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns = 1;
		_detailsHeapGroup.setLayout(layout);
				
		_showHeapInstance = new Button(_detailsHeapGroup, SWT.CHECK);
		_showHeapInstance.setText(UIPlugin.getResourceString("STR_SHOW_INST_LEVEL_INFO"));

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_showHeapInstance,
			UIPlugin.getPluginId()+".topp0011");   	
   }
   
   private void addExecutionOption(Composite parent)
   {
		GridLayout layout;
		GridData data;
   	
		_detailsExecGroup = new Composite(parent, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalIndent = 20;
	   	_detailsExecGroup.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns = 2;
		_detailsExecGroup.setLayout(layout);
				
		_boundary = new Button(_detailsExecGroup,SWT.CHECK);	
		data = GridUtil.createHorizontalFill();	
		data.horizontalSpan = 2;
	   	_boundary.setLayoutData(data);
		_boundary.setText(UIPlugin.getResourceString("AGENT_UI_BOUNDARY_CLASS"));
		
		_traceDepthLabel = new Label(_detailsExecGroup, SWT.NULL);
		_traceDepthLabel.setText(UIPlugin.getResourceString("STR_COLLECT_DEPTH"));	
		_traceDepth = new Text(_detailsExecGroup, SWT.BORDER);
		data = new GridData();
		data.widthHint = 70;			
		_traceDepth.setLayoutData(data);
		
		Group _showExecGroup = new Group(_detailsExecGroup, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;
	   	_showExecGroup.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns = 1;
		_showExecGroup.setLayout(layout);
		
		_showExecStatistic = new Button(_showExecGroup, SWT.RADIO);
		_showExecStatistic.setText(UIPlugin.getResourceString("EXEC_STAT"));
		_showExecFlow = new Button(_showExecGroup, SWT.RADIO);
		_showExecFlow.setText(UIPlugin.getResourceString("DETAILED_DATA"));

		_boundary.addSelectionListener(this);
		_traceDepth.addModifyListener(this);
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_boundary,
			UIPlugin.getPluginId()+".topp0002");
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_traceDepth,
			UIPlugin.getPluginId()+".topp0008");
   	
   }
   
public void enable(boolean enable)
{
	_appHeapBtn.setEnabled(enable);
	_appHeapLabel.setEnabled(_appHeapBtn.getEnabled());
	_appExecBtn.setEnabled(enable);
	_appExecLabel.setEnabled(_appExecBtn.getEnabled());
	
	_showHeapInstance.setEnabled(_appHeapBtn.getEnabled());
	
	enableExecutionButtons(_appExecBtn.getEnabled());
}

public void enableExecutionButtons(boolean enable)
{
	_boundary.setEnabled(enable);
	
	_traceDepth.setEnabled(enable);
	_traceDepthLabel.setEnabled(enable);
	
	_showExecStatistic.setEnabled(enable);
	_showExecFlow.setEnabled(enable);
}

public void enableButtons() {

	IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
	
	setHeap(
		store.getBoolean(TraceConstants.PROF_HEAP_STAT));
	setHeapDetails(
		store.getBoolean(TraceConstants.PROF_HEAP_INST));		
	setExecution(
		store.getBoolean(TraceConstants.PROF_EXECUTION));
    setExecutionBoundary(
    	store.getBoolean(TraceConstants.PROF_EXECUTION_BOUNDARY));
    setCollectionDepth(
    	store.getString(TraceConstants.COLLECT_DEPTH)); 
    	
    setExecutionStatistic(
    	store.getBoolean(TraceConstants.PROF_EXEC_STAT)); 
    setExecutionFlow(!
    	store.getBoolean(TraceConstants.PROF_EXEC_STAT)); 
    	      
    enableBtnGroup();
}

public void enableBtnGroup()
{
	enableHeptBtnGroup();
    enableExecutionBtnGroup();    
}

private void enableHeptBtnGroup()
{
	_showHeapInstance.setEnabled(_appHeapBtn.getSelection());
}
private void enableExecutionBtnGroup() {
	if (_appExecBtn.getSelection())
		{
		  _boundary.setEnabled(true);
		  
		  _showExecFlow.setEnabled(true);
		  _showExecStatistic.setEnabled(true);	  
		   
		}
		else 
		{ 
			_boundary.setEnabled(false);
			_boundary.setSelection(false);
			
		  _showExecFlow.setEnabled(false);
		  _showExecStatistic.setEnabled(false);	  
		    
		}
		
	    _traceDepth.setEnabled(_boundary.getSelection());
	    _traceDepthLabel.setEnabled(_boundary.getSelection());	    
}

public void enableHeapInfo(boolean enable) {
	_enableHeap = enable;
	
	if(!enable)
	{
	  _appHeapBtn.setEnabled(false);
	  _showHeapInstance.setEnabled(false);
	}
	   
}

public Vector getOptions()
{
	Vector options = new Vector();
 
    if (!getHeap())
    {
    	String[][] execution = Options.OPTIONS_ANALYZE_HEAP_NONE;
			for(int idx=0; idx<execution.length; idx++)
			{
				AgentConfigurationEntry entry = new AgentConfigurationEntry();
				entry.setName(execution[idx][0]); 
				entry.setValue(execution[idx][1]);
				entry.setType("SETOPTION");
	
				options.addElement(entry);
			}
    }
    else 
 	{
		String[][] execution = Options.OPTIONS_ANALYZE_HEAP;
		for(int idx=0; idx<execution.length; idx++)
		{
			AgentConfigurationEntry entry = new AgentConfigurationEntry();
			entry.setName(execution[idx][0]); 
			entry.setValue(execution[idx][1]);
			entry.setType("SETOPTION");

			options.addElement(entry);
		}				
	}
	
    if(getHeap() && !getExecution())
    {
			String[][] execution = Options.OPTIONS_EXECUTION_FLOW_NONE;
			for(int idx=0; idx<execution.length; idx++)
			{
				AgentConfigurationEntry entry = new AgentConfigurationEntry();
				entry.setName(execution[idx][0]); 
				entry.setValue(execution[idx][1]);
				entry.setType("SETOPTION");
	
				options.addElement(entry);
			}			
			return options;		  		   
    }    	
   
    if(getExecutionBoundary())
	{
			String[][] executionBoundary = Options.OPTIONS_EXECUTION_FLOW_BOUNDARY;		
			for(int idx=0; idx<executionBoundary.length; idx++)
			{
				AgentConfigurationEntry entry = new AgentConfigurationEntry();
				entry.setName(executionBoundary[idx][0]); 
				entry.setValue(executionBoundary[idx][1]);
				entry.setType("SETOPTION");			
	
				options.addElement(entry);			
			}
		
		//add collection depth
		AgentConfigurationEntry entry = new AgentConfigurationEntry();
		entry.setName(Options.OPTION_BOUNDARY_DEPTH); 
		entry.setValue(String.valueOf(getCollectionDepth()));
		entry.setType("SETOPTION");			

		options.addElement(entry);			
		
	}
	else if(getExecution())
	{
		//execution options
		String[][] execution = Options.OPTIONS_EXECUTION_FLOW;
		for(int idx=0; idx<execution.length; idx++)
		{
			AgentConfigurationEntry entry = new AgentConfigurationEntry();
			entry.setName(execution[idx][0]); 
			entry.setValue(execution[idx][1]);
			entry.setType("SETOPTION");

			options.addElement(entry);
		}				
	}
	else
	{
		String[][] execution = Options.OPTIONS_EXECUTION_FLOW_NONE;
		for(int idx=0; idx<execution.length; idx++)
		{
			AgentConfigurationEntry entry = new AgentConfigurationEntry();
			entry.setName(execution[idx][0]); 
			entry.setValue(execution[idx][1]);
			entry.setType("SETOPTION");

			options.addElement(entry);
		}		
	}
	
	//only send when heap info button is enable, or heap button had sent same info already.
	if(getExecution() && !getHeap())
	{
		String[][] heapInfo = Options.OPTIONS_NO_INSTANCE_INFORMATION;		
		for(int idx=0; idx<heapInfo.length; idx++)
		{
			AgentConfigurationEntry entry = new AgentConfigurationEntry();
			entry.setName(heapInfo[idx][0]); 
			entry.setValue(heapInfo[idx][1]);
			entry.setType("SETOPTION");			

			options.addElement(entry);			
		}    	
	}
	return options;
}

private boolean checkValidTraceDepth()
{
	if (_boundary.getSelection())
	{
		String text = _traceDepth.getText().trim();
		try {
			if (Integer.parseInt(text)<=0) return false;
		}
		catch(Exception exc)
		{
			return false;
		}
	}
	return true;
}

public void modifyText(ModifyEvent event)
{   
	if (event.getSource()==_traceDepth)
	{
		checkNumbersAndPrintErrorMsg();
	}
}

public boolean getHeap() {
	return _appHeapBtn.getSelection();
}

public boolean getHeapDetails() {
	return _showHeapInstance.getSelection();
}


public boolean getExecution() {
	return _appExecBtn.getSelection();
}

public boolean getExecutionStatistic() {
	return _showExecStatistic.getSelection();
}

public boolean getExecutionBoundary() {
	return _boundary.getSelection();
}

public int getCollectionDepth() {
	String text = _traceDepth.getText().trim();
	
	try {
		int depth = Integer.parseInt(text);
		if (depth>0) return depth;
		else return UIPlugin.getDefault().getPreferenceStore().getDefaultInt(TraceConstants.COLLECT_DEPTH);
	}
	catch(Exception exc)
	{
		return UIPlugin.getDefault().getPreferenceStore().getDefaultInt(TraceConstants.COLLECT_DEPTH);
	}
}
public void setHeap(boolean setValue) {
	_appHeapBtn.setSelection(setValue);	
}

public void setHeapDetails(boolean setValue) {
	_showHeapInstance.setSelection(setValue);	
}


public void setExecution(boolean select) {
	_appExecBtn.setSelection(select);
}

public void setExecutionStatistic(boolean select) {
	_showExecStatistic.setSelection(select);
}

public void setExecutionFlow(boolean select) {
	_showExecFlow.setSelection(select);
}

public void setExecutionBoundary(boolean setValue) {
	_boundary.setSelection(setValue);
	
    _traceDepth.setEnabled(_boundary.getSelection());
    _traceDepthLabel.setEnabled(_boundary.getSelection());
	
}

public void setCollectionDepth(String value) {
	_traceDepth.setText(value);
}

public void widgetDefaultSelected(SelectionEvent event) {}

public void widgetSelected(SelectionEvent event)
{
	if(event.widget == _appHeapBtn)
	{
	   _showHeapInstance.setEnabled(_appHeapBtn.getSelection());
	   
	   if(!_showHeapInstance.getEnabled())
		   _showHeapInstance.setSelection(false);
	}
	else if(event.widget == _appExecBtn)
	{
		enableExecutionBtnGroup();
	}
	else if(event.widget == _boundary)
	{
		_traceDepth.setEnabled(_boundary.getSelection());
		_traceDepthLabel.setEnabled(_boundary.getSelection());		
	}
	else if(event.widget == _execAdvanced)
	{
		_detailsExecGroup.setVisible(!_detailsExecGroup.getVisible());
		
		if(_detailsExecGroup.getVisible())
		{
			_execAdvanced.setText(UIPlugin.getResourceString("HIDE_DET2"));			
		}		
		else
		{
			_execAdvanced.setText(UIPlugin.getResourceString("SHOW_DET2"));						
		}
		_execAdvanced.pack();
	}
	else if(event.widget == _heapAdvanced)
	{
		_detailsHeapGroup.setVisible(!_detailsHeapGroup.getVisible());
		
		if(_detailsHeapGroup.getVisible())
		{
			_heapAdvanced.setText(UIPlugin.getResourceString("HIDE_DET"));			
		}		
		else
		{
			_heapAdvanced.setText(UIPlugin.getResourceString("SHOW_DET"));						
		}
		_heapAdvanced.pack();
	}
	checkNumbersAndPrintErrorMsg();
}

public void checkNumbersAndPrintErrorMsg()
{
	if (wizardPage!=null)
	{
		if (!checkValidTraceDepth())
		{
			wizardPage.setErrorMessage(UIPlugin.getResourceString("STR_INVALID_BOUND_VALUE"));
			wizardPage.setPageComplete(false);
		}
		else
		{
			wizardPage.setErrorMessage(null);
			wizardPage.setPageComplete(true);
		}
	}
	else if (preferencePage!=null)
	{
		if (!checkValidTraceDepth())
		{
			preferencePage.setErrorMessage(UIPlugin.getResourceString("STR_INVALID_BOUND_VALUE"));
			preferencePage.setValid(false);
		}
		else
		{
			preferencePage.setErrorMessage(null);
			preferencePage.setValid(true);
		}
		
	}
}
public void storeValues()
{
	IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
	
		store.setValue(TraceConstants.PROF_HEAP_STAT, getHeap());	
		store.setValue(TraceConstants.PROF_HEAP_INST, getHeapDetails());			
		
		store.setValue(TraceConstants.PROF_EXECUTION, getExecution());
	
		store.setValue(TraceConstants.PROF_EXECUTION_BOUNDARY,	getExecutionBoundary());
		store.setValue(TraceConstants.COLLECT_DEPTH, getCollectionDepth());
			
		store.setValue(TraceConstants.PROF_EXEC_STAT,	getExecutionStatistic());
	
}

public void setWizardPage(WizardPage page) {
	wizardPage = page;
}

public void setPreferencePage(PreferencePage page) {
		preferencePage = page;
	}

}
