/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.action.*;

public class LaunchTraceAction extends Action
							   implements IMenuCreator
{
/**
 * LaunchTraceAction constructor comment.
 */
public LaunchTraceAction()
{
	super(UIPlugin.getResourceString("LAUNCH_ACTION"));
	PDPluginImages.setImageDescriptors(this,PDPluginImages.T_TOOL,PDPluginImages.IMG_ACT_LAUNCH);
	setToolTipText(UIPlugin.getResourceString("LAUNCHTRACEACTION_TOOLTIP"));
	setMenuCreator(this);   
}
	private void createMenuForAction(Menu parent, Action action) {
		ActionContributionItem item= new ActionContributionItem(action);
		item.fill(parent, -1);
	}
	/**
	 * @see IWorkbenchWindowActionDelegate
	 */
	public void dispose() {
	}
	/**
	 * @see IMenuCreator
	 */
	public Menu getMenu(Control parent) {
		return null; 
	}
	/**
	 * @see IMenuCreator
	 */
	public Menu getMenu(Menu parent)
	{
		Menu menu= new Menu(parent);
		TraceLocalAction local = new TraceLocalAction();
		createMenuForAction(menu, local);

		TraceRemoteAction remote = new TraceRemoteAction();
		createMenuForAction(menu, remote);
		
		return menu;
	}
/**
 * Implementation of method defined on <code>IAction</code>.
 */
public void run()
{
}
}
