/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.piclient;

import java.util.Iterator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.widgets.Display;


public class PIAttachListener extends PIProcessListener
{   
  /**
 * PIProcessListener constructor comment.
 */
public PIAttachListener(TRCNode node)
{
	super(node);
}
public PIAttachListener(TRCNode node, TRCProcessProxy process)
{
	super(node, process);
}
/**
 * Insert the method's description here.
 * Creation date: (11/9/00 10:36:06 AM)
 * @param command com.ibm.etools.logging.tracing.control.Agent
 */
public synchronized void agentActive(Agent ag)
{
	String agentName = ag.getName();

	if(fProcess == null)
	  return;
	  
    if(_monitoredAgents.contains(agentName))
        _monitor = false; 
    else
    	_monitoredAgents.add(agentName);
          	        
    if(!_monitor)
      return;

	TRCAgentProxy agent = null;  
	EList agents = fProcess.getAgentProxies();
	Iterator i = agents.iterator();
	while(i.hasNext())
	{
		TRCAgentProxy a = (TRCAgentProxy) i.next();
		if(a.eIsProxy())
			continue;
		if(a != null && a.getName().equals(agentName))
		{
		  agent = a;
		  break;
		}
	}
	

	if(agent == null)
	  return;

	/* set the runtime UUID of the agent */
	agent.setRuntimeId(ag.getUUID());
	agent.setActive(true);
	agent.setAttached(true);
	agent.setProfileFile(ag.getProfileFile());
	
//	agent.setAgentInstance(ag);
	LoadersUtils.registerAgentInstance(agent,ag);

	final TRCAgentProxy agentTemp = agent;
	Display.getDefault().asyncExec(new Runnable() {
	public void run()
	{
		//update ui
		ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
		event.setSource(agentTemp);
		event.setType(ProfileEvent.START_MONITOR);
		UIPlugin.getDefault().notifyProfileEventListener(event);	            
	}});
	
}
}
