/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceOptionsUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
* CONTEXT_ID tbpp0000 for Profiling preference page
*/

/*
 * The page for setting java plugin preferences.
 */
public class TraceBasePreferencePage extends PreferencePage
									 implements IWorkbenchPreferencePage
{
	// Constants		
	private TraceOptionsUI _options;

	public TraceBasePreferencePage()
	{
		super();
		setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
		
	}
	protected Control createContents(Composite parent)
	{
		Composite composite= new Composite(parent, SWT.NONE);	
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		UIPlugin.getPluginId()+".tbpp0000");
		
		GridLayout layout= new GridLayout();
		layout.marginWidth= 0;
		layout.marginHeight= 5;	
		layout.numColumns= 1;		
		composite.setLayout(layout);
		
		_options = new TraceOptionsUI(this);
		_options.createControl(composite);

		return composite;
	}
/**
 * Returns preference store that belongs to the our plugin.
 * This is important because we want to store
 * our preferences separately from the desktop.
 *
 * @return the preference store for this plugin
 */
protected IPreferenceStore doGetPreferenceStore() {
	return UIPlugin.getDefault().getPreferenceStore();
}
	public void init(IWorkbench workbench) {
	}
/**
 * Initializes states of the controls using default values
 * in the preference store.
 */
private void initializeDefaults()
{
	IPreferenceStore store = getPreferenceStore();

	_options.setLogOption(store.getDefaultBoolean(TraceConstants.LOG_OPTION_KEY));
	_options.setProfOption(store.getDefaultBoolean(TraceConstants.PROF_OPTION_KEY));
	_options.setInfoMsgOption(store.getDefaultBoolean(TraceConstants.PROFILE_TIPS));
	_options.setProjectName(store.getDefaultString(TraceConstants.TRACE_PROJECT_NAME));
	
	store = UIPlugin.getDefault().getPreferenceStore();
	_options.setLocalHostPort(store.getDefaultString(HyadesConstants.LOCALHOST_PORT));
}
/**
 * Does anything necessary because the default button has been pressed.
 */
protected void performDefaults() {
	super.performDefaults();
	initializeDefaults();
}
/**
 * Do anything necessary because the OK button has been pressed.
 *
 * @return whether it is okay to close the preference page
 */
public boolean performOk() {
	storeValues();
	UIPlugin.getDefault().savePluginPreferences();
	return true;
}
/**
 * Stores the values of the controls back to the preference store.
 */
private void storeValues()
{
	IPreferenceStore store = getPreferenceStore();

	store.setValue(TraceConstants.LOG_OPTION_KEY, _options.getLogOption());
	store.setValue(TraceConstants.PROF_OPTION_KEY, _options.getProfOption());
	store.setValue(TraceConstants.PROFILE_TIPS, _options.getInfoMsgOption());
	store.setValue(TraceConstants.TRACE_PROJECT_NAME, _options.getProjectName());
	
	store = UIPlugin.getDefault().getPreferenceStore();	
	store.setValue(HyadesConstants.LOCALHOST_PORT, _options.getLocalPortNumber());
}
}
