/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Vector;

import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.DoubleCTree;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AttachLocalWizard extends Wizard implements INewWizard {

	protected AttachLocalPage fNamePage;
	protected DestinationFolderPage fFolderPage;
	protected ProfileOptionsPage fProfilePage;
	protected IStructuredSelection fSelection;
	protected AgentOptionsPage fOptionsPage;
	protected AgentCollectionsPage fCollectionsPage;
	protected String fNodeName = "";
	protected int fPortNumber = Constants.CTL_PORT_NUM_SERVER;
	private boolean isProfilingEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROF_OPTION_KEY);

	public AttachLocalWizard() {
		setNeedsProgressMonitor(true);
		//  setFinishStrategy(new Wizard.WizardOnlyFinishStrategy());
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/09/2000 11:31:51 AM)
	 */
	public void addPages() {
		setWindowTitle(UIPlugin.getResourceString("ATTACH_JAVA_APP_TITLE"));
		fNamePage = new AttachLocalPage("namePage");
		fFolderPage = new DestinationFolderPage("folderPage");

		addPage(fNamePage);
		addPage(fFolderPage);
		
		if(isProfilingEnabled)
		{
			fProfilePage = new ProfileOptionsPage("optionsPage", TraceConstants.ATTACH_LOCAL_WIZARD);
			fOptionsPage = new AgentOptionsPage("agentPage", TraceConstants.ATTACH_LOCAL_WIZARD);
			fCollectionsPage = new AgentCollectionsPage("collentionsPage",TraceConstants.LAUNCH_LOCAL_WIZARD);
			
			addPage(fProfilePage);
			addPage(fOptionsPage);
			addPage(fCollectionsPage);	
			
			fProfilePage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
			fOptionsPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
			fCollectionsPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
					
		}
				
		fNamePage.setImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
		fFolderPage.setImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));

	}
	public DoubleCTree getAgentList() {
		return fNamePage.getList();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 12:02:10 PM)
	 * @return java.util.Vector
	 */
	public ArrayList getFilterSet() {
		return fProfilePage.getFilterSet();
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (5/8/2001 5:13:24 PM)
	 * @return java.lang.String
	 */
	public String getNodeName() {
		return fNodeName;
	}

	public int getPortSelection() {
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		fPortNumber =
			Integer.parseInt(store.getString(HyadesConstants.LOCALHOST_PORT));

		return fPortNumber;
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (5/9/2001 11:54:33 AM)
	 * @return java.lang.String
	 */
	public String getNodeSelected() {
		return "localhost";
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 12:02:10 PM)
	 * @return java.util.Vector
	 */
	public Vector getOptions() {
		Vector options = fOptionsPage.getOptions();
		Vector collections = fCollectionsPage.getOptions();
		
		options.addAll(collections);  
		
		return options;
	}
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		fSelection = selection;

		setDefaultPageImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/01/2000 2:12:28 PM)
	 * @return boolean
	 */
	public boolean isComplete() {
		return fNamePage.isComplete();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/31/2000 4:21:25 PM)
	 * @return java.lang.String
	 */
	public String pageDetails() {
		return fNamePage.pageDetails();
	}
	public boolean performFinish() {

		if (!fFolderPage.getFile().equals("") && !PDCoreUtil.isPathExists(fFolderPage.getFile()))
		{
			if (!PDCoreUtil.createDirectoryMessage(fFolderPage.getFile(),getShell()))
				return false;
		}
		
		if(isProfilingEnabled)
		{
	        fProfilePage.finish();
	        fOptionsPage.finish();
		}				
	        
	        
		fFolderPage.finish();

		if (fNamePage
			.finish(
				fFolderPage.getProject(),
				fFolderPage.getMonitor(),
				fFolderPage.getFile()))
			return true;

		return false;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (5/9/2001 6:31:34 PM)
	 * @param nodeName java.lang.String
	 */
	public void setNodeSelection(String nodeName) {
		fNodeName = nodeName;
	}

	public void setPortSelection(int portNum) {
		fPortNumber = portNum;
	}
	
	public boolean isProfilingEnabled()
	{
		return isProfilingEnabled;
	}
}
