/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

public class AttachRemoteWizard extends AttachLocalWizard {

	private HostDataPage fHostPage;
	private boolean fShowHostPage;

	public AttachRemoteWizard() {
		this(true, "");
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/09/2000 11:31:51 AM)
	 */
	public AttachRemoteWizard(boolean showHostPage, String nodeName) {
		super();
		setNeedsProgressMonitor(true);

		fShowHostPage = showHostPage;
		fNodeName = nodeName;
	}
	public void addPages() {
		setWindowTitle(UIPlugin.getResourceString("ATTACH_RJAVA_APP_TITLE"));
		if (fShowHostPage)
			fHostPage = new HostDataPage("hostPage");
		fNamePage = new AttachLocalPage("namePage");
		fFolderPage = new DestinationFolderPage("folderPage");
		
		if (fShowHostPage)
			addPage(fHostPage);
		addPage(fNamePage);
		addPage(fFolderPage);
		
		if(isProfilingEnabled())
		{
			fProfilePage = new ProfileOptionsPage("optionsPage", TraceConstants.ATTACH_REMOTE_WIZARD);
			fOptionsPage = new AgentOptionsPage("agentPage", TraceConstants.ATTACH_REMOTE_WIZARD);
			fCollectionsPage = new AgentCollectionsPage("collentionsPage",TraceConstants.LAUNCH_LOCAL_WIZARD);
			
			addPage(fProfilePage);
			addPage(fOptionsPage);
			addPage(fCollectionsPage);	
			
			fProfilePage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
			fOptionsPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
			fCollectionsPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));					
		}
		

		if (fShowHostPage)
			fHostPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
		fNamePage.setImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
		fFolderPage.setImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (5/9/2001 11:54:33 AM)
	 * @return java.lang.String
	 */
	public String getNodeSelected() {
		if (fShowHostPage)
			return fHostPage.getNodeName();

		return fNodeName;
	}

	public int getPortSelection() {
		if (fShowHostPage)
			return fHostPage.getPortNumber();

		return fPortNumber;
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		fSelection = selection;

		setDefaultPageImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/01/2000 2:12:28 PM)
	 * @return boolean
	 */
	public boolean isComplete() {
		return fNamePage.isComplete();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/31/2000 4:21:25 PM)
	 * @return java.lang.String
	 */
	public String pageDetails() {
		return fNamePage.pageDetails();
	}
	public boolean performFinish() {

		if (!fFolderPage.getFile().equals("") && !PDCoreUtil.isPathExists(fFolderPage.getFile()))
		{
			if (!PDCoreUtil.createDirectoryMessage(fFolderPage.getFile(),getShell()))
				return false;
		}
		
		if(isProfilingEnabled())
		{
	        fProfilePage.finish();
	        fOptionsPage.finish();	        
		}				
	        
		fFolderPage.finish();

		if (fShowHostPage)
			fHostPage.finish();

		if (fNamePage
			.finish(
				fFolderPage.getProject(),
				fFolderPage.getMonitor(),
				fFolderPage.getFile())) {
			return true;
		}

		return false;
	}
}
