/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.model.IWorkbenchAdapter;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class ExecutionResultDetailPage 
extends DetailSection.DetailPage implements IHyperlinkListener
{
	private SelectableFormLabel testLink;
	private Label imageLabel;
	private StyledText typeText;
	private StyledText fileText;
	
	private StyledText verdictText;
	private StyledText startText;
	private StyledText stopText;

	private TPFExecutionResult executionResult;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		if((testLink != null) && (!testLink.isDisposed()))
			testLink.setData(null);
		executionResult = null;
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.DetailSection.DetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		createTestLink(composite);

		widgetFactory.createLabel(composite,"").setLayoutData(GridDataUtil.createHorizontalFill());
		
		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_VERD"));
		verdictText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		verdictText.setLayoutData(GridDataUtil.createHorizontalFill());
		verdictText.setEditable(false);

		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_START"));
		startText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		startText.setLayoutData(GridDataUtil.createHorizontalFill());
		startText.setEditable(false);

		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_STOP"));
		stopText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		stopText.setLayoutData(GridDataUtil.createHorizontalFill());
		stopText.setEditable(false);

		widgetFactory.paintBordersFor(composite);
		return composite;
	}
	
	protected void createTestLink(Composite parent)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		
		Composite linkComposite = widgetFactory.createComposite(parent);
		GridLayout gridLayout = new GridLayout(2, false);
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		linkComposite.setLayout(gridLayout);
		linkComposite.setLayoutData(GridDataUtil.createHorizontalFill());

		imageLabel = widgetFactory.createLabel(linkComposite, "");
		imageLabel.setImage(TestUIImages.INSTANCE.getImage(TestUIImages.IMG_ERROR));
		testLink = widgetFactory.createSelectableLabel(linkComposite, "");
		testLink.setText(TestUIPlugin.getString("NO_TST_TO_INV"));
		testLink.setToolTipText(TestUIPlugin.getString("TIP_EXE_TEST"));
		widgetFactory.turnIntoHyperlink(testLink, this);

		Composite detailComposite = widgetFactory.createComposite(parent);
		gridLayout = new GridLayout(2, false);
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		detailComposite.setLayout(gridLayout);
		detailComposite.setLayoutData(GridDataUtil.createHorizontalFill());

		widgetFactory.createLabel(detailComposite, TestUIPlugin.getString("L_TYPE"));
		typeText = widgetFactory.createStyledText(detailComposite, SWT.FULL_SELECTION | SWT.SINGLE);
		typeText.setEnabled(false);
		typeText.setLayoutData(GridDataUtil.createHorizontalFill());

		widgetFactory.createLabel(detailComposite, TestUIPlugin.getString("L_FILE"));
		fileText = widgetFactory.createStyledText(detailComposite, SWT.FULL_SELECTION | SWT.SINGLE);
		fileText.setEnabled(false);
		fileText.setLayoutData(GridDataUtil.createHorizontalFill());
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		executionResult = null;

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		boolean doPack = false;
		boolean testIsSet = false;
		if(object instanceof TPFExecutionResult)
		{
			executionResult = (TPFExecutionResult)object;
			TPFTest test = executionResult.getTest();
			doPack = true;
			
			if(test != null)
			{		
				testIsSet = true;
				
				ImageDescriptor imageDescriptor = null;
				if(test instanceof IAdaptable)
				{
					IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)((IAdaptable)test).getAdapter(IWorkbenchAdapter.class);
					if((workbenchAdapter != null))
						imageDescriptor = workbenchAdapter.getImageDescriptor(test);
				}
				if(imageDescriptor == null)
					imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_DEFAULT);

				imageLabel.setImage(imageDescriptor.createImage());
				
				if(test.getName() != null)
					testLink.setText(test.getName());
				else
					testLink.setText(TestUIPlugin.getString("W_TEST"));
				testLink.setData(test);
				
				TPFTestSuite testSuite = null;
				if(test instanceof TPFTestSuite)
					testSuite = (TPFTestSuite)test;
				else
					testSuite = ((TPFTestCase)test).getTestSuite();
	
				String value = testSuite.getType();
				if(value != null)
				{
					IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS).getDefaultAssociationDescriptor(value);
					if((descriptor != null) && (descriptor.getName() != null))
						value = descriptor.getName();
					typeText.setText(value);
				}
					
				IFile file = EMFUtil.getWorkspaceFile(testSuite);
				if(file != null)
					fileText.setText(file.getFullPath().toString());
					
				if(executionResult.getVerdict() != null)
					verdictText.setText(executionResult.getVerdict().getLabel());
				else
					verdictText.setText("");
					
				long startTimestamp = 0;
				long stopTimestamp = 0;
				
				for (Iterator i = executionResult.getExecutionHistory().getExecutionEvents().iterator(); i.hasNext();)
				{
					TPFExecutionEvent event	= (TPFExecutionEvent)i.next();
					if(event instanceof TPFTypedEvent)
					{
						TPFExecutionType type = ((TPFTypedEvent)event).getType();
						if(type != null)
						{
							switch(type.getValue())
							{
								case TPFExecutionType.START:
									startTimestamp = event.getTimestamp();
									break;

								case TPFExecutionType.STOP:
									stopTimestamp = event.getTimestamp();
									break;									
							}
							
							if((startTimestamp != 0) && (stopTimestamp != 0))
								break;
						}
					}
				}
				
				startText.setText(EventUtil.getTime(startTimestamp));
				stopText.setText(EventUtil.getTime(stopTimestamp));
			}						
		}
		else
		{
			verdictText.setText("");
			startText.setText("");
			stopText.setText("");
		}
		
		if(!testIsSet)
		{
			doPack = true;
			imageLabel.setImage(TestUIImages.INSTANCE.getImage(TestUIImages.IMG_ERROR));
			testLink.setText(TestUIPlugin.getString("NO_TST_TO_INV"));
			testLink.setData(null);
			fileText.setText("");
			typeText.setText("");
		}
		
		if(doPack)
		{
			imageLabel.pack(true);
			imageLabel.redraw();
			testLink.pack(true);
			testLink.redraw();			
		}
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return executionResult;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkActivated(org.eclipse.swt.widgets.Control)
	 */
	public void linkActivated(Control linkLabel)
	{
		Object data = linkLabel.getData();
		if(data != null)
		{
			EObject eObject = (EObject)data;
			IFile file = EMFUtil.getWorkspaceFile(eObject);
			if(file != null)
			{
				IEditorPart editorPart = UIUtil.openEditor(file, null, false);
				if(editorPart instanceof ISelectionProvider)
					((ISelectionProvider)editorPart).setSelection(new StructuredSelection(eObject));
				
				return;
			}
		}
		
		IActionBars actionBars = getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		if (manager != null)
			manager.setErrorMessage(TestUIPlugin.getString("MSG_UN_OPEN_OBJ"));	
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkEntered(org.eclipse.swt.widgets.Control)
	 */
	public void linkEntered(Control linkLabel)
	{
		IActionBars actionBars = getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		if (manager != null)
			manager.setMessage(((SelectableFormLabel)linkLabel).getText());
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkListener#linkExited(org.eclipse.swt.widgets.Control)
	 */
	public void linkExited(Control linkLabel)
	{
		IActionBars actionBars = getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		if (manager != null)
		{
			manager.setMessage("");
			manager.setErrorMessage("");
		}
	}	
}
