/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.PartInitException;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;

/**
 * Extends the HyadesNewWizard to create the Deployment.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class DeploymentNewWizard 
extends HyadesNewWizard
{
	/**
	 * Constructor for DeploymentNewWizard
	 */
	public DeploymentNewWizard()
	{
		super();
		setWindowTitle(TestUIPlugin.getString("WIZ_DEPLOY_TTL"));
		setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_WIZBAN_NEWDEPLOYMENT));

		IDialogSettings dialogSettings = TestUIPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("TestSuiteNewWizard");
		if(settings == null)
			settings = dialogSettings.addNewSection("TestSuiteNewWizard");
		setDialogSettings(settings);
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#getFileExtension()
	 */
	protected String getFileExtension()
	{
		return ICommonConstants.DEPLOYMENT_FILE_EXTENSION;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
		getLocationPage().setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_LOC_DSC"));
		addPage(getLocationPage());
		
		getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_DEPLOY_PG_TTL"));
		getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_DEPLOY_PG_ATT_DSC"));
		addPage(getAttributeWizardPage());
	}
	
	/**
	 * @see org.eclipse.hyades.ui.test.internal.wizard.HyadesNewWizard#createObject(org.eclipse.core.resources.IFile)
	 */
	protected boolean createObject(IFile file)
	throws Exception
	{
		Resource resource = createResource(file);
		resource.getContents().add(createEObject());
		EMFUtil.save(resource);
		return true;
	}
	
	/**
	 * Creates the EObject setting the attributes based on the information
	 * the user has defined in this wizard's pages.
	 * @return a not null EObject
	 */
	protected EObject createEObject()
	{
		TPFDeployment deployment = Common_TestprofileFactory.eINSTANCE.createTPFDeployment();
		deployment.setName(getAttributeWizardPage().getItemName());
		
		String description = getAttributeWizardPage().getItemDescription();
		if((description != null) && (description.trim().length() > 0))
			deployment.setDescription(description);
			
		return deployment;
	}
	
	/**
	 * Creates the EMF resource in which the object is added to.
	 * @return a not null Resource
	 */
	protected Resource createResource(IFile file)
	{
		URI uri = URI.createPlatformResourceURI(file.getFullPath().toString());
		Resource.Factory factory = EMFUtil.getResourceFactory(ICommonConstants.DEPLOYMENT_FILE_EXTENSION);
		return factory.createResource(uri);
	}

		
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard#openEditor(org.eclipse.core.resources.IFile)
	 */
	protected void openEditor(IFile file) 
	throws PartInitException
	{
		if(TestUIPlugin.getInstance().getPreferenceStore().getBoolean(TestUI.OPEN_EDITOR))
			UIUtil.openEditor(file, TestUIExtension.DEPLOYMENT_EDITOR_PART_ID, false);
	}	
}
