/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.*;

public class OpenLogViewAction extends Action
									implements IExecutableExtension
											  , IWorkbenchWindowActionDelegate
											  , IViewActionDelegate
{
	private ISelection selection = null;
	
	public OpenLogViewAction() {
		super("");
	}
	
	private void openView() {
		try {

			IWorkbenchWindow window =
				LogUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
			IWorkbenchPage persp = UIPlugin.getActivePage();

            TraceViewer view = (LogViewer) (persp.showView("org.eclipse.hyades.log.ui.internal.views.LogViewer"));
				            
			EObject mofObject = getObjectToView(getMofObject());	            
			if (view != null)					
				view.addViewPage(mofObject);

         
			if(selection!=null && !selection.isEmpty())
			{
			   Object sel = ((IStructuredSelection)selection).getFirstElement();
			   
			   if(sel instanceof EObject)
			   	view.setRecordSelection((EObject) sel, mofObject);
			}	
            else
            {
				Object obj = UIPlugin.getDefault().getSelectionModel(mofObject).getFirstElement();
				if(obj!=null && obj instanceof EObject)
				   view.setRecordSelection((EObject)obj, mofObject);	            	
            }
            
			selection = null;

		} catch (Exception e) {
			
			e.printStackTrace();
		}
	}
	public void run() {
		openView();
	}
	public void run(IAction action) {
		run();
	}
	public void setInitializationData(
		IConfigurationElement configElement,
		String name,
		Object data) {
	}
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}
	public void dispose() {
	}
	public void init(IWorkbenchWindow window) {
		// do nothing.
	}
	
	public EObject getMofObject()
	{
		IWorkbenchPage page = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
		if(page == null || !page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE) )
		  return null;
	  
		IViewPart monitorsView = page.findView(PDPerspective.ID_PD_NAVIGATOR_VIEW);
		if(monitorsView == null || !(monitorsView instanceof PDProjectExplorer))
		  return null;  
	  
		TreeItem item = null;  
		PDProjectViewer viewer = ((PDProjectExplorer)monitorsView).getViewer();
		if(viewer != null)
		   item = viewer.getTreeSelection();
	   
		if(item == null || !(item.getData() instanceof EObject))
		  return null;
	  
		return (EObject)item.getData();  
	}

	/**
	 * Initializes this action delegate with the view it will work in.
	 *
	 * @param view the view that provides the context for this delegate
	 */
	public void init(IViewPart view)
	{
	}

	/**
	 * @return the object that should be viewed
	 * For example, if the process node is selected, the view should display
	 * the profiling data if trace collects profiling data
	 * Returns the agent if there is only one log agent
	 * 
	 */
	public EObject getObjectToView(EObject selObject) {

		if (selObject == null)
			return selObject;

		List list =null;
		
		if(selObject instanceof TRCMonitor){

			list = getLogObjectInMonitor((TRCMonitor)selObject);
			
		}else if(selObject instanceof TRCNode){
			
			list = getLogObjectInNode((TRCNode)selObject);
		
		}else if (selObject instanceof TRCProcessProxy) {

			list = getLogAgentInProcess((TRCProcessProxy)selObject); 
			
		}
		if(list!=null && list.size()==1){
			return (EObject)list.get(0);
		}
		return selObject;
	}

	private List getLogObjectInMonitor(EObject selObject){

		EList nodes = ((TRCMonitor)selObject).getNodes();
		TRCNode node = null;

		int size = nodes.size();
		int nrOfNodes = 0;
		List object_list = new ArrayList();
		List list;		

		for(int i=0; i < size && nrOfNodes < 2;i++){		
			node = (TRCNode)nodes.get(i);
			if(node==null){
				continue;
			}else{	
				
				list = getLogObjectInNode(node); 
				if(list.size()>=1){
					nrOfNodes++;					
					object_list.add(node);
				}
			}
			
		}
		
		if(object_list.size()==1){
			list = getLogObjectInNode((TRCNode)object_list.get(0));
			if(list.size()==1){
				object_list.clear();
				object_list.add(list.get(0));
			}
		}
		
		return object_list;
	}
	
	private List getLogObjectInNode(EObject selObject){

		EList processes = ((TRCNode)selObject).getProcessProxies();
		TRCProcessProxy process = null;
		int nrOfProcesses = 0;
		int size = processes.size();
		List list;
		List object_list = new ArrayList();

		for(int i=0; i < size && nrOfProcesses < 2;i++){		
			process = (TRCProcessProxy)processes.get(i);
			if(process!=null){
				list = getLogAgentInProcess(process);
				if(list.size()>=1){
					nrOfProcesses++;
					object_list.add(process);
				}
			}else{
				continue;								
			}
		}
		
		if(object_list.size()==1){
			list = getLogAgentInProcess((TRCProcessProxy)object_list.get(0));
			if(list.size()==1){
				object_list.clear();
				object_list.add(list.get(0));
			}
			
		}
		return object_list;
	}
	
	private List getLogAgentInProcess(EObject selObject){

		int nrOfAgents = 0;
		EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
		int size = agents.size();
		TRCAgentProxy a = null;
		List list =  new ArrayList();
		
		for (int idx = 0; idx < size && nrOfAgents < 2; idx++) {
			a = (TRCAgentProxy) agents.get(idx);
			if (a == null || a.eIsProxy())
				continue;
			if (a.getType().equals(HyadesConstants.LOG_AGENT_TYPE)) {
				nrOfAgents++;
				list.add(a);
			}
		}
		
		return list;
	
	}
	

	
}