/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.dialogs.*;
import org.eclipse.ui.help.*;

/**
 * Provides selection dialog for selecting monitors
 */
public class SymptomDBSelectionDialog extends SelectionDialog
						implements ISelectionValidator
								   , Listener
{
  // the widget group;
  private SymptomDBSelectionGroup group;

  // allow the user to type in a new container name
  private boolean onlyMonitorFolders = true;

  private int style;
  private int type;
	
  // the validation message
  private Label statusMessage;

  // sizing constants
  private static final int	SIZING_SELECTION_PANE_HEIGHT = 250;
  private static final int	SIZING_SELECTION_PANE_WIDTH = 300;

  /**
   * Creates a resource container selection dialog rooted at the given resource.
   * All selections are considered valid. Equivalent to
   * <code>new ContainerSelectionDialog(initialRoot,allowNewContainerName,message,null)</code>.
   *
   * @param parentShell the parent shell
   * @param initialRoot the root resource to populate the resource viewer
   *  with
   * @param allowNewContainerName <code>true</code> to enable the user to type in
   *  a new container name, and <code>false</code> to restrict the user to just
   *  selecting from existing ones
   * @param message the message to be displayed at the top of this dialog, or
   *    <code>null</code> to display a default message
   */
  public SymptomDBSelectionDialog(Shell parentShell, String message) {
	this(parentShell, message, SWT.NONE, 1);
  }      
  public SymptomDBSelectionDialog(Shell parentShell, String message, int style, int type) {
	super(parentShell);
	setTitle(LogUIPlugin.getResourceString("STR_MON_SEL_TITLE"));
	this.style = style;
	this.type = type;
	this.onlyMonitorFolders = true;
	if (message != null)
		setMessage(message);
	else
		setMessage(LogUIPlugin.getResourceString("STR_MON_SEL_TEXT"));		

  }                  
protected Control createButtonBar(Composite parent)
{
	Control result = super.createButtonBar(parent);

	statusMessage.setForeground(statusMessage.getDisplay().getSystemColor(SWT.COLOR_RED));	
	statusMessage.setText(LogUIPlugin.getResourceString("STR_MON_SEL_TEXT"));	
	getOkButton().setEnabled(false);	
	return result;
}
  /* (non-Javadoc)
   * Method declared on Dialog.
   */
  protected Control createDialogArea(Composite parent) {
	// create composite 
	Composite dialogArea = (Composite)super.createDialogArea(parent);
	// container selection group
	group = new SymptomDBSelectionGroup(dialogArea, this, true);
	    
	statusMessage = new Label(parent, SWT.NONE);
	statusMessage.setLayoutData(new GridData(GridData.FILL_BOTH));
	
	WorkbenchHelp.setHelp(dialogArea, ContextIds.SYMDB_PREF_DATABASE_ADD_DIALOG);
	
	return dialogArea;
}
	public void handleEvent (Event event) {
		if (statusMessage != null) {
			String errorMsg = isValid(group.getContainerFullPath());
			if (errorMsg == null || errorMsg.equals("")) {
				statusMessage.setText("");
				getOkButton().setEnabled(true);
			} else {
				statusMessage.setForeground(statusMessage.getDisplay().getSystemColor(SWT.COLOR_RED));
				statusMessage.setText(errorMsg);
				getOkButton().setEnabled(false);
			}
		}
	}
public String isValid(Object selection)
{
	IPath path = (IPath)selection;

	if(path == null)
	  return null;

	IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
	
	IResource res = root.findMember(path);
	if(res != null && res instanceof IContainer)
	{
		return LogUIPlugin.getResourceString("STR_MON_SEL_TEXT");
	}
	 
	return null;
}
/**
 * The <code>ContainerSelectionDialog</code> implementation of this 
 * <code>Dialog</code> method builds a list of the selected resource containers
 * for later retrieval by the client and closes this dialog.
 */
protected void okPressed() {

	ArrayList chosenContainerPathList = new ArrayList();
		chosenContainerPathList.add(group.getContainerFullPath());
	setResult(chosenContainerPathList);
	
	super.okPressed();
}
public void setShowOnlyMonitorFolders (boolean value) {
	onlyMonitorFolders = value;
}
}
