/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class ImportLogHostPage extends WizardPage {

    private TraceHostUI hostUI;

    public ImportLogHostPage() {
        super("ImportLogHostPage");

        setTitle(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_HOST_TITLE"));

        setDescription(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_HOST_DESC"));

        setImageDescriptor(LogUIPlugin.getImageDescriptor(LogUIPluginImages.IMG_IMPORT_WIZ_BAN));
    }
    public void createControl(Composite parent) {
        hostUI = new TraceHostUI();

        setControl(hostUI.createControl(parent));

		WorkbenchHelp.setHelp(getControl(), ContextIds.IMPORT_LOG_FILE_HOST_LIST);
    }
    public boolean finish() {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

        String hosts = "";

        TableItem[] items = hostUI.getHosts();

        for (int idx = 0; idx < items.length; idx++) {
            hosts += "," + items[idx].getText().trim();
        }

        if (hosts.startsWith(",") && hosts.length() > 1)
            hosts = hosts.substring(1);

        store.setValue(HyadesConstants.HOST_KEY, hosts);

        return true;
    }
    public String getHost() {
        return hostUI.getHost().trim();
    }
    public int getPort() {
        return hostUI.getPort();
    }
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        hostUI.getHostUI().setFocus();
    }

    public boolean isLocaHost() {
        return hostUI.isLocalHost(getHost());
    }
}