/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.swt.graphics.Point;

/**
 *
 */
public class ImportWizardNode implements IWizardNode {

	protected ImportLogFile wizard;
	protected WorkbenchWizardListSelectionPage parentPage;
	protected String parserId;

	
	public ImportWizardNode(String parserId, WorkbenchWizardListSelectionPage parentPage){
		this.parentPage = parentPage;
		this.parserId = parserId;
		
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizardNode#dispose()
	 */
	public void dispose() {
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizardNode#getExtent()
	 */
	public Point getExtent() {
		return new Point(-1,-1);
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizardNode#getWizard()
	 */
	public IWizard getWizard() {
		if (wizard == null){
			wizard = new ImportLogFile();
			wizard.setLogParserId(parserId);
			wizard.init(parentPage.getWorkbench(), parentPage.getCurrentResourceSelection());
		}
		return wizard;
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizardNode#isContentCreated()
	 */
	public boolean isContentCreated() {
		return wizard != null;
	}

}
