/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.*;
import java.util.*;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 *
 */
public class ImportWizardTextField implements IImportWizardWidget,Listener, ModifyListener {

	protected Button btn; 
	protected Map _filtersTable;
	protected Text text;
	protected ISetLastWasHome lastWasHome;
	
	public ImportWizardTextField(Map _filtersTable, ISetLastWasHome lastWasHome){
		this._filtersTable = _filtersTable;
		this.lastWasHome = lastWasHome;
	}
	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#getValue()
	 */
	public String getValue() {
		return text.getText().trim();
	}

	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#createControl(Composite, ParserField, String)
	 */
	public void createControl(
		Composite composite,
		ParserField field,
		String prefix) {
            Label label = new Label(composite, SWT.NULL | SWT.WRAP);            
            GridData data = new GridData();
            data.widthHint = 400;
            data.horizontalSpan = 2;            
            label.setLayoutData(data);
            label.setText(field.getName());
            
            text = new Text(composite, SWT.BORDER);
            text.setLayoutData(GridUtil.createHorizontalFill());
            text.addModifyListener(this);
            text.setToolTipText(field.getTooltip());
            
            btn = new Button(composite, SWT.PUSH);
            btn.setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_BROWSE1"));
            btn.addListener(SWT.Selection, this);
            
            if (field.useBrowse()) {
                btn.setVisible(true);

                String filters = field.getFilters();
                if (filters != null)
                    _filtersTable.put(btn, filters);
            }
            else{
	            btn.setVisible(false);
            }
            
			
	}

	/**
	 * @see org.eclipse.swt.widgets.Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event) {
            if (event.widget == btn) {
                Object filters = _filtersTable.get(btn);
                if (filters != null) {
                    FileDialog fileDialog = new FileDialog(btn.getParent().getShell());
                    fileDialog.setFilterPath(text.getText().trim());
                    fileDialog.setFilterExtensions(new String[] { filters.toString(), "*" });
                    fileDialog.open();

                    String fileName = fileDialog.getFileName();

                    if ((fileName != null) && (!fileName.trim().equals("")))
                        text.setText(fileDialog.getFilterPath().concat(File.separator).concat(fileName));

                }
                else {
                	
                    DirectoryDialog directoryDialog = new DirectoryDialog(btn.getParent().getShell());
                    directoryDialog.setMessage(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_LOC_BROWSE"));

                    if (text.getText().trim().length() > 0)
                        directoryDialog.setFilterPath(text.getText().trim());
                    else if (lastWasHome.getLastWasHome().trim().length() > 0)
                        directoryDialog.setFilterPath(lastWasHome.getLastWasHome().trim());

                    String wasHomeDir = directoryDialog.open();

                    if ((wasHomeDir != null) && (!wasHomeDir.trim().equals(""))) {
                        text.setText(wasHomeDir);
                        lastWasHome.setLastWasHome(wasHomeDir);
                    }

                }

		    }
		
	}

	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(ModifyEvent)
	 */
	public void modifyText(ModifyEvent e) {
	}

	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#isValid()
	 */
	public boolean isValid() {
        if (text.getVisible() && text.getText().trim().equals(""))
           return false;
		
		return true;
	}

	/**
	 * Returns the text.
	 * @return Text
	 */
	public Text getText() {
		return text;
	}

	/**
	 * Sets the text.
	 * @param text The text to set
	 */
	public void setText(Text text) {
		this.text = text;
	}

	/**
	 * Returns the btn.
	 * @return Button
	 */
	public Button getBtn() {
		return btn;
	}

	/**
	 * Sets the btn.
	 * @param btn The btn to set
	 */
	public void setBtn(Button btn) {
		this.btn = btn;
	}

}
