/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.wizards;

import java.io.*;
import java.util.*;

import org.eclipse.hyades.internal.logging.core.*;
import org.eclipse.hyades.loaders.util.*;
import org.eclipse.hyades.logging.core.*;
import org.eclipse.hyades.logging.parsers.*;


public class LocalLogParserLoader implements ILogger {
    //~ Instance fields ----------------------------------------------------------------------------

    private Hashtable parserParameters = null;
    private Parser parser = null;
	private XmlGenerator xmlGenerator = new XmlGenerator ("ParseLogger");


    //NOTE: Temporary XMLLoader to propagate logged raw objects to the model as XML strings:
    private XMLLoader xmlLoader = null;
    private boolean first = true;

    //~ Constructors -------------------------------------------------------------------------------

    public LocalLogParserLoader(Parser parser, Hashtable parserParameters) {
        this.parser = parser;
        this.parserParameters = parserParameters;
		xmlGenerator.reset ("FINEST", true, 8);
    }

    //~ Methods ------------------------------------------------------------------------------------

    //NOTE: Temporary API to propagate logged raw objects to the model as XML strings:
    public void setXMLLoader(XMLLoader xmlLoader) {
        this.xmlLoader = xmlLoader;
    }

    public void startParsing() throws LogParserException {
        parser.setUserInput(parserParameters);

        parser.parse(this);
    }

    /**
     *        Log a boolean message.
     *
     *        @param msg the message to be logged
     */
    public void write(boolean msg) {
		logXMLToModel(XmlGenerator.primitiveToXML(msg));
    }

    /**
     *        Log a char message.
     *
     *        @param msg the message to be logged
     */
    public void write(char msg) {
		logXMLToModel(XmlGenerator.primitiveToXML(msg));
    }

    /**
     *        Log a byte message.
     *
     *        @param msg the message to be logged
     */
    public void write(byte msg) {
		logXMLToModel(XmlGenerator.primitiveToXML(msg));
    }

    /**
     *        Log a short message.
     *
     *        @param msg the message to be logged
     */
    public void write(short msg) {
		logXMLToModel(XmlGenerator.primitiveToXML(msg));
    }

    /**
     *        Log an int message.
     *
     *        @param msg the message to be logged
     */
    public void write(int msg) {
		logXMLToModel(XmlGenerator.primitiveToXML(msg));
    }

    /**
     *        Log a long message.
     *
     *        @param msg the message to be logged
     */
    public void write(long msg) {
		logXMLToModel(XmlGenerator.primitiveToXML(msg));
    }

    /**
     *        Log a float message.
     *
     *        @param msg the message to be logged
     */
    public void write(float msg) {
		logXMLToModel(XmlGenerator.primitiveToXML(msg));
    }

    /**
     *        Log a double message.
     *
     *        @param msg the message to be logged
     */
    public void write(double msg) {
		logXMLToModel(XmlGenerator.primitiveToXML(msg));
     }

    /**
     *        Log an Object message.
     *
     *        @param msg the message to be logged
     */
    public void write(Object obj) {
        try {
			logXMLToModel(xmlGenerator.objectToXML (obj));
        } catch (Throwable t) {
        }
    }

    //NOTE: Temporary API to propagate logged raw objects to the model as XML strings:
    private void logXMLToModel(String xml) {
        // Note:  The com.ibm.xml.b2b.level0.L0DocumentEventHandler (com.ibm.etools.perftrace.loader.XMLLoader) XML scanner MUST be passed UTF8 encoded byte array data:
        byte[] xmlLogEntryBytes = null;

        try {
            xmlLogEntryBytes = xml.getBytes("UTF8");
        } catch (UnsupportedEncodingException u) {
            xmlLogEntryBytes = xml.getBytes();
        }

        //		System.err.println(xml);
        xmlLoader.loadEvent(xmlLogEntryBytes, xmlLogEntryBytes.length);
    }
}
