/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import java.net.*;
import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.resource.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class LogParserUI implements SelectionListener
{
	private Table  _list;
	private Label  _description;
	private ArrayList _images;
	private ArrayList _parserTable = new ArrayList();
	private LogParserItem _parser;
	private int _max = 1;
	private LogParsersPage page;
        
    
	public LogParserUI(LogParsersPage page) {
		this.page = page;		
		_images = new ArrayList();
	}
	
	/**
	 * Insert the method's description here.
	 * Creation date: (4/26/2001 3:45:54 PM)
	 * @param parent com.ibm.swt.widgets.Composite
	 */
	public Composite createControl(Composite parent)
	{		
		Composite result = new Composite(parent, SWT.NULL);
		result.setLayoutData(GridUtil.createFill());
		result.setLayout(new GridLayout());
	
		Label desc = new Label(result, SWT.NULL);
		desc.setLayoutData(GridUtil.createHorizontalFill());   
		desc.setText(LogUIPlugin.getResourceString("STR_LOG_PDESC"));
	
		_list = new Table(result, SWT.BORDER|SWT.H_SCROLL|SWT.V_SCROLL|SWT.FULL_SELECTION|SWT.SINGLE);
		_list.setLayoutData(GridUtil.createFill());
		
		_description = new Label(result, SWT.NULL|SWT.WRAP);
		_description.setLayoutData(GridUtil.createHorizontalFill());
		
		_list.addSelectionListener(this);
	
		initializeValues();
			
		return result;
	}
	
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues()
	{
		IPluginRegistry reg = Platform.getPluginRegistry();
	
		IConfigurationElement[] config =
			reg.getConfigurationElementsFor("com.ibm.etools.pd.util", "logParser");
	
		for (int idx = 0; idx < config.length; idx++) {
			IConfigurationElement elem = config[idx];
						
			LogParserItem parser = new LogParserItem(elem.getAttribute("id")
											 , elem.getAttribute("name")
											 , elem.getAttribute("ui_name")
											 , elem.getAttribute("description"));
			parser.setConfigurationElement(elem);
			parser.setClass(elem.getAttribute("class"));								 
			parser.setUIType(elem.getAttribute("ui_type"));								 
					
			String iconPath = elem.getAttribute("icon");
			if(iconPath != null && !iconPath.equals(""))
			{
				URL pluginURL = elem.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
				try {
					URL url = new URL(pluginURL, iconPath);
					ImageDescriptor image = ImageDescriptor.createFromURL(url);
					parser.setImageDescriptor(image);
				}
				catch(Exception exc)
				{
					// if the URL does not have a valid format, just log and ignore the exception
					IStatus status = new Status(IStatus.ERROR, LogUIPlugin.getPluginId(), 2,"exception.malformedURL", exc); //$NON-NLS-1$
					LogUIPlugin.getDefault().getLog().log(status);
					continue;
					
				}
				
			}
														 
			IConfigurationElement[] felems = elem.getChildren("field");
			for(int i=0; i<felems.length; i++)
			{
			   IConfigurationElement felem = felems[i];
			   ParserField pfield = new ParserField(felem.getAttribute("id")
			   										, felem.getAttribute("name"));
			   	
			   pfield.setDefaultValue(felem.getAttribute("defaultValue"));	
			   pfield.setContextId(felem.getAttribute("helpContextId"));	
			   pfield.setTooltip(felem.getAttribute("tooltip"));	
			   pfield.setFilters(felem.getAttribute("browseType"));
			   pfield.useBrowse(felem.getAttribute("useBrowse").equals("true"));
			   pfield.setUiType(felem.getAttribute("ui_type"));
			   
			   parser.addEntry(pfield);	
			   
			}
			
			if(_max < felems.length)
			   _max = felems.length;								 
			
			_parserTable.add(parser);
		}
		
		initializeUI();	
	}
	
	private void initializeUI()
    {
    	for(int idx=0; idx<_parserTable.size(); idx++)
    	{
    		LogParserItem parser = (LogParserItem)_parserTable.get(idx);
    		
			TableItem item = new TableItem(_list, SWT.NONE);
			item.setText(parser.getUIName());
			item.setData(parser);
			
			if(parser.getImageDescriptor() == null)
			  continue;
			
			Image image = parser.getImageDescriptor().createImage();
			item.setImage(image);
			_images.add(image);    		
    	}
    	
    	if(_parserTable.size() > 0)
    	{
    	   _parser = (LogParserItem)_parserTable.get(0);
    	   _list.setSelection(0);
    	   _description.setText(_parser.getDescription());
    	}
    }	

	public void widgetDefaultSelected(SelectionEvent e) {}
	
	public void widgetSelected(SelectionEvent e)
	{
		if(e.widget == _list)
		{
		   TableItem[] selected = _list.getSelection();
		   if(selected.length > 0)
		   {
		   	  _parser = (LogParserItem)selected[0].getData();
		   	  _description.setText(_parser.getDescription());
		   	  setParser(_parser);
		   }
		   else
			   _description.setText("");
			
		}
	}
	
	public LogParserItem getParser()
	{
	   return _parser;		
	}
	
	public void setParser(LogParserItem newParser){
		((ImportLogWizard)page.getWizard()).setCurrentSelectedParser(newParser);	
	}
	
	public int getMaximumFields()
	{
		return _max;
	}
	
	public void dispose()
	{
		for(int idx=0; idx<_images.size(); idx++)
		{
			Image image = (Image)_images.get(idx);
			if(image != null && !image.isDisposed())
			   image.dispose();
		}
		
		_images.clear();
	}
}
