/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.swt.widgets.*;

public class LogParsersPage extends WizardPage {
	private LogParserUI _parserUI;

	public LogParsersPage(String name) {
		super(name);
		setTitle(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_TITLE"));
		setDescription(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_DESC"));
	}
	public void createControl(Composite parent) {
		_parserUI = new LogParserUI(this);
		setControl(_parserUI.createControl(parent));

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			parent,
			LogUIPlugin.getPluginId() + ".pp0000");

		setPageComplete(_parserUI.getParser() != null);
	}
	public boolean finish() {
		return true;
	}

	public LogParserItem getParser() {
		return _parserUI.getParser();
	}
	
	public int getMaximumFields()
	{
		return _parserUI.getMaximumFields();
	}
	
	public void dispose()
	{
		super.dispose();
		_parserUI.dispose();
	}
	
	public boolean isPageComplete(){
		return _parserUI.getParser() != null;	
	}
	
}
