/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.runner.ui.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import org.eclipse.hyades.test.manual.runner.model.Action;
import org.eclipse.hyades.test.manual.runner.model.Loop;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;
import org.eclipse.hyades.test.manual.runner.ui.util.SwingUtil;

/**
 * @author marcelop
 * @since 1.0.2
 */
class TestSuiteTreeCellRenderer
extends DefaultTreeCellRenderer
{
	private final static String SPACE = "   ";	
	private boolean isEnabled = true;
	
	/**
	 * @see TreeCellRenderer#getTreeCellRendererComponent(JTree, Object, boolean, boolean, boolean, int, boolean)
	 */
	public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus)
	{		
		super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
		
		String iconName = null;
		int iconType = SwingUtil.NORMAL;
		boolean toBeExecuted = false;
		boolean enable = false; 
		
		if(value instanceof NamedElement)
		{
			NamedElement namedElement = (NamedElement)value;
			enable = (namedElement.getExecutionId() <= ModelUtil.DEFAULT_EXECUTION_MANAGER.getCurrentExecutionId());
		}

		if(value instanceof TestSuite)
		{
			iconName = "msuite.gif";
		}
		else if(value instanceof Loop)
		{
			iconName = "loop.gif";
		}
		else if(value instanceof TestInvocation)
		{
			TestInvocation testInvocation = (TestInvocation)value;
			iconName = "invocation.gif";		
			if(testInvocation.getVerdictEvent() != null)
				iconType = SwingUtil.COMPLETED;

			if(testInvocation.getExecutionCount() > 0)
			{
				setText(new StringBuffer(getText()).append(SPACE).append("#").append(testInvocation.getExecutionCount()).toString());
			}				
			else
			{
				toBeExecuted = (ModelUtil.DEFAULT_EXECUTION_MANAGER.isExecutable(testInvocation) && (testInvocation.getExecutionId() <= ModelUtil.DEFAULT_EXECUTION_MANAGER.getCurrentExecutionId()));
				if(toBeExecuted)
				{
					int index = testInvocation.getOwner().getActions().indexOf(testInvocation);
					if(index > 0)
					{
						Action previousAction = (Action)testInvocation.getOwner().getActions().get(index-1);
						if(previousAction.isSynchronous())
						{
							if(previousAction instanceof TestInvocation)
							{
								toBeExecuted = (((TestInvocation)previousAction).getVerdictEvent() != null);
								enable = toBeExecuted;
							}
						}
					}
				}
			}
		}
		else
		{
			setToolTipText(null);
		}
		
		if(getFont() != null)
			setFont(getFont().deriveFont(Font.PLAIN));

		internalSetEnabled(enable);
		
		if(isEnabled)
		{
			if(toBeExecuted)
			{
				setForeground(Color.blue);
				setFont(getFont().deriveFont(Font.BOLD));
				if(getText() != null)
					setText(getText().trim());
			}
		}
		
		setIcon(SwingUtil.getIcon(iconName, iconType, isEnabled));
		return this;
	}
	
	private void internalSetEnabled(boolean enabled)
	{
		isEnabled = enabled;
		if(!enabled)
			setForeground(Color.gray);
	}
}