/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.harness;

import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * @author jtoomey
 */
public class JavaExecutableObjectAdapter implements IExecutableObjectAdapter {

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.execution.harness.IExecutableObjectAdapter#setupExecutableObject(org.eclipse.hyades.execution.core.IExecutableObject, org.eclipse.hyades.models.common.testprofile.TPFTestSuite, java.lang.String)
	 */
	public void setupExecutableObject(
		IExecutableObject execObj,
		TPFTestSuite suite,
		TPFTest test)
		throws ClassCastException {
		
		// Read the classname of the test out of the test suite and
		// put it into the executable Object
		ITestSuite facadeSuite = (ITestSuite) suite;
		String testClass = facadeSuite.getImplementor().getResource();
		
		// TODO: put this into the execObj when Kris has finsihed refactoring

	}

}
