package org.eclipse.hyades.internal.config.generator;

import com.ibm.etools.xmlschema.beans.ComplexType;

/**
* This class represents the complex type <Service>
*/
public class Service extends ComplexType
{
  public Service()
  {
  }
  
  public void setOption(int index, Option Option)
  {
    setElementValue(index, "Option", Option);
  }
  
  public Option getOption(int index)
  {
    return (Option) getElementValue("Option", "Option", index);
  }
  
  public int getOptionCount()
  {
    return sizeOfElement("Option");
  }
  
  public boolean removeOption(int index)
  {
    return removeElement(index, "Option");
  }
  
  public void setConfiguration(String configuration)
  {
    setAttributeValue("configuration", configuration);
  }
  
  public String getConfiguration()
  {
    return getAttributeValue("configuration");
  }
  
  public boolean removeConfiguration()
  {
    return removeAttribute("configuration");
  }
  
  public void setName(String name)
  {
    setAttributeValue("name", name);
  }
  
  public String getName()
  {
    return getAttributeValue("name");
  }
  
  public boolean removeName()
  {
    return removeAttribute("name");
  }
  
  public void setPath(String path)
  {
    setAttributeValue("path", path);
  }
  
  public String getPath()
  {
    return getAttributeValue("path");
  }
  
  public boolean removePath()
  {
    return removeAttribute("path");
  }
  
}

