/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.interactions;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.hyades.models.common.common.CommonPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsFactory
 * @generated
 */
public interface Common_Behavior_InteractionsPackage extends EPackage{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "interactions";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/hyades/models/common/behavior/interactions.xmi";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Common_Behavior_Interactions";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	Common_Behavior_InteractionsPackage eINSTANCE = org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl <em>BVR Lifeline</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl
	 * @see org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl#getBVRLifeline()
	 * @generated
	 */
	int BVR_LIFELINE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_LIFELINE__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_LIFELINE__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_LIFELINE__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Interaction Fragments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_LIFELINE__INTERACTION_FRAGMENTS = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Instances</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_LIFELINE__INSTANCES = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Part Decomposition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_LIFELINE__PART_DECOMPOSITION = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Interaction</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_LIFELINE__INTERACTION = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the the '<em>BVR Lifeline</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_LIFELINE_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl <em>BVR Interaction Fragment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl
	 * @see org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl#getBVRInteractionFragment()
	 * @generated
	 */
	int BVR_INTERACTION_FRAGMENT = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_INTERACTION_FRAGMENT__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_INTERACTION_FRAGMENT__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_INTERACTION_FRAGMENT__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Lifelines</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_INTERACTION_FRAGMENT__LIFELINES = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>General Orderings</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_INTERACTION_FRAGMENT__MESSAGES = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_INTERACTION_FRAGMENT__PROPERTIES = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Interaction</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_INTERACTION_FRAGMENT__INTERACTION = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Default Application</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the the '<em>BVR Interaction Fragment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_INTERACTION_FRAGMENT_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.interactions.impl.BVRMessageImpl <em>BVR Message</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.interactions.impl.BVRMessageImpl
	 * @see org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl#getBVRMessage()
	 * @generated
	 */
	int BVR_MESSAGE = 2;

	/**
	 * The feature id for the '<em><b>Message Sort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE__MESSAGE_SORT = 0;

	/**
	 * The feature id for the '<em><b>Receive Message End</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE__RECEIVE_MESSAGE_END = 1;

	/**
	 * The feature id for the '<em><b>Send Message End</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE__SEND_MESSAGE_END = 2;

	/**
	 * The feature id for the '<em><b>Interaction Fragment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE__INTERACTION_FRAGMENT = 3;

	/**
	 * The feature id for the '<em><b>Instance Values</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE__INSTANCE_VALUES = 4;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE__OPERATION = 5;

	/**
	 * The number of structural features of the the '<em>BVR Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_FEATURE_COUNT = 6;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.interactions.impl.BVRGeneralOrderingImpl <em>BVR General Ordering</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.interactions.impl.BVRGeneralOrderingImpl
	 * @see org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl#getBVRGeneralOrdering()
	 * @generated
	 */
	int BVR_GENERAL_ORDERING = 3;

	/**
	 * The feature id for the '<em><b>Previous Event Occurrence</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_GENERAL_ORDERING__PREVIOUS_EVENT_OCCURRENCE = 0;

	/**
	 * The feature id for the '<em><b>Next Event Occurence</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_GENERAL_ORDERING__NEXT_EVENT_OCCURENCE = 1;

	/**
	 * The number of structural features of the the '<em>BVR General Ordering</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_GENERAL_ORDERING_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.interactions.impl.BVREventOccurrenceImpl <em>BVR Event Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.interactions.impl.BVREventOccurrenceImpl
	 * @see org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl#getBVREventOccurrence()
	 * @generated
	 */
	int BVR_EVENT_OCCURRENCE = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__ID = BVR_INTERACTION_FRAGMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__NAME = BVR_INTERACTION_FRAGMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__DESCRIPTION = BVR_INTERACTION_FRAGMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Lifelines</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__LIFELINES = BVR_INTERACTION_FRAGMENT__LIFELINES;

	/**
	 * The feature id for the '<em><b>General Orderings</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__GENERAL_ORDERINGS = BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__MESSAGES = BVR_INTERACTION_FRAGMENT__MESSAGES;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__PROPERTIES = BVR_INTERACTION_FRAGMENT__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Interaction</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__INTERACTION = BVR_INTERACTION_FRAGMENT__INTERACTION;

	/**
	 * The feature id for the '<em><b>Default Application</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__DEFAULT_APPLICATION = BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION;

	/**
	 * The feature id for the '<em><b>Target General Orderings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__TARGET_GENERAL_ORDERINGS = BVR_INTERACTION_FRAGMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Source General Orderings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__SOURCE_GENERAL_ORDERINGS = BVR_INTERACTION_FRAGMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Finish Execution Occurrence</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE = BVR_INTERACTION_FRAGMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Start Execution Ocurrence</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE = BVR_INTERACTION_FRAGMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the the '<em>BVR Event Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EVENT_OCCURRENCE_FEATURE_COUNT = BVR_INTERACTION_FRAGMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.interactions.impl.BVRMessageEndImpl <em>BVR Message End</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.interactions.impl.BVRMessageEndImpl
	 * @see org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl#getBVRMessageEnd()
	 * @generated
	 */
	int BVR_MESSAGE_END = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__ID = BVR_EVENT_OCCURRENCE__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__NAME = BVR_EVENT_OCCURRENCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__DESCRIPTION = BVR_EVENT_OCCURRENCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Lifelines</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__LIFELINES = BVR_EVENT_OCCURRENCE__LIFELINES;

	/**
	 * The feature id for the '<em><b>General Orderings</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__GENERAL_ORDERINGS = BVR_EVENT_OCCURRENCE__GENERAL_ORDERINGS;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__MESSAGES = BVR_EVENT_OCCURRENCE__MESSAGES;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__PROPERTIES = BVR_EVENT_OCCURRENCE__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Interaction</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__INTERACTION = BVR_EVENT_OCCURRENCE__INTERACTION;

	/**
	 * The feature id for the '<em><b>Default Application</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__DEFAULT_APPLICATION = BVR_EVENT_OCCURRENCE__DEFAULT_APPLICATION;

	/**
	 * The feature id for the '<em><b>Target General Orderings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__TARGET_GENERAL_ORDERINGS = BVR_EVENT_OCCURRENCE__TARGET_GENERAL_ORDERINGS;

	/**
	 * The feature id for the '<em><b>Source General Orderings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__SOURCE_GENERAL_ORDERINGS = BVR_EVENT_OCCURRENCE__SOURCE_GENERAL_ORDERINGS;

	/**
	 * The feature id for the '<em><b>Finish Execution Occurrence</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__FINISH_EXECUTION_OCCURRENCE = BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Start Execution Ocurrence</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__START_EXECUTION_OCURRENCE = BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE;

	/**
	 * The feature id for the '<em><b>Receive Message</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__RECEIVE_MESSAGE = BVR_EVENT_OCCURRENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Send Message</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END__SEND_MESSAGE = BVR_EVENT_OCCURRENCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>BVR Message End</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_MESSAGE_END_FEATURE_COUNT = BVR_EVENT_OCCURRENCE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.interactions.impl.BVRExecutionOccurrenceImpl <em>BVR Execution Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.interactions.impl.BVRExecutionOccurrenceImpl
	 * @see org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl#getBVRExecutionOccurrence()
	 * @generated
	 */
	int BVR_EXECUTION_OCCURRENCE = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__ID = BVR_INTERACTION_FRAGMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__NAME = BVR_INTERACTION_FRAGMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__DESCRIPTION = BVR_INTERACTION_FRAGMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Lifelines</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__LIFELINES = BVR_INTERACTION_FRAGMENT__LIFELINES;

	/**
	 * The feature id for the '<em><b>General Orderings</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__GENERAL_ORDERINGS = BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__MESSAGES = BVR_INTERACTION_FRAGMENT__MESSAGES;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__PROPERTIES = BVR_INTERACTION_FRAGMENT__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Interaction</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__INTERACTION = BVR_INTERACTION_FRAGMENT__INTERACTION;

	/**
	 * The feature id for the '<em><b>Default Application</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__DEFAULT_APPLICATION = BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION;

	/**
	 * The feature id for the '<em><b>Finish Event Occurrence</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__FINISH_EVENT_OCCURRENCE = BVR_INTERACTION_FRAGMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Before Event Occurrence</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__BEFORE_EVENT_OCCURRENCE = BVR_INTERACTION_FRAGMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Other Behavior</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR = BVR_INTERACTION_FRAGMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the the '<em>BVR Execution Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_EXECUTION_OCCURRENCE_FEATURE_COUNT = BVR_INTERACTION_FRAGMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.interactions.impl.BVRStateInvariantImpl <em>BVR State Invariant</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.interactions.impl.BVRStateInvariantImpl
	 * @see org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl#getBVRStateInvariant()
	 * @generated
	 */
	int BVR_STATE_INVARIANT = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STATE_INVARIANT__ID = BVR_INTERACTION_FRAGMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STATE_INVARIANT__NAME = BVR_INTERACTION_FRAGMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STATE_INVARIANT__DESCRIPTION = BVR_INTERACTION_FRAGMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Lifelines</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STATE_INVARIANT__LIFELINES = BVR_INTERACTION_FRAGMENT__LIFELINES;

	/**
	 * The feature id for the '<em><b>General Orderings</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STATE_INVARIANT__GENERAL_ORDERINGS = BVR_INTERACTION_FRAGMENT__GENERAL_ORDERINGS;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STATE_INVARIANT__MESSAGES = BVR_INTERACTION_FRAGMENT__MESSAGES;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STATE_INVARIANT__PROPERTIES = BVR_INTERACTION_FRAGMENT__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Interaction</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STATE_INVARIANT__INTERACTION = BVR_INTERACTION_FRAGMENT__INTERACTION;

	/**
	 * The feature id for the '<em><b>Default Application</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STATE_INVARIANT__DEFAULT_APPLICATION = BVR_INTERACTION_FRAGMENT__DEFAULT_APPLICATION;

	/**
	 * The number of structural features of the the '<em>BVR State Invariant</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STATE_INVARIANT_FEATURE_COUNT = BVR_INTERACTION_FRAGMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.interactions.impl.BVRStopImpl <em>BVR Stop</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.interactions.impl.BVRStopImpl
	 * @see org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl#getBVRStop()
	 * @generated
	 */
	int BVR_STOP = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__ID = BVR_EVENT_OCCURRENCE__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__NAME = BVR_EVENT_OCCURRENCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__DESCRIPTION = BVR_EVENT_OCCURRENCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Lifelines</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__LIFELINES = BVR_EVENT_OCCURRENCE__LIFELINES;

	/**
	 * The feature id for the '<em><b>General Orderings</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__GENERAL_ORDERINGS = BVR_EVENT_OCCURRENCE__GENERAL_ORDERINGS;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__MESSAGES = BVR_EVENT_OCCURRENCE__MESSAGES;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__PROPERTIES = BVR_EVENT_OCCURRENCE__PROPERTIES;

	/**
	 * The feature id for the '<em><b>Interaction</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__INTERACTION = BVR_EVENT_OCCURRENCE__INTERACTION;

	/**
	 * The feature id for the '<em><b>Default Application</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__DEFAULT_APPLICATION = BVR_EVENT_OCCURRENCE__DEFAULT_APPLICATION;

	/**
	 * The feature id for the '<em><b>Target General Orderings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__TARGET_GENERAL_ORDERINGS = BVR_EVENT_OCCURRENCE__TARGET_GENERAL_ORDERINGS;

	/**
	 * The feature id for the '<em><b>Source General Orderings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__SOURCE_GENERAL_ORDERINGS = BVR_EVENT_OCCURRENCE__SOURCE_GENERAL_ORDERINGS;

	/**
	 * The feature id for the '<em><b>Finish Execution Occurrence</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__FINISH_EXECUTION_OCCURRENCE = BVR_EVENT_OCCURRENCE__FINISH_EXECUTION_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Start Execution Ocurrence</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP__START_EXECUTION_OCURRENCE = BVR_EVENT_OCCURRENCE__START_EXECUTION_OCURRENCE;

	/**
	 * The number of structural features of the the '<em>BVR Stop</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_STOP_FEATURE_COUNT = BVR_EVENT_OCCURRENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.interactions.impl.BVRPropertyImpl <em>BVR Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.interactions.impl.BVRPropertyImpl
	 * @see org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl#getBVRProperty()
	 * @generated
	 */
	int BVR_PROPERTY = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_PROPERTY__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_PROPERTY__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_PROPERTY__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_PROPERTY__VALUE = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>BVR Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BVR_PROPERTY_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.interactions.BVRMessageSort <em>BVR Message Sort</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessageSort
	 * @see org.eclipse.hyades.models.common.interactions.impl.Common_Behavior_InteractionsPackageImpl#getBVRMessageSort()
	 * @generated
	 */
	int BVR_MESSAGE_SORT = 10;


	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.interactions.BVRLifeline <em>BVR Lifeline</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>BVR Lifeline</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRLifeline
	 * @generated
	 */
	EClass getBVRLifeline();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getInteractionFragments <em>Interaction Fragments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Interaction Fragments</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRLifeline#getInteractionFragments()
	 * @see #getBVRLifeline()
	 * @generated
	 */
	EReference getBVRLifeline_InteractionFragments();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getInstances <em>Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Instances</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRLifeline#getInstances()
	 * @see #getBVRLifeline()
	 * @generated
	 */
	EReference getBVRLifeline_Instances();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getPartDecomposition <em>Part Decomposition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Part Decomposition</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRLifeline#getPartDecomposition()
	 * @see #getBVRLifeline()
	 * @generated
	 */
	EReference getBVRLifeline_PartDecomposition();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getInteraction <em>Interaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Interaction</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRLifeline#getInteraction()
	 * @see #getBVRLifeline()
	 * @generated
	 */
	EReference getBVRLifeline_Interaction();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment <em>BVR Interaction Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>BVR Interaction Fragment</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRInteractionFragment
	 * @generated
	 */
	EClass getBVRInteractionFragment();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getLifelines <em>Lifelines</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Lifelines</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getLifelines()
	 * @see #getBVRInteractionFragment()
	 * @generated
	 */
	EReference getBVRInteractionFragment_Lifelines();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getGeneralOrderings <em>General Orderings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>General Orderings</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getGeneralOrderings()
	 * @see #getBVRInteractionFragment()
	 * @generated
	 */
	EReference getBVRInteractionFragment_GeneralOrderings();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getMessages <em>Messages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Messages</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getMessages()
	 * @see #getBVRInteractionFragment()
	 * @generated
	 */
	EReference getBVRInteractionFragment_Messages();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getProperties <em>Properties</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Properties</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getProperties()
	 * @see #getBVRInteractionFragment()
	 * @generated
	 */
	EReference getBVRInteractionFragment_Properties();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getInteraction <em>Interaction</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Interaction</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getInteraction()
	 * @see #getBVRInteractionFragment()
	 * @generated
	 */
	EReference getBVRInteractionFragment_Interaction();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getDefaultApplication <em>Default Application</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Default Application</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getDefaultApplication()
	 * @see #getBVRInteractionFragment()
	 * @generated
	 */
	EReference getBVRInteractionFragment_DefaultApplication();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.interactions.BVRMessage <em>BVR Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>BVR Message</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessage
	 * @generated
	 */
	EClass getBVRMessage();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getMessageSort <em>Message Sort</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Message Sort</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessage#getMessageSort()
	 * @see #getBVRMessage()
	 * @generated
	 */
	EAttribute getBVRMessage_MessageSort();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getReceiveMessageEnd <em>Receive Message End</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Receive Message End</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessage#getReceiveMessageEnd()
	 * @see #getBVRMessage()
	 * @generated
	 */
	EReference getBVRMessage_ReceiveMessageEnd();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getSendMessageEnd <em>Send Message End</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Send Message End</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessage#getSendMessageEnd()
	 * @see #getBVRMessage()
	 * @generated
	 */
	EReference getBVRMessage_SendMessageEnd();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getInteractionFragment <em>Interaction Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Interaction Fragment</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessage#getInteractionFragment()
	 * @see #getBVRMessage()
	 * @generated
	 */
	EReference getBVRMessage_InteractionFragment();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getInstanceValues <em>Instance Values</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Instance Values</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessage#getInstanceValues()
	 * @see #getBVRMessage()
	 * @generated
	 */
	EReference getBVRMessage_InstanceValues();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Operation</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessage#getOperation()
	 * @see #getBVRMessage()
	 * @generated
	 */
	EReference getBVRMessage_Operation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering <em>BVR General Ordering</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>BVR General Ordering</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering
	 * @generated
	 */
	EClass getBVRGeneralOrdering();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getPreviousEventOccurrence <em>Previous Event Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Previous Event Occurrence</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getPreviousEventOccurrence()
	 * @see #getBVRGeneralOrdering()
	 * @generated
	 */
	EReference getBVRGeneralOrdering_PreviousEventOccurrence();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getNextEventOccurence <em>Next Event Occurence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Next Event Occurence</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getNextEventOccurence()
	 * @see #getBVRGeneralOrdering()
	 * @generated
	 */
	EReference getBVRGeneralOrdering_NextEventOccurence();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence <em>BVR Event Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>BVR Event Occurrence</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVREventOccurrence
	 * @generated
	 */
	EClass getBVREventOccurrence();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getTargetGeneralOrderings <em>Target General Orderings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Target General Orderings</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getTargetGeneralOrderings()
	 * @see #getBVREventOccurrence()
	 * @generated
	 */
	EReference getBVREventOccurrence_TargetGeneralOrderings();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getSourceGeneralOrderings <em>Source General Orderings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Source General Orderings</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getSourceGeneralOrderings()
	 * @see #getBVREventOccurrence()
	 * @generated
	 */
	EReference getBVREventOccurrence_SourceGeneralOrderings();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getFinishExecutionOccurrence <em>Finish Execution Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Finish Execution Occurrence</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getFinishExecutionOccurrence()
	 * @see #getBVREventOccurrence()
	 * @generated
	 */
	EReference getBVREventOccurrence_FinishExecutionOccurrence();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getStartExecutionOcurrence <em>Start Execution Ocurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Start Execution Ocurrence</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getStartExecutionOcurrence()
	 * @see #getBVREventOccurrence()
	 * @generated
	 */
	EReference getBVREventOccurrence_StartExecutionOcurrence();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.interactions.BVRMessageEnd <em>BVR Message End</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>BVR Message End</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessageEnd
	 * @generated
	 */
	EClass getBVRMessageEnd();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getReceiveMessage <em>Receive Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Receive Message</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getReceiveMessage()
	 * @see #getBVRMessageEnd()
	 * @generated
	 */
	EReference getBVRMessageEnd_ReceiveMessage();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getSendMessage <em>Send Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Send Message</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getSendMessage()
	 * @see #getBVRMessageEnd()
	 * @generated
	 */
	EReference getBVRMessageEnd_SendMessage();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence <em>BVR Execution Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>BVR Execution Occurrence</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence
	 * @generated
	 */
	EClass getBVRExecutionOccurrence();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence#getFinishEventOccurrence <em>Finish Event Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Finish Event Occurrence</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence#getFinishEventOccurrence()
	 * @see #getBVRExecutionOccurrence()
	 * @generated
	 */
	EReference getBVRExecutionOccurrence_FinishEventOccurrence();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence#getBeforeEventOccurrence <em>Before Event Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Before Event Occurrence</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence#getBeforeEventOccurrence()
	 * @see #getBVRExecutionOccurrence()
	 * @generated
	 */
	EReference getBVRExecutionOccurrence_BeforeEventOccurrence();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence#getOtherBehavior <em>Other Behavior</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Other Behavior</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence#getOtherBehavior()
	 * @see #getBVRExecutionOccurrence()
	 * @generated
	 */
	EReference getBVRExecutionOccurrence_OtherBehavior();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.interactions.BVRStateInvariant <em>BVR State Invariant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>BVR State Invariant</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRStateInvariant
	 * @generated
	 */
	EClass getBVRStateInvariant();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.interactions.BVRStop <em>BVR Stop</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>BVR Stop</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRStop
	 * @generated
	 */
	EClass getBVRStop();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.interactions.BVRProperty <em>BVR Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>BVR Property</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRProperty
	 * @generated
	 */
	EClass getBVRProperty();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.interactions.BVRProperty#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRProperty#getValue()
	 * @see #getBVRProperty()
	 * @generated
	 */
	EAttribute getBVRProperty_Value();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.common.interactions.BVRMessageSort <em>BVR Message Sort</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>BVR Message Sort</em>'.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessageSort
	 * @generated
	 */
	EEnum getBVRMessageSort();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	Common_Behavior_InteractionsFactory getCommon_Behavior_InteractionsFactory();

} //Common_Behavior_InteractionsPackage
