/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent;
import org.eclipse.hyades.models.common.facades.behavioral.IStub;
import org.eclipse.hyades.models.common.facades.behavioral.ISystemUnderTest;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class FacadeUtil {

	public static final FacadeUtil INSTANCE = new FacadeUtil();

	public CFGClass getType(String type, ITest test)
	{
		ITestSuite testSuite = null;
		if(test instanceof ITestSuite)
		{
			testSuite = (ITestSuite)test;	
		}
		else if(test instanceof ITestCase)
		{
			testSuite = ((ITestCase)test).getOwner();
		}
		
		if(type.equals(testSuite.getName()))
		{
			return (CFGClassImpl)testSuite;
		}	
		List systemUnderTests = testSuite.getISystemsUnderTest();
		for(int i = 0; i < systemUnderTests.size(); i++)
		{
			ISystemUnderTest systemUnderTest = (ISystemUnderTest)systemUnderTests.get(i);
			if(type.equals(systemUnderTest.getName()))
			{
				return (CFGClassImpl)systemUnderTest;
			}
		}
		List stubs = testSuite.getIStubs();
		for(int i = 0; i < stubs.size(); i++)
		{
			IStub stub = (IStub)stubs.get(i);
			if(type.equals(stub.getName()))
			{
				return (CFGClassImpl)stub;
			}
		}

		Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
		Map m = reg.getExtensionToFactoryMap();
		m.put("xmi", new FacadeResourceFactoryImpl());		

		try
		{
			ResourceSet predefinedTypes = new ResourceSetImpl();
			predefinedTypes.getResource(URI.createURI("JavaTypes.xmi"), true);
			TreeIterator iterator = predefinedTypes.getAllContents();
			while(iterator.hasNext())
			{
				IDeployableComponent typeClass = (IDeployableComponent)iterator.next();
				if(type.equals(typeClass.getName()))
				{
					return (CFGClassImpl)typeClass;	
				}
			}
		}
		catch(Exception e)
		{
			// ignore exception
		}
			
		return null;
	}


}
