/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class SaveManager
extends TimerTask
{
	public static final Map RESOURCE_OPTIONS = new HashMap();
	{
		RESOURCE_OPTIONS.put(XMIResource.OPTION_DECLARE_XML, Boolean.TRUE);
		RESOURCE_OPTIONS.put(XMIResource.OPTION_SKIP_ESCAPE, Boolean.FALSE);
	}

	private static SaveManager instance;

	private Timer timer;
	private List resources;
	private boolean running;
	
	private SaveManager()
	{
		running = false;
	}
	
	public synchronized void dispose()
	{
		stop();
		
		if(resources != null)
			resources.clear();

		instance = null;
	}
	
	public static SaveManager getInstance()
	{
		if(instance == null)
			instance = new SaveManager();
		return instance;
	}

	public static void saveResource(EObject eObject)
	{
		if(eObject != null)
			saveResource(eObject.eResource());
	}
	
	public static void saveResource(Resource resource)
	{
		if(resource != null)
		{
			try
			{
				resource.save(RESOURCE_OPTIONS);
			}
			catch (IOException e)
			{
			}
		}
	}
	
	public void addResource(Resource resource)
	{
		if(resource == null)
			return;
			
		resource.setTrackingModification(true);
		if(resources == null)
			resources = new ArrayList();
		resources.add(resource);
	}

	public void removeResource(Resource resource)
	{
		if(resources != null)
			resources.remove(resource);
	}
	
	public void removeAllResources()
	{
		if(resources != null)
			resources.clear();		
	}
	
	public Resource[] getResources()
	{
		if(resources == null)
			return new Resource[0];
		return (Resource[])resources.toArray(new Resource[resources.size()]);
	}


	public void saveResources()
	{	
		if((resources == null) || (resources.isEmpty()))
			return;

		Resource[] resourceArray = getResources();
		for(int i = 0, maxi = resourceArray.length; i < maxi; i++)
		{
			if(resourceArray[i].isModified())
				saveResource(resourceArray[i]);
		}
	}
	
	public synchronized void start(long saveInterval)
	{
		if((!isRunning()) && (saveInterval > 0))
		{
			timer = new Timer(true);
			timer.schedule(this, saveInterval, saveInterval);
			running = true;
		}
	}
	
	public synchronized void stop()
	{
		running = false;
		if(timer != null)
		{
			timer.cancel();
			timer = null;
		}
	}
	
	public boolean isRunning()
	{
		return running;
	}
		
	public void run()
	{
		if((resources == null) || (resources.isEmpty()))
			return;
			
		Thread thread = new Thread()
		{
			public void run()
			{
				if(isRunning())
					saveResources();
			}
		};
		thread.setName(getClass().getName());
		thread.start();
	}	
}
