/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDRepresentation;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.StatisticalPackage;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>SD Member Descriptor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDMemberDescriptorImpl#getRepresentation <em>Representation</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDMemberDescriptorImpl#getSnapshotObservation <em>Snapshot Observation</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class SDMemberDescriptorImpl extends SDDescriptorImpl implements SDMemberDescriptor {
	/**
	 * The cached value of the '{@link #getRepresentation() <em>Representation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRepresentation()
	 * @generated
	 * @ordered
	 */
	protected SDRepresentation representation = null;

	/**
	 * The cached value of the '{@link #getSnapshotObservation() <em>Snapshot Observation</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSnapshotObservation()
	 * @generated
	 * @ordered
	 */
	protected EList snapshotObservation = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SDMemberDescriptorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return StatisticalPackage.eINSTANCE.getSDMemberDescriptor();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDRepresentation getRepresentation() {
		if (representation != null && representation.eIsProxy()) {
			SDRepresentation oldRepresentation = representation;
			representation = (SDRepresentation)EcoreUtil.resolve(representation, this);
			if (representation != oldRepresentation) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION, oldRepresentation, representation));
			}
		}
		return representation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SDRepresentation basicGetRepresentation() {
		return representation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRepresentation(SDRepresentation newRepresentation) {
		SDRepresentation oldRepresentation = representation;
		representation = newRepresentation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION, oldRepresentation, representation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSnapshotObservation() {
		if (snapshotObservation == null) {
			snapshotObservation = new EObjectWithInverseResolvingEList(SDSnapshotObservation.class, this, StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION, StatisticalPackage.SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR);
		}
		return snapshotObservation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case StatisticalPackage.SD_MEMBER_DESCRIPTOR__AGENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, StatisticalPackage.SD_MEMBER_DESCRIPTOR__AGENT, msgs);
				case StatisticalPackage.SD_MEMBER_DESCRIPTOR__CHILDREN:
					return ((InternalEList)getChildren()).basicAdd(otherEnd, msgs);
				case StatisticalPackage.SD_MEMBER_DESCRIPTOR__PARENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, StatisticalPackage.SD_MEMBER_DESCRIPTOR__PARENT, msgs);
				case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
					return ((InternalEList)getSnapshotObservation()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case StatisticalPackage.SD_MEMBER_DESCRIPTOR__AGENT:
					return eBasicSetContainer(null, StatisticalPackage.SD_MEMBER_DESCRIPTOR__AGENT, msgs);
				case StatisticalPackage.SD_MEMBER_DESCRIPTOR__CHILDREN:
					return ((InternalEList)getChildren()).basicRemove(otherEnd, msgs);
				case StatisticalPackage.SD_MEMBER_DESCRIPTOR__PARENT:
					return eBasicSetContainer(null, StatisticalPackage.SD_MEMBER_DESCRIPTOR__PARENT, msgs);
				case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
					return ((InternalEList)getSnapshotObservation()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case StatisticalPackage.SD_MEMBER_DESCRIPTOR__AGENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, HierarchyPackage.TRC_AGENT__DESCRIPTOR, TRCAgent.class, msgs);
				case StatisticalPackage.SD_MEMBER_DESCRIPTOR__PARENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, StatisticalPackage.SD_DESCRIPTOR__CHILDREN, SDDescriptor.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__AGENT:
				return getAgent();
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__DESCRIPTION:
				return getDescription();
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__NAME:
				return getName();
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__CHILDREN:
				return getChildren();
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__PARENT:
				return getParent();
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION:
				if (resolve) return getRepresentation();
				return basicGetRepresentation();
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
				return getSnapshotObservation();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__AGENT:
				setAgent((TRCAgent)newValue);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__NAME:
				setName((String)newValue);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__CHILDREN:
				getChildren().clear();
				getChildren().addAll((Collection)newValue);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__PARENT:
				setParent((SDDescriptor)newValue);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION:
				setRepresentation((SDRepresentation)newValue);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
				getSnapshotObservation().clear();
				getSnapshotObservation().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__AGENT:
				setAgent((TRCAgent)null);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__NAME:
				setName(NAME_EDEFAULT);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__CHILDREN:
				getChildren().clear();
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__PARENT:
				setParent((SDDescriptor)null);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION:
				setRepresentation((SDRepresentation)null);
				return;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
				getSnapshotObservation().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__AGENT:
				return getAgent() != null;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__CHILDREN:
				return children != null && !children.isEmpty();
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__PARENT:
				return getParent() != null;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION:
				return representation != null;
			case StatisticalPackage.SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION:
				return snapshotObservation != null && !snapshotObservation.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //SDMemberDescriptorImpl
