package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.core.ISerializableAsXml;
/**
 * @author rduggan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class CommonBaseEventImpl implements ICommonBaseEvent, ISerializableAsXml {

	/**
	 * The version of the event API
	 */
	public final static String version = "CommonBaseEvent V1.0.0";

    /**
     * The associations elements with the other artifacts.
     */
    protected IMsgDataElement msgDataElement;
    protected IComponentIdentification reporterComponentId;
    protected IComponentIdentification sourceComponentId;
    protected HashMap contextDataElements = new HashMap();
    protected HashMap extendedDataElements = new HashMap();
    protected HashMap associatedEvents = new HashMap();

    /**
     * The fields.
     */
    protected String extensionName;
    protected String localInstanceId;
    protected String globalInstanceId;
    protected String creationTime;
    protected long   creationTimeValue;
    protected String situationType;
    protected String msg;
    protected long elapsedTime;
    protected short severity;
    protected short priority;
    protected short repeatCount;
    protected long sequenceNumber;

    /**
     * 
     */
    protected CommonBaseEventImpl() {
        init();
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#addContextDataElement(IContextDataElement)
     */
    public void addContextDataElement(IContextDataElement element) {
        this.contextDataElements.put(element.getName(), element);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#addExtendedDataElement(IExtendedDataElement)
     */
    public void addExtendedDataElement(IExtendedDataElement element) {
        this.extendedDataElements.put(element.getName(), element);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#addAssociatedEvent(IAssociatedEvent)
     */
    public void addAssociatedEvent(IAssociatedEvent event) {
		String associatedEngineName = event.getAssociationEngine().getName();
     
		 if(associatedEngineName != null) {
		 	this.associatedEvents.put(associatedEngineName, event);
		 }
		 else {
			// should really cretae a new exception for this
			throw new RuntimeException("IAssociatedEvent must be assigned an AssociatineEngine to add it to an instance of ICommonBaseEvent");
		 }

        

    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getContextDataElements()
     */
    public IContextDataElement[] getContextDataElements() {
		synchronized(contextDataElements) {
    		if(contextDataElements.size()>0) {
				IContextDataElement[] array=new IContextDataElement[contextDataElements.size()];
				Iterator iter=contextDataElements.values().iterator();
				for(int i=0;iter.hasNext();i++) {
					array[i]=(IContextDataElement)iter.next();
				}
				return array;
			}
			return null;
    	}
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getExtendedDataElements()
     */
    public IExtendedDataElement[] getExtendedDataElements() {
		synchronized(extendedDataElements) {
			if(extendedDataElements.size()>0) {
				IExtendedDataElement[] array=new IExtendedDataElement[extendedDataElements.size()];
				Iterator iter=extendedDataElements.values().iterator();
				for(int i=0;iter.hasNext();i++) {
					array[i]=(IExtendedDataElement)iter.next();
				}
				return array;
			}
			return null;
		}
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getAssociatedEvents()
     */
    public IAssociatedEvent[] getAssociatedEvents() {
		synchronized(associatedEvents) {
			if(associatedEvents.size()>0) {
				IAssociatedEvent[] array=new IAssociatedEvent[associatedEvents.size()];
				Iterator iter=associatedEvents.values().iterator();
				for(int i=0;iter.hasNext();i++) {
					array[i]=(IAssociatedEvent)iter.next();
				}
				return array;
			}
			return null;
		}
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getContextDataElement(String)
     */
    public IContextDataElement getContextDataElement(String name) {
        return (IContextDataElement) contextDataElements.get(name);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getExtendedDataElement(String)
     */
    public IExtendedDataElement getExtendedDataElement(String name) {
        return (IExtendedDataElement) extendedDataElements.get(name);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#removeContextDataElement(String)
     */
    public void removeContextDataElement(String name) {
        contextDataElements.remove(name);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#removeExtendedDataElement(String)
     */
    public void removeExtendedDataElement(String name) {
        extendedDataElements.remove(name);
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#clearAssociatedEvents()
     */
    public void clearAssociatedEvents() {
        associatedEvents.clear();
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#clearContextDataElements()
     */
    public void clearContextDataElements() {
        contextDataElements.clear();
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#clearExtendedDataElements()
     */
    public void clearExtendedDataElements() {
        extendedDataElements.clear();
    }

	/**
	 * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getCreationTime()
	 */
	public String getCreationTime() {
        if((creationTime == null) && (creationTimeValue > 0))
        {
			creationTime=CbeFormatter.convertDateToXmlSchemaDateTime(creationTimeValue);
        }
		return creationTime;
	}
    
    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getCreationTimeAsLong()
     */
    public long getCreationTimeAsLong() {
        
        if((creationTimeValue == 0) && (creationTime != null))
        {
			creationTimeValue=CbeFormatter.convertXmlSchemaDateTimeToDate(creationTime);
        }
        
        return creationTimeValue;
    }    

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getElapsedTime()
     */
    public long getElapsedTime() {
        return elapsedTime;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getExtensionName()
     */
    public String getExtensionName() {
        return extensionName;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getGlobalInstanceId()
     */
    public String getGlobalInstanceId() {
        return globalInstanceId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getLocalInstanceId()
     */
    public String getLocalInstanceId() {
        return localInstanceId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getMsg()
     */
    public String getMsg() {
        return msg;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getPriority()
     */
    public short getPriority() {
        return priority;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getRepeatCount()
     */
    public short getRepeatCount() {
        return repeatCount;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getSequenceNumber()
     */
    public long getSequenceNumber() {
        return sequenceNumber;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getSeverity()
     */
    public short getSeverity() {
        return severity;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getSituationType()
     */
    public String getSituationType() {
        return situationType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getSourceComponentId()
     */
    public IComponentIdentification getSourceComponentId() {
        return sourceComponentId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getMsgDataElement()
     */
    public IMsgDataElement getMsgDataElement() {
        return msgDataElement;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getReporterComponentId()
     */
    public IComponentIdentification getReporterComponentId() {
        return reporterComponentId;
    }

	/**
	 * @see org.eclipse.hyades.logging.ICommonBaseEvent#setCreationTime(String)
	 */
	public void setCreationTime(String creationTime) {
		this.creationTime = creationTime;
        creationTimeValue = 0;
	}
    
    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setCreationTime(long)
     */
    public void setCreationTime(long creationTime) {
        this.creationTimeValue = creationTime;
        this.creationTime = null;
    }    
    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setElapsedTime(long)
     */
    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setExtensionName(String)
     */
    public void setExtensionName(String extensionName) {
        this.extensionName = extensionName;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setGlobalInstanceId(String)
     */
    public void setGlobalInstanceId(String globalInstanceId) {
        this.globalInstanceId = globalInstanceId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setLocalInstanceId(String)
     */
    public void setLocalInstanceId(String localInstanceId) {
        this.localInstanceId = localInstanceId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setMsg(String)
     */
    public void setMsg(String msg) {
        this.msg = msg;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setPriority(short)
     */
    public void setPriority(short priority) {
        this.priority = priority;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setRepeatCount(short)
     */
    public void setRepeatCount(short repeatCount) {
        this.repeatCount = repeatCount;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setSequenceNumber(long)
     */
    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setSeverity(short)
     */
    public void setSeverity(short severity) {
        this.severity = severity;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setSituationType(String)
     */
    public void setSituationType(String situationType) {
        this.situationType = situationType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setSourceComponentId(IComponentIdentification)
     */
    public void setSourceComponentId(IComponentIdentification sourceComponentId) {
        this.sourceComponentId = sourceComponentId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setMsgDataElement(IMsgDataElement)
     */
    public void setMsgDataElement(IMsgDataElement msgDataElement) {
        this.msgDataElement = msgDataElement;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#setReporterComponentId(IComponentIdentification)
     */
    public void setReporterComponentId(IComponentIdentification reporterComponentId) {
        this.reporterComponentId = reporterComponentId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#init()
     */
    public void init() {

        /* Clear the relationships */
        clearAssociatedEvents();
        clearExtendedDataElements();
        clearContextDataElements();
        
        sourceComponentId=null;
        reporterComponentId=null;

        /* Clear the msgDataElement */
        msgDataElement=null; 

        /* Clear the local fields */
        extensionName = null;
        localInstanceId = null;
        creationTime = null;
        creationTimeValue = 0;
        situationType = null;
        msg = null;
        elapsedTime = 0;
        severity = 0;
        priority = 0;
        repeatCount = 0;
        sequenceNumber = 0;

        /* Create a new UUID */
        setGlobalInstanceId(new Guid().toString());
    }

	/**
	 * @see org.eclipse.hyades.logging.core.IExternalizableToXml#externalizeCanonicalXmlString()
	 */
	public String externalizeCanonicalXmlString() {
		return CbeFormatter.toCanonicalXMLString(this);
	}

	/**
	 * @see org.eclipse.hyades.logging.core.IExternalizableToXml#externalizeCanonicalXmlDocString()
	 */
	public String externalizeCanonicalXmlDocString() {
		return CbeFormatter.toCanonicalXMLDocString(this);
	}

	/**
	 * @see org.eclipse.hyades.logging.core.IInternalizableFromXml#internalizeCanonicalXmlString(java.lang.String)
	 */
	public void internalizeCanonicalXmlString(String value) {
		CbeFormatter.fromCanonicalXMLString(this, value);
		return; 
	}

	/**
	 * @see org.eclipse.hyades.logging.core.IInternalizableFromXml#internalizeCanonicalXmlDocString(java.lang.String)
	 */
	public void internalizeCanonicalXmlDocString(String value) {
		CbeFormatter.fromCanonicalXMLDocString(this, value);
		return; 
	}
	
	/**
	 * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getCommonBaseEventImplVersion()
	 */
	public String getCommonBaseEventImplVersion()
	{
		return version;
	}
	
	/**
	 * @see org.eclipse.hyades.logging.events.ICommonBaseEvent#getEventSchemaVersion()
	 */
	public String getEventSchemaVersion()
	{
		return CbeFormatter.getEventFormatterVersion();   
	}
    
	/**
	 * Returns an XML string representation of the CommonBaseEvent
	 */
	public String toString() {
		   return CbeFormatter.toCanonicalXMLString(this);
	}	
	
	/**
	 * Determines is two different event instance are equal.
	 */
	public boolean equals(Object obj)
	{
		boolean result = false;

		//It's the same object reference, so it HAS to be equal
		if(this == obj)
		{
			result = true;
		}
		else
		{
			//If the object is null or is not the correct type of object, it can't be
			//equal
			if((obj != null) && (obj instanceof CommonBaseEventImpl) && 
			   (getClass() == obj.getClass()))
			{
				CommonBaseEventImpl event = (CommonBaseEventImpl) obj;

				Object           event1Property;
				Object           event2Property;

				event1Property = getGlobalInstanceId();
				event2Property = event.getGlobalInstanceId();

				if(((event1Property != null) && 
					   (event1Property.equals(event2Property))) || 
				   ((event1Property == null) && (event2Property == null)))
				{
					if((getCreationTimeAsLong() == event.getCreationTimeAsLong()) && 
					   (getElapsedTime() == event.getElapsedTime()) && 
					   (getSeverity() == event.getSeverity()) && 
					   (getPriority() == event.getPriority()) && 
					   (getRepeatCount() == event.getRepeatCount()) && 
					   (getSequenceNumber() == event.getSequenceNumber()))
					{
						event1Property = getLocalInstanceId();
						event2Property = event.getLocalInstanceId();

						if(((event1Property != null) && 
							   (event1Property.equals(event2Property))) || 
						   ((event1Property == null) && (event2Property == null)))
						{
							event1Property = getExtensionName();
							event2Property = event.getExtensionName();

							if(((event1Property != null) && 
								   (event1Property.equals(event2Property))) || 
							   ((event1Property == null) && (event2Property == null)))
							{
								event1Property = getSituationType();
								event2Property = event.getSituationType();

								if(((event1Property != null) && 
									   (event1Property.equals(event2Property))) || 
								   ((event1Property == null) && 
									   (event2Property == null)))
								{
									event1Property = getMsg();
									event2Property = event.getMsg();

									if(((event1Property != null) && 
										   (event1Property.equals(event2Property))) || 
									   ((event1Property == null) && 
										   (event2Property == null)))
									{
										event1Property = getMsgDataElement();
										event2Property = event.getMsgDataElement();

										if(((event1Property != null) && 
											   (event1Property.equals(event2Property))) || 
										   ((event1Property == null) && 
											   (event2Property == null)))
										{
											event1Property = getReporterComponentId();
											event2Property = event.getReporterComponentId();

											if(((event1Property != null) && 
												   (event1Property.equals(event2Property))) || 
											   ((event1Property == null) && 
												   (event2Property == null)))
											{
												event1Property = getSourceComponentId();
												event2Property = event.getSourceComponentId();

												if(((event1Property != null) && 
													   (event1Property.equals(
															   event2Property))) || 
												   ((event1Property == null) && 
													   (event2Property == null)))
												{
													event1Property = contextDataElements;
													event2Property = event.contextDataElements;

													if(((event1Property != null) && 
														   (event1Property.equals(
																   event2Property))) || 
													   ((event1Property == null) && 
														   (event2Property == null)))
													{
														event1Property = extendedDataElements;
														event2Property = event.extendedDataElements;

														if(((event1Property != null) && 
															   (event1Property.equals(
																	   event2Property))) || 
														   ((event1Property == null) && 
															   (event2Property == null)))
														{
															event1Property = associatedEvents;
															event2Property = event.associatedEvents;

															if(((event1Property != null) && 
																   (event1Property.equals(
																		   event2Property))) || 
															   ((event1Property == null) && 
																   (event2Property == null)))
															{
																result = true;
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		return result;
	}
}
