package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * @author paules 
 * @version 1.0
 */
public interface IAssociationEngine {

    /**
     * Returns the id.
     * 
     * Id of the application that created the association. This is a REQUIRED property.
     * 
     * @return String
     */
    public String getId();

    /**
     * Sets the id.
     * 
     * Id of the application that created the association . This is a REQUIRED property.
     * 
     * @param id The id to set
     */
    public void setId(String id);

    /**
     * Returns the name.
     * 
     * Name of the application that created the association (e.g,. my correlation 
     * engine name). This is a REQUIRED property.
     * 
     * @return String
     */
    public String getName();

    /**
     * Returns the type.
     * 
     * This property should contain the type of association represented by this element.
     * Some well defined associations are:
     * 1. Contains
     * 2. Cleared
     * 3. CausedBy
     * 4. MultiPart
     * 5. Correlated
     * This is a REQUIRED property.
     * 
     * @return String
     */
    public String getType();

    /**
     * Sets the name.
     * 
     * Name of the application that created the association (e.g,. my correlation 
     * engine name). This is a REQUIRED property.
     * 
     * @param name The name to set
     */
    public void setName(String name);

    /**
     * Sets the type.
     * 
     * This property should contain the type of association represented by this element.
     * Some well defined associations are:
     * 1. Contains
     * 2. Cleared
     * 3. CausedBy
     * 4. MultiPart
     * 5. Correlated
     * This is a REQUIRED property.
     * 
     * @param type The type to set
     */
    public void setType(String type);

}
