package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * @author rduggan
 *
 * Taken from 'Autonomic Computing Common Base Event and Situations Data ACAB.BO0301.1.0'.
 * 
 * The ExtendedDataElement allows for user-supplied name-type-value collections to be
 * specified for extensibility purposes.  This is where a user can include any other 
 * attributes not accounted for in the CommonBaseEvent data model.  Collections specified
 * here are assumed to be product specific data.  The named properties can be filtered,
 * searched on, or referenced by the correlation rules. The 'name' is user defined, 
 * however, the nonexclusive list of reserved keywords are as follows: 
 * 
 * RawData - This keyword is indicative of 'as is' data and usually in a format that may
 *           be proprietary to the producer of such data. It may be in any form including
 *           binary.  It is intended to allow the data to be retrieved verbatim, and to
 *           support tools that understand the format of the context.
 * 
 * RootHeader - This keyword  is intended to identify the root ExtendedDataElement for a
 *              hierarchy of the ExtendedDataElements that are defined by the dataRefs. 
 * 
 * @version 1.0
 */
public interface IExtendedDataElement {

   public final String BYTE            = "byte";
   public final String SHORT           = "short";
   public final String INTEGER         = "int";
   public final String LONG            = "long";
   public final String FLOAT           = "float";
   public final String DOUBLE          = "double";
   public final String STRING          = "string";
   public final String BOOLEAN         = "boolean";
   public final String DATETIME        = "dateTime";
   public final String BYTE_ARRAY      = "byteArray";
   public final String SHORT_ARRAY     = "shortArray";
   public final String INTEGER_ARRAY   = "intArray";
   public final String LONG_ARRAY      = "longArray";
   public final String FLOAT_ARRAY     = "floatArray";
   public final String DOUBLE_ARRAY    = "doubleArray";
   public final String STRING_ARRAY    = "stringArray";
   public final String BOOLEAN_ARRAY   = "booleanArray";
   public final String DATETIME_ARRAY  = "dateTimeArray";
   public final String HEXBINARY       = "hexBinary";

   public final byte BYTE_DATA_TYPE            = 0;
   public final byte SHORT_DATA_TYPE           = 1;
   public final byte INTEGER_DATA_TYPE         = 2;
   public final byte LONG_DATA_TYPE            = 3;
   public final byte FLOAT_DATA_TYPE           = 4;
   public final byte DOUBLE_DATA_TYPE          = 5;
   public final byte STRING_DATA_TYPE          = 6;
   public final byte BOOLEAN_DATA_TYPE         = 7;
   public final byte DATETIME_DATA_TYPE        = 8;
   public final byte BYTE_ARRAY_DATA_TYPE      = 9;
   public final byte SHORT_ARRAY_DATA_TYPE     = 10;
   public final byte INTEGER_ARRAY_DATA_TYPE   = 11;
   public final byte LONG_ARRAY_DATA_TYPE      = 12;
   public final byte FLOAT_ARRAY_DATA_TYPE     = 13;
   public final byte DOUBLE_ARRAY_DATA_TYPE    = 14;
   public final byte STRING_ARRAY_DATA_TYPE    = 15;
   public final byte BOOLEAN_ARRAY_DATA_TYPE   = 16;
   public final byte DATETIME_ARRAY_DATA_TYPE  = 17;
   public final byte HEXBINARY_DATA_TYPE       = 28;     	


    /**
     * Adds a child data element
     *  
     * Other extendedDataElement(s) to specify a structured list of
     * child extendedDataElements.  This list allows a reporter to create a
     * hierarchy of extendedDataElements for a specific CommonBaseEvent.
     * This is an OPTIONAL property.
     * 
     */
    public void addChildDataElement(IExtendedDataElement element);

    /**
     * Returns the child data elements
     * 
     * Other extendedDataElement(s) to specify a structured list of
     * child extendedDataElements.  This list allows a reporter to create a
     * hierarchy of extendedDataElements for a specific CommonBaseEvent.
     * This is an OPTIONAL property.
     * 
     * @return Object[]
     */
    public Object[] getChildDataElements();

    /**
     * Removes a IExtendedDataElement from the child data elements table.
     */
    public void removeChildDataElement(String name);

    /**
     * Removes all IExtendedDataElements from the child data elements table.
     */
    public void clearChildDataElements();

    /**
     * 
     * The array of values for this extended data element as a string representation
     * of the type specified above, excluding hexBinary.  hexBinary values MUST be 
     * defined using the hexValue property.  This is an OPTIONAL property.
     * 
     * @return String[]
     */
    public String[] getValues();

    /**
     * 
     * The hexValue is an array of bytes that holds the data for any other data type
     * or complexType not in the supported types described above. The hexValue and 
     * values properties are mutually exclusive.  Only one of these properties 
     * can be defined.  This is an OPTIONAL property.
     * 
     * @return byte[]
     */
    public byte[] getHexValue();

    /**
     * Returns the name.
     * 
     * The name of the extended data element. This name MUST be unique with respect
     * to all other fields in the event.This is a REQUIRED property.
     * 
     * @return String
     */
    public String getName();

    /**
     * Returns the type.
     * 
     * The data type of the values specified in the values property below. Valid types
     * are as follows:
     * 1.  byte
     * 2.  short
     * 3.  int
     * 4.  long
     * 5.  float
     * 6.  double
     * 7.  string
     * 8.  dateTime
     * 9.  duration
     * 10. byteArray
     * 11. shortArray
     * 12. intArray
     * 13. longArray
     * 14. floatArray
     * 15. doubleArray
     * 16. stringArray
     * 17. dateTimeArray
     * 18. durationArray
     * 19. hexBinary
     * The above data types are the only valid types supported by the ExtendedDataElement
     * type. The default value is 'string'.
     * 
     * @return String
     */
    public String getType();

    /**
     * Returns the type as one of the enumerated type values defined in IExtendedDataElement.
     * 
     * @return byte
     */
    public byte getTypeValue();
    
	/**
	 * Sets the id.
	 * 
	 * The primary identifier for the element. This property MUST be globally unique.
	 * The recommend value for this is either a 128 bit or 256 bit Globally Unique Id 
	 * (represented as hex string). Once this value is set it MUST never be changed.
	 * This is an OPTIONAL property.
	 * 
	 * @param id The id to set
	 */
	public void setId(String id);

	/**
	 * Sets the name.
	 * 
	 * The name of the extended data element. This name MUST be unique with respect
	 * to all other fields in the event.This is a REQUIRED property.
	 * 
	 * @param name The name to set
	 */
	public void setName(String name);

	/**
	 * Sets the type.
	 * 
	 * The data type of the values specified in the values property below. Valid types
	 * are as follows:
	 * 1.  byte
	 * 2.  short
	 * 3.  int
	 * 4.  long
	 * 5.  float
	 * 6.  double
	 * 7.  string
	 * 8.  dateTime
	 * 9.  duration
	 * 10. byteArray
	 * 11. shortArray
	 * 12. intArray
	 * 13. longArray
	 * 14. floatArray
	 * 15. doubleArray
	 * 16. stringArray
	 * 17. dateTimeArray
	 * 18. durationArray
	 * 19. hexBinary
	 * The above data types are the only valid types supported by the ExtendedDataElement
	 * type. The default value is 'string'.
	 * 
	 * @param type The type to set
	 */
	public void setType(String type);

    /**
     * Sets the type. From one of the enumerated values defined in IExtendedDataElement
     * 
     * @param type The type to set
     */
    public void setType(byte type);
    
	/**
	 * 
	 * The array of values for this extended data element as a string representation
	 * of the type specified above, excluding hexBinary.  hexBinary values MUST be 
	 * defined using the hexValue property.  This is an OPTIONAL property.
	 * 
	 * @param String[] the values to set
	 */
	public void setValues(String[] values);

	/**
	 * 
	 * The hexValue is an array of bytes that holds the data for any other data type
	 * or complexType not in the supported types described above. The hexValue and 
	 * values properties are mutually exclusive.  Only one of these properties 
	 * can be defined.  This is an OPTIONAL property.
	 * 
	 * @param byte[] the hexadecimal value to set.
	 */
	public void setHexValue(byte[] hexValue);
    
    /**
     * Get the string value for this extended data element. The method is only valid 
     * if the extended data element is a String. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return String
     */
    public String getString();
    
    
    /**
     * Get the dateTime value as a long holding UTC millisecondsfor this extended data element. 
     * The method is only valid if the extended data element is a dateTime. Otherwise an 
     * exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return long
     */
    public long getDateTimeAsLong();
    
    /**
     * Get the dateTime value for this extended data element. The method is only valid 
     * if the extended data element is a dateTime. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return String
     */
    public String getDateTime();
    
    /**
     * Get the boolean value for this extended data element. The method is only valid 
     * if the extended data element is a boolean. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return boolean
     */
    boolean getBoolean();

    /**
     * Get the byte value for this extended data element. The method is only valid 
     * if the extended data element is a byte. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return byte
     */
    byte getByte();


    /**
     * Get the short value for this extended data element. The method is only valid 
     * if the extended data element is a short. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return short
     */
    short getShort();

    /**
     * Get the int value for this extended data element. The method is only valid 
     * if the extended data element is a int. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return int
     */
    int getInt();

    /**
     * Get the long value for this extended data element. The method is only valid 
     * if the extended data element is a long. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return long
     */
    long getLong();

    /**
     * Get the float value for this extended data element. The method is only valid 
     * if the extended data element is a float. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return float
     */
    float getFloat();

    /**
     * Get the double value for this extended data element. The method is only valid 
     * if the extended data element is a double. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return double
     */
    double getDouble();


    /**
     * Get the string[] value for this extended data element. The method is only valid 
     * if the event property is a String[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return String[]
     */
    public String[] getStringArray();
    
    /**
     * Get the dateTime[] value as a long[] holding UTC millisecondsfor this extended data element. 
     * The method is only valid if the extended data element is a dateTime[]. Otherwise an 
     * exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return long[]
     */
    public long[] getDateTimeArrayAsLong();

    /**
     * Get the dateTime[] value for this extended data element. The method is only valid 
     * if the extended data element is a dateTime[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return String[]
     */
    public String[] getDateTimeArray();

    /**
     * Get the boolean value for this extended data element. The method is only valid 
     * if the extended data element is a boolean[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return boolean[]
     */
    boolean[] getBooleanArray();


    /**
     * Get the byte value for this extended data element. The method is only valid 
     * if the extended data element is a byte[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return byte[]
     */
    byte[] getByteArray();


    /**
     * Get the short[] value for this extended data element. The method is only valid 
     * if the extended data element is a short[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return short[]
     */
    short[] getShortArray();


    /**
     * Get the int[] value for this extended data element. The method is only valid 
     * if the extended data element is a int[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return int[]
     */
    int[] getIntArray();


    /**
     * Get the long[] value for this extended data element. The method is only valid 
     * if the extended data element is a long[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return long[]
     */
    long[] getLongArray();


    /** 
     * Get the float[] value for this extended data element. The method is only valid 
     * if the extended data element is a float[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return float[]
     */
    float[] getFloatArray();


    /**
     * Get the double[] value for this extended data element. The method is only valid 
     * if the extended data element is a double[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return double[]
     */
    double[] getDoubleArray();
        
    /**
     * Get the hexBinary value for this extended data element. The method is only valid 
     * if the extended data element is a hexBinary. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @return byte[]
     */
    public byte[] getHexBinary();
    
    
    /**
     * Set the string value for this extended data element. The method is only valid 
     * if the extended data element is a string. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */    
    public void setString(String value);

    /**
     * Set the long value for this extended data element. The method is only valid 
     * if the extended data element is a dateTime. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setDateTime(long value);

    /**
     * Set the dateTime value for this extended data element. The method is only valid 
     * if the extended data element is a dateTime. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set* @param String the value to set
     */   
    public void setDateTime(String value);

    /**
     * Set the boolean value for this extended data element. The method is only valid 
     * if the extended data element is a boolean. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setBoolean(boolean value);

    /**
     * Set the byte value for this extended data element. The method is only valid 
     * if the extended data element is a byte. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setByte(byte value);

    /**
     * Set the short value for this extended data element. The method is only valid 
     * if the extended data element is a short. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setShort(short value);

    /**
     * Set the int value for this extended data element. The method is only valid 
     * if the extended data element is a int. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setInt(int value);

    /**
     * Set the long value for this extended data element. The method is only valid 
     * if the extended data element is a long. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setLong(long value);

    /**
     * Set the float value for this extended data element. The method is only valid 
     * if the extended data element is a float. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setFloat(float value);

    /**
     * Set the double value for this extended data element. The method is only valid 
     * if the extended data element is a double. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setDouble(double value);

    /**
     * Set the String[] value for this extended data element. The method is only valid 
     * if the extended data element is a String[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setStringArray(String[] values);

    /**
     * Set the long[] value for this extended data element. The method is only valid 
     * if the extended data element is a dateTime[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setDateTimeArray(long[] values);
    
    /**
     * Set the dateTime value for this extended data element. The method is only valid 
     * if the extended data element is a dateTime[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to sett
     */   
    public void setDateTimeArray(String[] values);

    /**
     * Set the boolean[] value for this extended data element. The method is only valid 
     * if the extended data element is a boolean[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setBooleanArray(boolean[] values);

    /**
     * Set the byte[] value for this extended data element. The method is only valid 
     * if the extended data element is a byte[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setByteArray(byte[] values);

    /**
     * Set the short[] value for this extended data element. The method is only valid 
     * if the extended data element is a short[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setShortArray(short[] values);

    /**
     * Set the int[] value for this extended data element. The method is only valid 
     * if the extended data element is a int[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setIntArray(int[] values);

    /**
     * Set the long[] value for this extended data element. The method is only valid 
     * if the extended data element is a long[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setLongArray(long[] values);

    /**
     * Set the float[] value for this extended data element. The method is only valid 
     * if the extended data element is a float[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setFloatArray(float[] values);

    /**
     * Set the double[] value for this extended data element. The method is only valid 
     * if the extended data element is a double[]. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setDoubleArray(double[] values);

    /**
     * Set the hexBinary value for this extended data element. The method is only valid 
     * if the extended data element is a hexBinary. Otherwise an exception is thrown.
     * 
     * @throws InvalidEventPropertyTypeException if the extended data element is a different data type.
     * 
     * @param value  the value to set
     */   
    public void setHexBinary(byte[] values);

}
