package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * This base class defines the interface for the SimpleEventFactory.
 * 
 * The SimpleEventFactory is a singleton as prescribed by the 
 * Abstract Factory pattern (Gamma et.al.).  It contains simple
 * constructors to build CommonBaseEvent and related complex 
 * type objects.
 * 
 * @author jgerken
 * @version 1.0
 */
public interface ISimpleEventFactory {

	/**
	 * Method IAssociationEngine.
	 * 
	 * Create and return a concrete AssociationEngine object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IAssociationEngine
	 */
	public IAssociationEngine createAssociationEngine();

	/**
	 * Method createCommonBaseEvent.
	 * 
	 * Create and return a concrete CommonBaseEvent object.
	 * 
	 * @return ICommonBaseEvent
	 */
	public ICommonBaseEvent createCommonBaseEvent();

	/**
	 * Method createExtendedDataElement.
	 * 
	 * Create and return a concrete ExtendedDataElement object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IExtendedDataElement
	 */
	public IExtendedDataElement createExtendedDataElement();

	/**
	 * Method createAssociatedEvent.
	 * 
	 * Create and return a concrete AssociatedEvent object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IAssociatedEvent
	 */
	public IAssociatedEvent createAssociatedEvent();

	/**
	 * Method createContextDataElement.
	 * 
	 * Create and return a concrete ContextDataElement object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IContextDataElement
	 */
	public IContextDataElement createContextDataElement();

	/**
	 * Method createComponentIdentification.
	 * 
	 * Create and return a concrete ComponentIdentification object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IComponentIdentification
	 */
	public IComponentIdentification createComponentIdentification();

	/**
	 * Method createMsgDataElement.
	 * 
	 * Create and return a concrete MsgDataElement object.  Objects
	 * of this type are encapsulated into CommonBaseEvent objects.
	 * 
	 * @return IMsgDataElement
	 */
	public IMsgDataElement createMsgDataElement();
}