/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.editors;

import java.util.ArrayList;
import java.util.*;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jface.action.*;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
//import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.xml.sax.SAXParseException;

import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.models.internal.sdb.impl.*;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.*;

import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.part.EditorActionBarContributor;


public class SymptomDBEditor extends MultiPageEditorPart implements ResourceStateInputProvider, IResourceChangeListener, IResourceDeltaVisitor {

	IFile iFile;
	SymptomDBEditorOverviewPage overviewPage = null;
	SymptomDBEditorDetailsPage detailsPage = null;

	private RASWidgetFactory factory = new RASWidgetFactory();

	private SDBRuntime fDatabase;
	private boolean dirtyUI = false;
	private boolean dirtyModel = false;
	private final String NL = System.getProperties().getProperty("line.separator");
	private List resources;
	private ValidateSymptomDBEditListener validateEditListener;

	private long cachedTimestamp;
	private ArrayList mofResources = new ArrayList(0);
	private boolean changed = false;
	private Display display;
	
	public SymptomDBEditor() {
		super();
	}
	private RASWidgetFactory getWidgetFactory() {
		
		return factory;
	}
	public void init(IEditorSite site, IEditorInput input)
		throws PartInitException {
		super.init(site, input);
		if (input instanceof IFileEditorInput) {
			iFile = ((IFileEditorInput) input).getFile();
			setTitle(iFile.getName());
		}
		ResourcesPlugin.getWorkspace().addResourceChangeListener(this);
		cachedTimestamp = getFileTimestamp();
		display = Display.getCurrent();
		
	}
	public void createPages() {
		{
			// Overwiev Tab (ie. Name/URL/Location, etc)
			//ViewForm viewForm = new ViewForm(getContainer(), SWT.NULL);
			ScrolledComposite overviewForm = new ScrolledComposite(getContainer(), SWT.H_SCROLL | SWT.V_SCROLL);
			overviewForm.setExpandHorizontal(true);
			overviewForm.setExpandVertical(true);
			GridLayout layout = new GridLayout();			
			layout.numColumns = 1;
			overviewForm.setLayout(layout);

			overviewPage = new SymptomDBEditorOverviewPage(getWidgetFactory());

			overviewForm.setContent(overviewPage.getContent(overviewForm));
			
			//viewForm.setContent(overviewPage.getContent(viewForm));
			int pageIndex = addPage(overviewForm);
			setPageText(pageIndex, SDbPlugin.getResourceString("STR_OVERVIEW_LABEL"));

			WorkbenchHelp.setHelp(overviewForm, ContextIds.SYMDB_EDITOR_PAGE_OVERVIEW);
		}

		{
			// Details Tab
			//ViewForm viewForm = new ViewForm(getContainer(), SWT.NULL);
			ScrolledComposite viewForm = new ScrolledComposite(getContainer(), SWT.H_SCROLL | SWT.V_SCROLL);
			viewForm.setExpandHorizontal(true);
			viewForm.setExpandVertical(true);

			GridLayout layout = new GridLayout();
			layout.numColumns = 1;
			viewForm.setLayout(layout);
			
			detailsPage = new SymptomDBEditorDetailsPage(getWidgetFactory());
			
			viewForm.setContent(detailsPage.getContent(viewForm));
			org.eclipse.swt.graphics.Point p = detailsPage.getContent().computeSize(SWT.DEFAULT, SWT.DEFAULT);
			viewForm.setMinWidth(p.x);
			viewForm.setMinHeight(p.y);
			
			int pageIndex = addPage(viewForm);
			setPageText(pageIndex, SDbPlugin.getResourceString("STR_DETAILS_LABEL"));

			WorkbenchHelp.setHelp(viewForm, ContextIds.SYMDB_EDITOR_PAGE_DETAILS);
		}
		
		overviewPage.init(this);
		if(getSearchDialog()!=null){
			getSearchDialog().setTarget(detailsPage);
			getSearchDialog().enableButton(false);			
		}
	}
	protected void pageChange(int newPageIndex) {
		if (newPageIndex == 1) {

			if (fDatabase == null) {

				org
					.eclipse
					.swt
					.custom
					.BusyIndicator
					.showWhile(getContainer().getDisplay(), new Runnable() {
					public void run() {
						try {
							loadModel();
						} catch (Exception e) {
							String errMsg = SDbPlugin.getResourceString("STR_LOAD_MODEL_ERROR_");
							MessageDialog.openError(
								getContainer().getShell(),
								SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"),
								errMsg);

							e.printStackTrace();
							return;
						}
					}
				});
				
				
				validateEditListener = new ValidateSymptomDBEditListener(this, new ResourceStateValidatorImpl(this));
				setViewerInput();
			}
			setGlobalFindActionHandler(detailsPage.getFindAction());
			
			if(getSearchDialog()!=null){
				getSearchDialog().enableButton(true);
			}
			
		}
		else{
			setGlobalFindActionHandler(null);
		}
		
		if(newPageIndex == 0){
			overviewPage.init(this);

			if(getSearchDialog()!=null){
				getSearchDialog().enableButton(false);
			}
			
		}
		
	}
	public void doSave(IProgressMonitor monitor) {
		try {
			if (isModelDirty())
				if (!detailsPage.updateCurrentSelection(detailsPage.getCurrentSelection()))
					return;
			if(validateEditListener.checkSave()){
				changed = true;
				
				validateModel();
		        Map options = new HashMap();		
		        options.put(XMIResource.OPTION_DECLARE_XML, Boolean.TRUE);
		        fDatabase.eResource().save(options);

				changed = false;
				cachedTimestamp =  getFileTimestamp();
				updateUIDirtyStatus(false);				
			}
			
		} catch (Exception e) {
			e.printStackTrace();
			String message = SDbPlugin.getResourceString("STR_SAVE_SYMPTOMDB_ERROR_");
			message = TString.change(message, "%1", fDatabase.getName());
			MessageDialog.openError(
				getContainer().getShell(),
				SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"),
				message);
		}

	}
	public boolean isSaveAsAllowed() {
		return false;
	}
	public void doSaveAs() {
	}
	public void gotoMarker(IMarker marker) {
	}
	public boolean isDirtyUI() {
		return dirtyUI;
	}
	public void updateUIDirtyStatus(boolean newVal) {
		dirtyUI = newVal;		
		firePropertyChange(IEditorPart.PROP_DIRTY);
		//validateEditListener.validateState();		
	}
	public boolean validateState(Widget widget, Listener listener, String oldValue){
		boolean result = validateEditListener.validateState().isOK();
		if(!result && widget!=null){
				widget.removeListener(SWT.Modify, listener);
				if(widget instanceof Text){				
					((Text)widget).setText(oldValue);
					widget.addListener(SWT.Modify, listener);				
				}
				else if(widget instanceof CCombo){
					((CCombo)widget).setText(oldValue);
					widget.addListener(SWT.Selection, listener);				
				}							
		}
		return result;
	}
	
	public boolean isModelDirty() {
		return dirtyModel;
	}
	public void updateModelDirtyStatus(boolean newVal) {
		dirtyModel = newVal;
	}

	public boolean isDirty() {
		return isDirtyUI();
	}
	/*public void updateDirtyStatus() {
	    firePropertyChange(IEditorPart.PROP_DIRTY);
	}*/
	public void dispose() {
		factory.dispose();
		/*if(isDirty())
			fDatabase.refResource().getResourceSet().remove(fDatabase.refResource());*/
			
//opensrc
/*			
		if (fDatabase != null)
			 ((ReferencedXMIResourceImpl) fDatabase.eResource()).releaseFromWrite();
*/
			 
		//setGlobalFindActionHandler(null);
		iFile.getWorkspace().removeResourceChangeListener(this);		
		super.dispose();
	}
	public void setFocus() {
		getControl(getActivePage()).setFocus();
	}
	public IFile getFile() {
		return iFile;
	}
	public SDBRuntime getModel() {
		return fDatabase;
	}
	public void loadModel() {
		if (fDatabase != null || iFile == null)
			return; //load only once

		try {
			
			ResourceSet resourceSet = new SDBResourceSetImpl();
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", new SDBResourceFactoryImpl());
			Resource res = resourceSet.getResource(URI.createURI("platform:/resource" + iFile.getFullPath().toString()), true);

			Iterator i = res.getContents().iterator();
			while (i.hasNext()) {
				Object obj = i.next();
				if (obj instanceof SDBRuntime) {
					fDatabase = (SDBRuntime) obj;

					EList sol = fDatabase.getSolutions();
					for (int j = 0; j < sol.size(); j++) {
						SDBSolution item = (SDBSolution) sol.get(j);
						item.setDescription(convertToPlatformNL(item.getDescription()));
					}

					EList dir = fDatabase.getDirectives();
					for (int j = 0; j < dir.size(); j++) {
						SDBDirective item = (SDBDirective) dir.get(j);
						item.setDirectiveString(convertToPlatformNL(item.getDirectiveString()));
					}
					
//opensrc					
//					((ReferencedXMIResourceImpl) fDatabase.eResource()).accessForWrite();
					return;
				}
			}
		} catch (Exception e) {
			
			String errMsg = SDbPlugin.getResourceString("STR_LOAD_XMI_ERROR_");
			if(e instanceof SAXParseException){
				Status error =
					new Status(
						Status.WARNING,
						ResourcesPlugin.PI_RESOURCES,
						IResourceStatus.INTERNAL_ERROR,
						SDbPlugin.getResourceString("STR_LOAD_XMI_EXC_REASON_"),
						e);
				ErrorDialog.openError(
					getContainer().getShell(),
					SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"),
					errMsg,
					error);
						
			}
			else{

				MessageDialog.openError(
					getContainer().getShell(),
					SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"),
					errMsg);
			}
									
			e.printStackTrace();

			return;
		}
	}

	public IStatusLineManager getStatusLineManager() {
			
		IEditorActionBarContributor contributor= getEditorSite().getActionBarContributor();
		if (contributor instanceof EditorActionBarContributor) {
			return ((EditorActionBarContributor) contributor).getActionBars().getStatusLineManager();
		}
		return null;
	}

	public boolean isSetGlobalFindActionHandler(){
		
		IAction action = null;
		IEditorActionBarContributor contributor = getEditorSite().getActionBarContributor();
		if(contributor!=null){
			IActionBars actionBars = ((EditorActionBarContributor)contributor).getActionBars();
			if(actionBars!=null)
				 action = actionBars.getGlobalActionHandler(IWorkbenchActionConstants.FIND);
		}

		return action instanceof SymptomDBEditorDetailsPage.FindAction;
	}

	public IAction getGlobalFindActionHandler(){
		return detailsPage.getFindAction();				
	}
	
	public SymptomDBSearchDialog getSearchDialog(){
		return detailsPage.getDialog();
	}
	// sets the global find action handler that overrides the default workbench handler
	//triggers on CTRL+F the search dialog to be opened
	public void setGlobalFindActionHandler(IAction action){

		if(action==null || getActivePage()==1){
			IEditorActionBarContributor contributor = getEditorSite().getActionBarContributor();
			if(contributor!=null){
				IActionBars actionBars = ((EditorActionBarContributor)contributor).getActionBars();
				if(actionBars!=null)
					actionBars.setGlobalActionHandler(IWorkbenchActionConstants.FIND, action);
					actionBars.updateActionBars();
			}
		}
	
	}
	// have to convert MOF new line char loaded by MOF with the system one
	// MOF uses "\n", but the UI (directive description text ox for ex.)
	//gets corrupted on Windows when adding new lines to the fields containing MOF new line chars
	//because of the existence of 2 different new line chars in the same widget 
	//("\r\n" and "\n")
	private String convertToPlatformNL(String input) {
		int i = 0;
		String output = input;
		String nl = "\r\n";
		
		if(NL.equals("\r\n"))
			nl = "\n";			
		else if (NL.equals("\n"))	
			nl = "\r\n";
		
		if(input.indexOf(nl)<0)
			return input;
			
		StringBuffer lines = new StringBuffer();

		i = 0;
		int j = 0;		
		if(NL.equals("\r\n")){
			while (i <= input.length()) {
		
				if ((j = input.indexOf(nl, i)) > -1) {
					
					if(j!=0 && input.charAt(j-1)== '\r')
						lines.append(input.substring(i, j-1) + NL);
					else	
						lines.append(input.substring(i, j) + NL);
				} else {
					lines.append(input.substring(i));
					break;
				}
				i = j + nl.length();
			}
		}else if(NL.equals("\n")){
			while (i <= input.length()) {
		
				if ((j = input.indexOf(nl, i)) > -1) {
					
					lines.append(input.substring(i, j) + NL);
						
				} else {
					lines.append(input.substring(i));
					break;
				}
				i = j + nl.length();
			}
		
		}
		
		
		output = lines.toString();

		return output;
	}
	
	/**
	 * Return a <code>List</code> of IFiles that are not MOF Resources that are
	 * also being modified.
	 * @return List
	 */
	public List getNonResourceFiles(){
		if (resources == null){
			resources = new ArrayList();
			resources.add(iFile);
		}
		return resources;		
	};
	
	public void resourceChanged(IResourceChangeEvent event){
		IResourceDelta delta = event.getDelta();
		IResourceDelta iFile_delta;
	    try
	    {
	      if (delta != null && (iFile_delta = delta.findMember(iFile.getFullPath()))!=null) 
	      {
			iFile_delta.accept(this);
	      }
	    }
	    catch (Exception e)
	    {      
		   e.printStackTrace();
	    }      
	}
	
  	public boolean visit(IResourceDelta delta)
  	{
    	
		long currentTimestamp = getFileTimestamp();

  		if(delta.getKind()==IResourceDelta.CHANGED && 
  		   ((delta.getFlags() & IResourceDelta.CONTENT) != 0) && 
  		    cachedTimestamp!=currentTimestamp &&
  		    changed==false){
  			if(fDatabase==null){
				Display.getDefault().asyncExec(new Runnable(){
					public void run() {
						overviewPage.init(SymptomDBEditor.this);
					}
				});			
			}
			else{
				refreshEditor();												
			}
			
			cachedTimestamp = getFileTimestamp();
		}
  		if(delta.getKind()==IResourceDelta.REMOVED){
			closeEditor();
			
		}
		
		
  		return true;
  }
	
	private void setViewerInput(){
		Object[] root = new Object[] { fDatabase };
		detailsPage.getViewer().setInput(root);
		detailsPage.setTreeRoot(root);
		detailsPage.getViewer().setExpandedState(root[0], true);
		detailsPage.init(this);	
	}
	
	private void refreshEditor(){

				if(Thread.currentThread()==display.getThread()){
					org
					.eclipse
					.swt
					.custom
					.BusyIndicator
					.showWhile(getContainer().getDisplay(), new Runnable() {
					public void run() {
						try {														
							
							//ResourceSet resourceSet = RASPlugin.getDefault().getResourceSet();
							
							//resourceSet.getResources().remove(fDatabase.eResource());
							fDatabase = null;
							loadModel();
							setViewerInput();
							overviewPage.init(SymptomDBEditor.this);
							updateUIDirtyStatus(false);
							
						} catch (Exception e) {
							String errMsg = SDbPlugin.getResourceString("STR_LOAD_MODEL_ERROR_");
							MessageDialog.openError(
								getContainer().getShell(),
								SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"),
								errMsg);

							e.printStackTrace();
							return;
						}
					}
				});
				}
				else{
					fDatabase = null;
					loadModel();
					Display.getDefault().asyncExec(new Runnable(){
						public void run() {
							setViewerInput();
							overviewPage.init(SymptomDBEditor.this);							
							updateUIDirtyStatus(false);						
						}
					});
				}

	
	}	
	
	private void closeEditor(){
		
	Display.getDefault().asyncExec(new Runnable(){
		public void run() {
			getSite().getPage().closeEditor(SymptomDBEditor.this, false);
		}
	});

	}
	
	private long getFileTimestamp(){

		long currentTimestamp = 0;
		IPath path = iFile.getLocation();		
		if (path != null){
			currentTimestamp = path.toFile().lastModified();
		}
		
		return currentTimestamp;
	
	}
	public Control getControl(int i){
		return super.getControl(i);	
	}
	
	public EditorPage getPage(int option){

		EditorPage page = null;
		if(option==0){
			page = overviewPage;
		}else
			if(option==1){
				page = detailsPage;
			}	

		return page;
	}
	
	public int getActivePage(){
		return super.getActivePage();
	}
	
    /*
     * def227743; fix any dangling references before saving the model
     */
    private void validateModel()
    {
    	//resolve solution referenced by directives
    	Iterator directives = fDatabase.getDirectives().iterator();
    	while(directives.hasNext())
    	{
    		Iterator solutions = ((SDBDirective)directives.next()).getSolutions().iterator();
		   	while(solutions.hasNext())
    		{
    			SDBSolution sol = (SDBSolution) solutions.next();
    			if(sol.eContainer() == null)
    			{
    				fDatabase.getSolutions().add(sol);
    			}   
    		}
    	}
    	
    	//resolve solutions referenced by symptoms
    	Iterator symptoms = fDatabase.getSymptoms().iterator();
    	while(symptoms.hasNext())
    	{
    		Iterator solutions = ((SDBSymptom)symptoms.next()).getSolutions().iterator();
		   	while(solutions.hasNext())
    		{
    			SDBSolution sol = (SDBSolution) solutions.next();
    			if(sol.eContainer() == null)
    			{
    				fDatabase.getSolutions().add(sol);
    			}   
    		}    		
    	}
    	
    	//resolve symptoms and directive referenced by solutions
    	Iterator solutions = fDatabase.getSolutions().iterator();
    	while(solutions.hasNext())
    	{
    		SDBSolution sol = (SDBSolution)solutions.next();
    		Iterator ssymptoms = sol.getSymptoms().iterator();
		   	while(ssymptoms.hasNext())
    		{
    			SDBSymptom sym = (SDBSymptom) ssymptoms.next();
    			if(sym.eContainer() == null)
    			{
    				fDatabase.getSymptoms().add(sym);
    			}   
    		}    		
    		
    		Iterator sdirectives = sol.getDirectives().iterator();
		   	while(sdirectives.hasNext())
    		{
    			SDBDirective dir = (SDBDirective) sdirectives.next();
    			if(dir.eContainer() == null)
    			{
    				fDatabase.getDirectives().add(dir);
    			}   
    		}    		
    		
    	}
    }
}
