/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.util;

import org.eclipse.jface.viewers.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class SymptomDBLabelProvider extends LabelProvider
{
/**
 * Returns the image to display for the passed resource element.
 * NOTE: The resource label provider caches its images, so don't
 * dispose them!
 */
public Image getImage(Object element)
{
	if (element instanceof IAdaptable)
	{
		IWorkbenchAdapter adapter =
			(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

		return adapter == null ? null : adapter.getImageDescriptor(element).createImage();

	}
	return null;
}
/* (non-Javadoc)
 * Method declared on ILabelProvider.
 */
public String getText(Object element)
{
	if (element instanceof IFile)
	{
		IFile file = (IFile)element;
		
		return file.getName();
	}	
	else if (element instanceof IAdaptable)
	{
		IWorkbenchAdapter adapter =
			(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

		return adapter == null ? "?" : adapter.getLabel(element);
	}
	return "";
}
}
