/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import org.eclipse.hyades.security.SecurityPlugin;

public class ConnectivityUI
{
    private Shell fShell;
	private Text  fPassword;
	private Text  fUserId;
	private String fDescription = "";
    private boolean fSelectUserField=true;
	
	public ConnectivityUI(Shell shell){
        fShell = shell;
	}
	
	public void createContents(Composite c){ 

            GridData data;
			Composite nameGroup = new Composite(c, SWT.NONE);
			GridLayout layout = new GridLayout();
			layout.numColumns = 2;
			data = GridUtil.createFill();

			nameGroup.setLayoutData(data);
			nameGroup.setLayout(layout);

			Label label = new Label(nameGroup, SWT.WRAP);
			data = new GridData();
			data.horizontalSpan = 2;
			data.widthHint = 340;
			data.horizontalAlignment = GridData.FILL_HORIZONTAL;
			label.setLayoutData(data);
			String text = fDescription + "\n" + SecurityPlugin.getResourceString("STR_LOG_ON_DESC");
			label.setText(text);
			
			label = new Label(nameGroup, SWT.NONE);
			data = new GridData();
			data.horizontalSpan = 2;
			label.setLayoutData(data);
			
			Label userLabel = new Label(nameGroup, SWT.NONE);
			userLabel.setText(SecurityPlugin.getResourceString("STR_USER_NAME"));
			fUserId = new Text(nameGroup, SWT.BORDER);
			fUserId.setLayoutData(GridUtil.createHorizontalFill());
			
			Label pwdLabel = new Label(nameGroup, SWT.NONE);
			pwdLabel.setText(SecurityPlugin.getResourceString("STR_PASSWORD"));
			fPassword = new Text(nameGroup, SWT.BORDER);				
			fPassword.setLayoutData(GridUtil.createHorizontalFill());
			fPassword.setEchoChar('*');			
	}

    public Text getUserIdComponent()
    {
    	return fUserId;
    }
    
    public String getUserId()
    {
    	return fUserId.getText().trim();
    }
    
    public void setUserId(String userId)
    {
    	if(userId != null)
	    	fUserId.setText(userId);
	    					
		if(fSelectUserField)
		{
			fUserId.setFocus();
			fUserId.selectAll();	    	
		}
		else
		{
			fPassword.setFocus();
			fPassword.selectAll();
		}
    }
    
    public Text getPasswordComponent()
    {
    	return fPassword;
    }
    
    public String getPassword()
    {
    	return fPassword.getText().trim();
    }
    
    public void setPassword(String password)
    {
    	if(password != null)
	    	fPassword.setText(password);
	    	
		if(fSelectUserField)
		{
			fUserId.setFocus();
			fUserId.selectAll();	    	
		}
		else
		{
			fPassword.setFocus();
			fPassword.selectAll();			
		}
	    	
    }

    public void setDescription(String desc)
    {
    	fDescription = desc;
    }
    
    public void setUserSelection(boolean sel)
    {
    	fSelectUserField = sel;
    }
}
