package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.ArrayList;
import java.util.Iterator;

/**
 * @author rduggan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class AssociatedEventImpl implements IAssociatedEvent {

    /**
     * The associations elements with the other artifacts.
     */
    protected ArrayList resolvedEvents = new ArrayList();

    protected IAssociationEngine associationEngine;

    /**
     * Constructor for AssociatedEventImpl.
     */
    protected AssociatedEventImpl() {
	super();
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociatedEvent#addResolvedEvent(ICommonBaseEvent)
     */
    public void addResolvedEvent(String globalInstanceId) {
        this.resolvedEvents.add(globalInstanceId);
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociatedEvent#getResolvedEvents(ICommonBaseEvent)
     */
    public String[] getResolvedEvents() {
    	synchronized(resolvedEvents) {
    		String[] result=new String[resolvedEvents.size()];
    		Iterator iter=resolvedEvents.iterator();
    		for(int i=0; iter.hasNext(); i++) {
    			result[i]=(String)iter.next();
    		}
    		return result;
    	}
    }

    public void clearResolvedEvents() {
        resolvedEvents.clear();
    }

    public void setAssociationEngine(IAssociationEngine associationEngine) {
        this.associationEngine = associationEngine;
    };

    public IAssociationEngine getAssociationEngine() {
        return associationEngine;
    }
    
	/**
		 * Determines is two different objects are equal.
		 */
		public boolean equals(Object obj)
		{
			boolean result = false;

			//It's the same object reference, so it HAS to be equal
			if(this == obj)
			{
				result = true;
			}
			else
			{
				//If the object is null or is not the correct type of object, it can't be
				//equal
				if((obj != null) && (obj instanceof AssociatedEventImpl) && 
				   (getClass() == obj.getClass()))
				{
					AssociatedEventImpl associatedEvent = (AssociatedEventImpl) obj;

					Object              property1;
					Object              property2;

					property1 = getAssociationEngine();
					property2 = associatedEvent.getAssociationEngine();

					if(((property1 != null) && (property1.equals(property2))) || 
					   ((property1 == null) && (property2 == null)))
					{
						if(((resolvedEvents != null) && 
							   (resolvedEvents.equals(associatedEvent.resolvedEvents))) || 
						   ((resolvedEvents == null) && 
							   (associatedEvent.resolvedEvents == null)))
						{
							result = true;
						}
					}
				}
			}

			return result;
		}
}
