package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.core.ISerializableAsXml;

/**
 * @author paules
 * @version 1.0
 */
public class AssociationEngineImpl implements IAssociationEngine, ISerializableAsXml {

    /**
     * Fields.
     */
    protected String id;
    protected String name;
    protected String type;

    protected AssociationEngineImpl() {
        id = new Guid().toString();
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociatedEvent#getId()
     */
    public String getId() {
        return id;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociatedEvent#getName()
     */
    public String getName() {
        return name;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociatedEvent#getType()
     */
    public String getType() {
        return type;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociatedEvent#setId(String)
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociatedEvent#setName(String)
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociatedEvent#setType(String)
     */
    public void setType(String type) {
        this.type = type;
    }

	/**
	 * @see org.eclipse.hyades.logging.core.IExternalizableToXml#externalizeCanonicalXmlString()
	 */
	public String externalizeCanonicalXmlString() {
		return CbeFormatter.toCanonicalXMLString(this);
	}

	/**
	 * @see org.eclipse.hyades.logging.core.IExternalizableToXml#externalizeCanonicalXmlDocString()
	 */
	public String externalizeCanonicalXmlDocString() {
		return CbeFormatter.toCanonicalXMLDocString(this);
	}

	/**
	 * @see org.eclipse.hyades.logging.core.IInternalizableFromXml#internalizeCanonicalXmlString(java.lang.String)
	 */
	public void internalizeCanonicalXmlString(String value) {
		CbeFormatter.fromCanonicalXMLString(this, value);
		return; 
	}

	/**
	 * @see org.eclipse.hyades.logging.core.IInternalizableFromXml#internalizeCanonicalXmlDocString(java.lang.String)
	 */
	public void internalizeCanonicalXmlDocString(String value) {
		CbeFormatter.fromCanonicalXMLDocString(this, value);
		return; 
	}
    
	/**
	 * Determines is two different objects are equal.
	 */
	public boolean equals(Object obj)
	{
		boolean result = false;

		//It's the same object reference, so it HAS to be equal
		if(this == obj)
		{
			result = true;
		}
		else
		{
			//If the object is null or is not the correct type of object, it can't be
			//equal
			if((obj != null) && (obj instanceof AssociationEngineImpl) && 
			   (getClass() == obj.getClass()))
			{
				AssociationEngineImpl associationEngine = (AssociationEngineImpl) obj;

				Object             property1;
				Object             property2;

				property1 = getId();
				property2 = associationEngine.getId();

				if(((property1 != null) && (property1.equals(property2))) || 
				   ((property1 == null) && (property2 == null)))
				{
					property1 = getType();
					property2 = associationEngine.getType();

					if(((property1 != null) && (property1.equals(property2))) || 
					   ((property1 == null) && (property2 == null)))
					{
						property1 = getName();
						property2 = associationEngine.getName();

						if(((property1 != null) && (property1.equals(property2))) || 
						   ((property1 == null) && (property2 == null)))
						{
							result = true;
						}
					}
				}
			}
		}

		return result;
	} 

}
