package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * @author rduggan
 *
 *
 */
public class ComponentIdentificationImpl implements IComponentIdentification {

    /**
     * Fields.
     */
    protected String location;
    protected String locationType;
    protected String application;
    protected String executionEnvironment;
    protected String component;
    protected String subComponent;
    protected String componentIdType;
    protected String instanceId;
    protected String processId;
    protected String threadId;


    /**
     * Constructor for ComponentIdentificationImpl.
     */
     protected ComponentIdentificationImpl() {
	super();
     }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getApplication()
     */
    public String getApplication() {
        return application;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getComponent()
     */
    public String getComponent() {
        return component;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getExecutionEnvironment()
     */
    public String getExecutionEnvironment() {
        return executionEnvironment;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getInstanceId()
     */
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getLocation()
     */
    public String getLocation() {
        return location;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getLocationType()
     */
    public String getLocationType() {
        return locationType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getProcessId()
     */
    public String getProcessId() {
        return processId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getSubComponent()
     */
    public String getSubComponent() {
        return subComponent;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getThreadId()
     */
    public String getThreadId() {
        return threadId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setApplication(String)
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setComponent(String)
     */
    public void setComponent(String component) {
        this.component = component;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setExecutionEnvironment(String)
     */
    public void setExecutionEnvironment(String executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setInstanceId(String)
     */
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setLocation(String)
     */
    public void setLocation(String location) {
        this.location = location;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setLocationType(String)
     */
    public void setLocationType(String locationType) {
        this.locationType = locationType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setProcessId(String)
     */
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setSubComponent(String)
     */
    public void setSubComponent(String subComponent) {
        this.subComponent = subComponent;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setThreadId(String)
     */
    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getComponentIdType()
     */
    public String getComponentIdType() {
        return componentIdType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setComponentIdType(String)
     */
    public void setComponentIdType(String componentIdType) {
        this.componentIdType = componentIdType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#init()
     */
    public void init() {
        location = null;
        locationType = null;
        application = null;
        executionEnvironment = null;
        component = null;
        subComponent = null;
        componentIdType = null;
        instanceId = null;
        processId = null;
        threadId = null;
    }
    
	/**
	 * Determines is two different objects are equal.
	 */
	public boolean equals(Object obj)
	{
		boolean result = false;

		//It's the same object reference, so it HAS to be equal
		if(this == obj)
		{
			result = true;
		}
		else
		{
			//If the object is null or is not the correct type of object, it can't be
			//equal
			if((obj != null) && (obj instanceof ComponentIdentificationImpl) && 
			   (getClass() == obj.getClass()))
			{
				ComponentIdentificationImpl componentIdentification = 
						(ComponentIdentificationImpl) obj;

				Object                   property1;
				Object                   property2;

				property1 = getLocation();
				property2 = componentIdentification.getLocation();

				if(((property1 != null) && (property1.equals(property2))) || 
				   ((property1 == null) && (property2 == null)))
				{
					property1 = getLocationType();
					property2 = componentIdentification.getLocationType();

					if(((property1 != null) && (property1.equals(property2))) || 
					   ((property1 == null) && (property2 == null)))
					{
						property1 = getApplication();
						property2 = componentIdentification.getApplication();

						if(((property1 != null) && (property1.equals(property2))) || 
						   ((property1 == null) && (property2 == null)))
						{
							property1 = getExecutionEnvironment();
							property2 = componentIdentification.getExecutionEnvironment();

							if(((property1 != null) && (property1.equals(property2))) || 
							   ((property1 == null) && (property2 == null)))
							{
								property1 = getComponent();
								property2 = componentIdentification.getComponent();

								if(((property1 != null) && 
									   (property1.equals(property2))) || 
								   ((property1 == null) && (property2 == null)))
								{
									property1 = getSubComponent();
									property2 = componentIdentification.getSubComponent();

									if(((property1 != null) && 
										   (property1.equals(property2))) || 
									   ((property1 == null) && (property2 == null)))
									{
										property1 = getComponentIdType();
										property2 = componentIdentification.getComponentIdType();

										if(((property1 != null) && 
											   (property1.equals(property2))) || 
										   ((property1 == null) && 
											   (property2 == null)))
										{
											property1 = getInstanceId();
											property2 = componentIdentification.getInstanceId();

											if(((property1 != null) && 
												   (property1.equals(property2))) || 
											   ((property1 == null) && 
												   (property2 == null)))
											{
												property1 = getProcessId();
												property2 = componentIdentification.getProcessId();

												if(((property1 != null) && 
													   (property1.equals(property2))) || 
												   ((property1 == null) && 
													   (property2 == null)))
												{
													property1 = getThreadId();
													property2 = componentIdentification.getThreadId();

													if(((property1 != null) && 
														   (property1.equals(property2))) || 
													   ((property1 == null) && 
														   (property2 == null)))
													{
														result = true;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		return result;
	} 

}
