package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * @author rduggan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class ContextDataElementImpl implements IContextDataElement {

    /**
     * Fields.
     */
    protected String contextId;
    protected String type;
    protected String name;
    protected String contextValue;

    /**
     * Constructor for ContextDataElementImpl.
     */
     protected ContextDataElementImpl() {
	super();
     }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#getContextId()
     */
    public String getContextId() {
        return contextId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#getContextValue()
     */
    public String getContextValue() {
        return contextValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#getName()
     */
    public String getName() {
        return name;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#getType()
     */
    public String getType() {
        return type;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#setContextId(String)
     */
    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#setContextValue(String)
     */
    public void setContextValue(String contextValue) {
        this.contextValue = contextValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#setName(String)
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IContextDataElement#setType(String)
     */
    public void setType(String type) {
        this.type = type;
    }
    
        /**
     * Determines is two different objects are equal.
     */
    public boolean equals(Object obj)
    {
        boolean result = false;

        //It's the same object reference, so it HAS to be equal
        if(this == obj)
        {
            result = true;
        }
        else
        {
            //If the object is null or is not the correct type of object, it can't be
            //equal
            if((obj != null) && (obj instanceof ContextDataElementImpl) && 
               (getClass() == obj.getClass()))
            {
                ContextDataElementImpl contextDataElement = (ContextDataElementImpl) obj;

                Object              property1;
                Object              property2;

                property1 = getContextId();
                property2 = contextDataElement.getContextId();

                if(((property1 != null) && (property1.equals(property2))) || 
                   ((property1 == null) && (property2 == null)))
                {
                    property1 = getType();
                    property2 = contextDataElement.getType();

                    if(((property1 != null) && (property1.equals(property2))) || 
                       ((property1 == null) && (property2 == null)))
                    {
                        property1 = getName();
                        property2 = contextDataElement.getName();

                        if(((property1 != null) && (property1.equals(property2))) || 
                           ((property1 == null) && (property2 == null)))
                        {
                            property1 = getContextValue();
                            property2 = contextDataElement.getContextValue();

                            if(((property1 != null) && (property1.equals(property2))) || 
                               ((property1 == null) && (property2 == null)))
                            {
                                result = true;
                            }
                        }
                    }
                }
            }
        }

        return result;
    }
}
