package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.HashMap;

import org.eclipse.hyades.logging.events.exceptions.InvalidExtendedDataElementTypeException;

/**
 * @author rduggan
 * @author jcornpropst
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class ExtendedDataElementImpl implements IExtendedDataElement {

    /**
     * The associations elements with the other artifacts.
     */
    private HashMap children = new HashMap();

    /**
     * Fields.
     */
    private String name;
    private byte type = -1;
    private String id;
    
    /**
     * Holder for for data of this event property if the event property is
     * not an array
     */
    private String stringValue = null;

    /**
     */
    private long longValue = 0;

    /**
     */
    private double doubleValue = 0;

    /**
     */
    private boolean booleanValue = false;

    /**
     */
    private String[] stringArrayValue = null;

    /**
     */
    private byte[] byteArrayValue = null;

    /**
     */
    private short[] shortArrayValue = null;

    /**
     */
    private int[] intArrayValue = null;

    /**
     */
    private long[] longArrayValue = null;

    /**
     */
    private float[] floatArrayValue = null;

    /**
     */
    private double[] doubleArrayValue = null;

    /**
     */
    private boolean[] booleanArrayValue = null;
    
    //~ Constructors .....................................................................
    /**
     * 
     */
    protected ExtendedDataElementImpl() {
    }

    //~ Methods ..........................................................................
    

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#addChildDataElement(IExtendedDataElement)
     */
    public void addChildDataElement(IExtendedDataElement element) {
        this.children.put(element.getName(), element);
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getChildDataElements()
     */
    public Object[] getChildDataElements() {
        return children.values().toArray();
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#removeChildDataElement(String)
     */
    public void removeChildDataElement(String name) {
        this.children.remove(name);
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#clearChildDataElements()
     */
    public void clearChildDataElements() {
        this.children.clear();
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getValues()
     */
    public String[] getValues()
    {
        int arraySize;
        String[] values = null;

        switch (type)
        {
            case BYTE_DATA_TYPE :
            case SHORT_DATA_TYPE :
            case INTEGER_DATA_TYPE :
            case LONG_DATA_TYPE :
                values = new String[1];
                values[0] = Long.toString(longValue);

                break;

            case BOOLEAN_DATA_TYPE :
                values = new String[1];
                values[0] = new Boolean(booleanValue).toString();

                break;

            case FLOAT_DATA_TYPE :
            case DOUBLE_DATA_TYPE :
                values = new String[1];
                values[0] = Double.toString(doubleValue);

                break;

            case STRING_DATA_TYPE :
                values = new String[1];
                values[0] = stringValue;

                break;

            case DATETIME_DATA_TYPE :
                values = new String[1];
                values[0] = getDateTime();
                break;

            case BYTE_ARRAY_DATA_TYPE :
            case HEXBINARY_DATA_TYPE :
                arraySize = byteArrayValue.length;
                values = new String[arraySize];

                for (int i = 0; i < arraySize; i++)
                {
                    values[i] = Byte.toString(byteArrayValue[i]);
                }

                break;

            case BOOLEAN_ARRAY_DATA_TYPE :
                arraySize = booleanArrayValue.length;
                values = new String[arraySize];

                for (int i = 0; i < arraySize; i++)
                {
                    values[i] = new Boolean(booleanArrayValue[i]).toString();
                }

                break;

            case SHORT_ARRAY_DATA_TYPE :
                arraySize = shortArrayValue.length;
                values = new String[arraySize];

                for (int i = 0; i < arraySize; i++)
                {
                    values[i] = Short.toString(shortArrayValue[i]);
                }

                break;

            case INTEGER_ARRAY_DATA_TYPE :
                arraySize = intArrayValue.length;
                values = new String[arraySize];

                for (int i = 0; i < arraySize; i++)
                {
                    values[i] = Integer.toString(intArrayValue[i]);
                }

                break;

            case LONG_ARRAY_DATA_TYPE :
                arraySize = longArrayValue.length;
                values = new String[arraySize];

                for (int i = 0; i < arraySize; i++)
                {
                    values[i] = Long.toString(longArrayValue[i]);
                }

                break;

            case FLOAT_ARRAY_DATA_TYPE :
                arraySize = floatArrayValue.length;
                values = new String[arraySize];

                for (int i = 0; i < arraySize; i++)
                {
                    values[i] = Float.toString(floatArrayValue[i]);
                }

                break;

            case DOUBLE_ARRAY_DATA_TYPE :
                arraySize = doubleArrayValue.length;
                values = new String[arraySize];

                for (int i = 0; i < arraySize; i++)
                {
                    values[i] = Double.toString(doubleArrayValue[i]);
                }

                break;

            case STRING_ARRAY_DATA_TYPE :
                values = stringArrayValue;

                break;

            case DATETIME_ARRAY_DATA_TYPE :
                values = this.getDateTimeArray();

                break;

            default :
                }

        return values;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getHexValue()
     */
    public byte[] getHexValue()
    {
        return getHexBinary();
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getId()
     */
    public String getId()
    {
        return id;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getName()
     */
    public String getName()
    {
        return name;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getTypeValue()
     */
    public byte getTypeValue()
    {
        return type;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getType()
     */
    public String getType()
    {
        String dataType = null;

        switch (type)
        {
            case BYTE_DATA_TYPE :
                dataType = BYTE;

                break;

            case SHORT_DATA_TYPE :
                dataType = SHORT;

                break;

            case INTEGER_DATA_TYPE :
                dataType = INTEGER;

                break;

            case LONG_DATA_TYPE :
                dataType = LONG;

                break;

            case BOOLEAN_DATA_TYPE :
                dataType = BOOLEAN;

                break;

            case FLOAT_DATA_TYPE :
                dataType = FLOAT;

                break;

            case DOUBLE_DATA_TYPE :
                dataType = DOUBLE;

                break;

            case STRING_DATA_TYPE :
                dataType = STRING;

                break;

            case DATETIME_DATA_TYPE :
                dataType = DATETIME;

                break;

            case BYTE_ARRAY_DATA_TYPE :
                dataType = BYTE_ARRAY;

                break;

            case SHORT_ARRAY_DATA_TYPE :
                dataType = SHORT_ARRAY;

                break;

            case INTEGER_ARRAY_DATA_TYPE :
                dataType = INTEGER_ARRAY;

                break;

            case LONG_ARRAY_DATA_TYPE :
                dataType = LONG_ARRAY;

                break;

            case BOOLEAN_ARRAY_DATA_TYPE :
                dataType = BOOLEAN_ARRAY;

                break;

            case FLOAT_ARRAY_DATA_TYPE :
                dataType = FLOAT_ARRAY;

                break;

            case DOUBLE_ARRAY_DATA_TYPE :
                dataType = DOUBLE_ARRAY;

                break;

            case STRING_ARRAY_DATA_TYPE :
                dataType = STRING_ARRAY;

                break;

            case DATETIME_ARRAY_DATA_TYPE :
                dataType = DATETIME;

                break;

            case HEXBINARY_DATA_TYPE :
                dataType = HEXBINARY;

                break;

            default :
                dataType = null;
        }

        return dataType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setId(String)
     */
    public void setId(String id)
    {
        this.id = id;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setName(String)
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setType(byte)
     */
    public void setType(byte type)
    {
        if ((type >= 0) && (type <= HEXBINARY_DATA_TYPE))
        {
            this.type = type;
        }
        else
        {
            throw new InvalidExtendedDataElementTypeException(
                "setType was called with an invalid datatype value of  "
                    + type);
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setType(String)
     */
    public void setType(String type)
    {
        if (type.equals(BYTE))
        {
            this.type = BYTE_DATA_TYPE;
        }
        else if (type.equals(BOOLEAN))
        {
            this.type = BOOLEAN_DATA_TYPE;
        }
        else if (type.equals(SHORT))
        {
            this.type = SHORT_DATA_TYPE;
        }
        else if (type.equals(INTEGER))
        {
            this.type = INTEGER_DATA_TYPE;
        }
        else if (type.equals(LONG))
        {
            this.type = LONG_DATA_TYPE;
        }
        else if (type.equals(FLOAT))
        {
            this.type = FLOAT_DATA_TYPE;
        }
        else if (type.equals(DOUBLE))
        {
            this.type = DOUBLE_DATA_TYPE;
        }
        else if (type.equals(DATETIME))
        {
            this.type = DATETIME_DATA_TYPE;
        }
        else if (type.equals(STRING))
        {
            this.type = STRING_DATA_TYPE;
        }
        else if (type.equals(BYTE_ARRAY))
        {
            this.type = BYTE_ARRAY_DATA_TYPE;
        }
        else if (type.equals(BOOLEAN_ARRAY))
        {
            this.type = BOOLEAN_ARRAY_DATA_TYPE;
        }
        else if (type.equals(SHORT_ARRAY))
        {
            this.type = SHORT_ARRAY_DATA_TYPE;
        }
        else if (type.equals(INTEGER_ARRAY))
        {
            this.type = INTEGER_ARRAY_DATA_TYPE;
        }
        else if (type.equals(LONG_ARRAY))
        {
            this.type = LONG_ARRAY_DATA_TYPE;
        }
        else if (type.equals(FLOAT_ARRAY))
        {
            this.type = FLOAT_ARRAY_DATA_TYPE;
        }
        else if (type.equals(DOUBLE_ARRAY))
        {
            this.type = DOUBLE_ARRAY_DATA_TYPE;
        }
        else if (type.equals(DATETIME_ARRAY))
        {
            this.type = DATETIME_ARRAY_DATA_TYPE;
        }
        else if (type.equals(STRING_ARRAY))
        {
            this.type = STRING_ARRAY_DATA_TYPE;
        }
        else if (type.equals(HEXBINARY))
        {
            this.type = HEXBINARY_DATA_TYPE;
        }
        else
        {
            throw new InvalidExtendedDataElementTypeException(
                "setType was called with an invalid datatype value of  "
                    + type);
        }
    }

    /**
     * Sets the value.
     * @param value The value to set
     */
    public void setValues(String[] values)
    {
        int arraySize = values.length;
        clearValues();

        switch (type)
        {
            case BYTE_DATA_TYPE :

                if (arraySize > 1)
                {
                    throw new RuntimeException(
                        "Values contains more than one element for type"
                            + getType());
                }

                this.longValue = Byte.parseByte(values[0]);

                break;

            case SHORT_DATA_TYPE :

                if (arraySize > 1)
                {
                    throw new RuntimeException(
                        "Values contains more than one element for type"
                            + getType());
                }

                this.longValue = Short.parseShort(values[0]);

                break;

            case INTEGER_DATA_TYPE :

                if (arraySize > 1)
                {
                    throw new RuntimeException(
                        "Values contains more than one element for type"
                            + getType());
                }

                this.longValue = Integer.parseInt(values[0]);

                break;

            case LONG_DATA_TYPE :

                if (arraySize > 1)
                {
                    throw new RuntimeException(
                        "Values contains more than one element for type"
                            + getType());
                }

                this.longValue = Long.parseLong(values[0]);

                break;

            case BOOLEAN_DATA_TYPE :

                if (arraySize > 1)
                {
                    throw new RuntimeException(
                        "Values contains more than one element for type"
                            + getType());
                }

                this.booleanValue = new Boolean(values[0]).booleanValue();

                break;

            case FLOAT_DATA_TYPE :

                if (arraySize > 1)
                {
                    throw new RuntimeException(
                        "Values contains more than one element for type"
                            + getType());
                }

                this.doubleValue = Double.parseDouble(values[0]);

                break;

            case DOUBLE_DATA_TYPE :

                if (arraySize > 1)
                {
                    throw new RuntimeException(
                        "Values contains more than one element for type"
                            + getType());
                }

                this.doubleValue = Double.parseDouble(values[0]);

                break;

            case STRING_DATA_TYPE :

                if (arraySize > 1)
                {
                    throw new RuntimeException(
                        "Values contains more than one element for type"
                            + getType());
                }

                this.stringValue = values[0];

                break;

            case DATETIME_DATA_TYPE :

                if (arraySize > 1)
                {
                    throw new RuntimeException(
                        "Values contains more than one element for type"
                            + getType());
                }

                this.stringValue = values[0];

                break;

            case BYTE_ARRAY_DATA_TYPE :
                byteArrayValue = new byte[arraySize];
                for (int i = 0; i < arraySize; i++)
                {
                    this.byteArrayValue[i] = Byte.parseByte(values[i]);
                }

                break;

            case HEXBINARY_DATA_TYPE :
                byteArrayValue = new byte[arraySize];
                for (int i = 0; i < arraySize; i++)
                {
                    this.byteArrayValue[i] = Byte.parseByte(values[i]);
                }

                break;

            case SHORT_ARRAY_DATA_TYPE :
                shortArrayValue = new short[arraySize];
                for (int i = 0; i < arraySize; i++)
                {
                    this.shortArrayValue[i] = Short.parseShort(values[i]);
                }

                break;

            case INTEGER_ARRAY_DATA_TYPE :
                intArrayValue = new int[arraySize];
                for (int i = 0; i < arraySize; i++)
                {
                    this.intArrayValue[i] = Integer.parseInt(values[i]);
                }

                break;

            case LONG_ARRAY_DATA_TYPE :
                longArrayValue = new long[arraySize];
                for (int i = 0; i < arraySize; i++)
                {
                    this.longArrayValue[i] = Long.parseLong(values[i]);
                }

                break;

            case BOOLEAN_ARRAY_DATA_TYPE :
                booleanArrayValue = new boolean[arraySize];
                for (int i = 0; i < arraySize; i++)
                {
                    this.booleanArrayValue[i] = Boolean.getBoolean(values[i]);
                }

                break;

            case FLOAT_ARRAY_DATA_TYPE :
                floatArrayValue = new float[arraySize];
                for (int i = 0; i < arraySize; i++)
                {
                    this.floatArrayValue[i] = Float.parseFloat(values[i]);
                }

                break;

            case DOUBLE_ARRAY_DATA_TYPE :
                doubleArrayValue = new double[arraySize];
                for (int i = 0; i < arraySize; i++)
                {
                    this.doubleArrayValue[i] = Double.parseDouble(values[i]);
                }

                break;

            case STRING_ARRAY_DATA_TYPE :
                stringArrayValue = values;

                break;

            case DATETIME_ARRAY_DATA_TYPE :
                stringArrayValue = new String[arraySize];
                for (int i = 0; i < arraySize; i++)
                {
                    stringArrayValue[i] = values[i];
                }

                break;

            default :
                throw new RuntimeException(
                    "Values not set for type :" + getType());
        }
    }

    public void setHexValue(byte[] hexValue)
    {
        clearValues();
        this.byteArrayValue = hexValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getString()
     */
    public String getString()
    {
        if (type != STRING_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getString was called for an event property of type "
                    + getType());
        }

        return stringValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getDateTimeAsLong()
     */
    public long getDateTimeAsLong()
    {
        if (type != DATETIME_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getDateTimeAsLong was called for an event property of type "
                    + getType());
        }

        // check to see if we have the datetiem in long format
        // if change the datetime into long
        if (longValue == 0)
        {
            longValue =
                CbeFormatter.convertXmlSchemaDateTimeToDate(stringValue);
        }

        return longValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getDateTime()
     */
    public String getDateTime()
    {
        if (type != DATETIME_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getDateTime was called for an event property of type "
                    + getType());
        }

        // check to see if we have the datetiem in string format
        // if change the long into datetime
        if (stringValue == null)
        {
            stringValue =
                CbeFormatter.convertDateToXmlSchemaDateTime(longValue);
        }

        return stringValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getBoolean()
     */
    public boolean getBoolean()
    {
        if (type != BOOLEAN_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getBoolean was called for an event property of type "
                    + getType());
        }

        return booleanValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getByte()
     */
    public byte getByte()
    {
        if (type != BYTE_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getByte was called for an event property of type "
                    + getType());
        }

        return (byte) longValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getShort()
     */
    public short getShort()
    {
        if (type != SHORT_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getShort was called for an event property of type "
                    + getType());
        }

        return (short) longValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getInt()
     */
    public int getInt()
    {
        if (type != INTEGER_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getInt was called for an event property of type " + getType());
        }

        return (int) longValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getLong()
     */
    public long getLong()
    {
        if (type != LONG_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getLong was called for an event property of type "
                    + getType());
        }

        return longValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getFloat()
     */
    public float getFloat()
    {
        if (type != FLOAT_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getFloat was called for an event property of type "
                    + getType());
        }

        return (float) doubleValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getDouble()
     */
    public double getDouble()
    {
        if (type != DOUBLE_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getDouble was called for an event property of type "
                    + getType());
        }

        return doubleValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getStringArray()
     */
    public String[] getStringArray()
    {
        if (type != STRING_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getStringArray was called for an event property of type "
                    + getType());
        }

        return stringArrayValue;
    }


    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getDateTimeArrayAsLong()
     */
    public long[] getDateTimeArrayAsLong()
    {
        if (type != DATETIME_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getDateTimeArrayAsLong was called for an event property of type "
                    + getType());
        }

        if (longArrayValue == null)
        {
            int arrayLength = 0;

            if (stringArrayValue != null)
            {
                arrayLength = stringArrayValue.length;
            }

            longArrayValue = new long[arrayLength];

            for (int i = 0; i < arrayLength; i++)
            {
                longArrayValue[i] =
                    CbeFormatter.convertXmlSchemaDateTimeToDate(
                        stringArrayValue[i]);
            }
        }

        return longArrayValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getDateTimeArray()
     */
    public String[] getDateTimeArray()
    {
        if (type != DATETIME_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getDateTimeArray was called for an event property of type "
                    + getType());
        }

        if (stringArrayValue == null)
        {
            int arrayLength = 0;

            if (longArrayValue != null)
            {
                arrayLength = longArrayValue.length;
            }

            stringArrayValue = new String[arrayLength];

            for (int i = 0; i < arrayLength; i++)
            {
                stringArrayValue[i] =
                    CbeFormatter.convertDateToXmlSchemaDateTime(
                        longArrayValue[i]);
            }
        }

        return stringArrayValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getBooleanArray()
     */
    public boolean[] getBooleanArray()
    {
        if (type != BOOLEAN_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getBooleanArray was called for an event property of type "
                    + getType());
        }

        return booleanArrayValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getByteArray()
     */
    public byte[] getByteArray()
    {
        if (type != BYTE_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getByteArray was called for an event property of type "
                    + getType());
        }

        return byteArrayValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getShortArray()
     */
    public short[] getShortArray()
    {
        if (type != SHORT_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getShortArray was called for an event property of type "
                    + getType());
        }

        return shortArrayValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getIntArray()
     */
    public int[] getIntArray()
    {
        if (type != INTEGER_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getIntArray was called for an event property of type "
                    + getType());
        }

        return intArrayValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getLongArray()
     */
    public long[] getLongArray()
    {
        if (type != LONG_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getLongArray was called for an event property of type "
                    + getType());
        }

        return longArrayValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getFloatArray()
     */
    public float[] getFloatArray()
    {
        if (type != FLOAT_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getFloatArray was called for an event property of type "
                    + getType());
        }

        return floatArrayValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getDoubleArray()
     */
    public double[] getDoubleArray()
    {
        if (type != DOUBLE_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getDoubleArray was called for an event property of type "
                    + getType());
        }

        return doubleArrayValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#getHexBinary()
     */
    public byte[] getHexBinary()
    {
        if (type != HEXBINARY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "getHexBinary was called for an event property of type "
                    + getType());
        }

        return byteArrayValue;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setString()
     */
    public void setString(String value)
    {
        if (type != STRING_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setString was called for an event property of type "
                    + getType());
        }
        clearValues();
        stringValue = value;
    }
    
    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setDateTime()
     */
    public void setDateTime(long value)
    {
        if (type != DATETIME_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setDateTime was called for an event property of type "
                    + getType());
        }
        clearValues();
        longValue = value;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setDateTime()
     */
    public void setDateTime(String value)
    {
        if (type != DATETIME_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setDateTime was called for an event property of type "
                    + getType());
        }
        clearValues();
        stringValue = value;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setBoolean()
     */
    public void setBoolean(boolean value)
    {
        if (type != BOOLEAN_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setBoolean was called for an event property of type "
                    + getType());
        }
        clearValues();
        booleanValue = value;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setByte()
     */
    public void setByte(byte value)
    {
        if (type != BYTE_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setByte was called for an event property of type "
                    + getType());
        }
        clearValues();
        longValue = value;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setShort()
     */
    public void setShort(short value)
    {
        if (type != SHORT_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setShort was called for an event property of type "
                    + getType());
        }
        clearValues();
        longValue = value;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setInt()
     */
    public void setInt(int value)
    {
        if (type != INTEGER_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setInt was called for an event property of type " + getType());
        }
        clearValues();
        longValue = value;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setLong()
     */
    public void setLong(long value)
    {
        if (type != LONG_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setLong was called for an event property of type "
                    + getType());
        }
        clearValues();
        longValue = value;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setFloat()
     */
    public void setFloat(float value)
    {
        if (type != FLOAT_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setFloat was called for an event property of type "
                    + getType());
        }
        clearValues();
        doubleValue = value;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setDouble()
     */
    public void setDouble(double value)
    {
        if (type != DOUBLE_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setDouble was called for an event property of type "
                    + getType());
        }
        clearValues();
        doubleValue = value;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setStringArray()
     */
    public void setStringArray(String[] values)
    {
        if (type != STRING_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setStringArray was called for an event property of type "
                    + getType());
        }
        clearValues();
        stringArrayValue = values;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setDateTimeArray()
     */
    public void setDateTimeArray(long[] values)
    {
        if (type != DATETIME_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setDateTimeArray was called for an event property of type "
                    + getType());
        }
        clearValues();
        longArrayValue = values;

    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setDateTimeArray()
     */
    public void setDateTimeArray(String[] values)
    {
        if (type != DATETIME_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setDateTimeArray was called for an event property of type "
                    + getType());
        }
        clearValues();
        stringArrayValue = values;

    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setBooleanArray()
     */
    public void setBooleanArray(boolean[] values)
    {
        if (type != BOOLEAN_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setBooleanArray was called for an event property of type "
                    + getType());
        }
        clearValues();
        booleanArrayValue = values;

    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setByteArray()
     */
    public void setByteArray(byte[] values)
    {
        if (type != BYTE_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setByteArray was called for an event property of type "
                    + getType());
        }
        clearValues();
        byteArrayValue = values;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setShortArray()
     */
    public void setShortArray(short[] values)
    {
        if (type != SHORT_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setShortArray was called for an event property of type "
                    + getType());
        }
        clearValues();
        shortArrayValue = values;

    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setIntArray()
     */
    public void setIntArray(int[] values)
    {
        if (type != INTEGER_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setIntArray was called for an event property of type "
                    + getType());
        }
        clearValues();
        intArrayValue = values;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setLongArray()
     */
    public void setLongArray(long[] values)
    {
        if (type != LONG_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setLongArray was called for an event property of type "
                    + getType());
        }
        clearValues();
        longArrayValue = values;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setFloatArray()
     */
    public void setFloatArray(float[] values)
    {
        if (type != FLOAT_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setFloatArray was called for an event property of type "
                    + getType());
        }
        clearValues();
        floatArrayValue = values;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setDoubleArray()
     */
    public void setDoubleArray(double[] values)
    {
        if (type != DOUBLE_ARRAY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setDoubleArray was called for an event property of type "
                    + getType());
        }
        clearValues();
        doubleArrayValue = values;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#setHexBinary()
     */
    public void setHexBinary(byte[] values)
    {
        if (type != HEXBINARY_DATA_TYPE)
        {
            throw new InvalidExtendedDataElementTypeException(
                "setHexBinary was called for an event property of type "
                    + getType());
        }
        clearValues();
        byteArrayValue = values;

    }

    /**
     * @see org.eclipse.hyades.logging.events.IExtendedDataElement#clearValues()
     */
    public void clearValues()
    {
        stringValue = null;
        longValue = 0;
        doubleValue = 0;
        booleanValue = false;
        stringArrayValue = null;
        byteArrayValue = null;
        shortArrayValue = null;
        intArrayValue = null;
        longArrayValue = null;
        floatArrayValue = null;
        doubleArrayValue = null;
        booleanArrayValue = null;
    }
    
	/**
		 * Determines is two different objects are equal.
		 */
		public boolean equals(Object obj)
		{
			boolean result    = false;
			int     arraySize;

			//It's the same object reference, so it HAS to be equal
			if(this == obj)
			{
				result = true;
			}
			else
			{
				//If the object is null or is not the correct type of object, it can't be
				//equal
				if((obj != null) && (getClass() == obj.getClass()))
				{
					ExtendedDataElementImpl extendedDataElement = 
							(ExtendedDataElementImpl) obj;

					//Does the object represent the same data type?
					if(((getName() != null) && 
						   (getName().equals(extendedDataElement.getName())) || 
						   (getName() == null) && (extendedDataElement.getName() == null)) && 
					   (getTypeValue() == extendedDataElement.getTypeValue()))
					{
						if(((children != null) && 
							   (children.equals(extendedDataElement.children))) || 
						   ((children == null) && (extendedDataElement.children == null)))
						{
							try
							{
								switch(getTypeValue())
								{
									case BYTE_DATA_TYPE :

										if(getByte() == extendedDataElement.getByte())
										{
											result = true;
										}

										break;

									case SHORT_DATA_TYPE :

										if(getShort() == extendedDataElement.getShort())
										{
											result = true;
										}

										break;

									case INTEGER_DATA_TYPE :

										if(getInt() == extendedDataElement.getInt())
										{
											result = true;
										}

										break;

									case LONG_DATA_TYPE :

										if(getLong() == extendedDataElement.getLong())
										{
											result = true;
										}

										break;

									case BOOLEAN_DATA_TYPE :

										if(getBoolean() == extendedDataElement.getBoolean())
										{
											result = true;
										}

										break;

									case FLOAT_DATA_TYPE :

										if(getFloat() == extendedDataElement.getFloat())
										{
											result = true;
										}

										break;

									case DOUBLE_DATA_TYPE :

										if(getDouble() == extendedDataElement.getDouble())
										{
											result = true;
										}

										break;

									case STRING_DATA_TYPE :

										if(getString()
											   .equals(extendedDataElement.getString()))
										{
											result = true;
										}

										break;

									case DATETIME_DATA_TYPE :

										if(getDateTimeAsLong() == extendedDataElement.getDateTimeAsLong())
										{
											result = true;
										}

										break;

									case BYTE_ARRAY_DATA_TYPE :
									case HEXBINARY_DATA_TYPE :

										if(getByteArray().length == extendedDataElement.getByteArray().length)
										{
											arraySize = getByteArray().length;
											result    = true;

											for(int i = 0; i < arraySize; i++)
											{
												if(getByteArray()[i] != extendedDataElement.getByteArray()[i])
												{
													result = false;

													break;
												}
											}
										}

										break;

									case BOOLEAN_ARRAY_DATA_TYPE :

										if(getBooleanArray().length == extendedDataElement.getBooleanArray().length)
										{
											arraySize = getBooleanArray().length;
											result    = true;

											for(int i = 0; i < arraySize; i++)
											{
												if(getBooleanArray()[i] != extendedDataElement.getBooleanArray()[i])
												{
													result = false;

													break;
												}
											}
										}

										break;

									case SHORT_ARRAY_DATA_TYPE :

										if(getShortArray().length == extendedDataElement.getShortArray().length)
										{
											arraySize = getShortArray().length;
											result    = true;

											for(int i = 0; i < arraySize; i++)
											{
												if(getShortArray()[i] != extendedDataElement.getShortArray()[i])
												{
													result = false;

													break;
												}
											}
										}

										break;

									case INTEGER_ARRAY_DATA_TYPE :

										if(getIntArray().length == extendedDataElement.getIntArray().length)
										{
											arraySize = getIntArray().length;
											result    = true;

											for(int i = 0; i < arraySize; i++)
											{
												if(getIntArray()[i] != extendedDataElement.getIntArray()[i])
												{
													result = false;

													break;
												}
											}
										}

										break;

									case LONG_ARRAY_DATA_TYPE :

										if(getLongArray().length == extendedDataElement.getLongArray().length)
										{
											arraySize = getLongArray().length;
											result    = true;

											for(int i = 0; i < arraySize; i++)
											{
												if(getLongArray()[i] != extendedDataElement.getLongArray()[i])
												{
													result = false;

													break;
												}
											}
										}

										break;

									case FLOAT_ARRAY_DATA_TYPE :

										if(getFloatArray().length == extendedDataElement.getFloatArray().length)
										{
											arraySize = getFloatArray().length;
											result    = true;

											for(int i = 0; i < arraySize; i++)
											{
												if(getFloatArray()[i] != extendedDataElement.getFloatArray()[i])
												{
													result = false;

													break;
												}
											}
										}

										break;

									case DOUBLE_ARRAY_DATA_TYPE :

										if(getDoubleArray().length == extendedDataElement.getDoubleArray().length)
										{
											arraySize = getDoubleArray().length;
											result    = true;

											for(int i = 0; i < arraySize; i++)
											{
												if(getDoubleArray()[i] != extendedDataElement.getDoubleArray()[i])
												{
													result = false;

													break;
												}
											}
										}

										break;

									case STRING_ARRAY_DATA_TYPE :

										if(getStringArray().length == extendedDataElement.getStringArray().length)
										{
											arraySize = getStringArray().length;
											result    = true;

											for(int i = 0; i < arraySize; i++)
											{
												String value = getStringArray()[i];

												if((value == null) && 
												   (extendedDataElement.getStringArray()[i] != null))
												{
													result = false;

													break;
												}

												else if(!value.equals(
																 extendedDataElement.getStringArray()[i]))
												{
													result = false;

													break;
												}
											}
										}

										break;

									case DATETIME_ARRAY_DATA_TYPE :

										if(getDateTimeArrayAsLong().length == extendedDataElement.getDateTimeArrayAsLong().length)
										{
											arraySize = getDateTimeArrayAsLong().length;
											result    = true;

											for(int i = 0; i < arraySize; i++)
											{
												if(getDateTimeArrayAsLong()[i] != extendedDataElement.getDateTimeArrayAsLong()[i])
												{
													result = false;

													break;
												}
											}
										}

										break;

									default :
										result = true;

										break;
								}
							}
							catch(InvalidExtendedDataElementTypeException iedetexp)
							{
								result = false;
							}
						}
					}
				}
			}

			return result;
		}

}
