package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * @author rduggan
 *
 * Taken from 'Autonomic Computing Common Base Event and Situations Data ACAB.BO0301.1.0'.
 *
 * The AssociatedEvent type allows for the grouping of events. In addition to 
 * identifying associated events, this complex type also provides properties 
 * to describe the type of the association.
 * 
 * @version 1.0
 */
public interface IAssociatedEvent {

    /**
     * Array of globalInstanceIds cooresponding to the events that are associated with
     * this event.  This is a REQUIRED property.
     */
    public void addResolvedEvent(String  globalInstanceId);
    
    /**
     * Returns the resolved events.
     * 
     * Array of globalInstanceIds cooresponding to the events that are associated with
     * this event.  This is a REQUIRED property.
     * 
     * @return Object[] 
     */
    public String[] getResolvedEvents();

    public void clearResolvedEvents();

    public void setAssociationEngine(IAssociationEngine associationEngine);

    public IAssociationEngine getAssociationEngine();
}
