package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * @author rduggan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class MsgDataElementImpl implements IMsgDataElement {

    /**
     * Fields.
     */
    protected String msgId;
    protected String msgIdType;
    protected String msgCatalogId;
    protected String msgCatalog;
    protected String msgLocale;
    protected String msgCatalogType;
    protected String[] msgCatalogTokens;


    /**
     * Constructor for MsgDataElementImpl.
     */
    protected MsgDataElementImpl() {
	super();
    }
	
    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgCatalog()
     */
    public String getMsgCatalog() {
        return msgCatalog;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgCatalogId()
     */
    public String getMsgCatalogId() {
        return msgCatalogId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgCatalogTokens()
     */
    public String[] getMsgCatalogTokens() {
        return msgCatalogTokens;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgId()
     */
    public String getMsgId() {
        return msgId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgIdType()
     */
    public String getMsgIdType() {
        return msgIdType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgLocale()
     */
    public String getMsgLocale() {
        return msgLocale;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#getMsgCatalogType()
     */
    public String getMsgCatalogType() {
        return msgCatalogType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgCatalog(String)
     */
    public void setMsgCatalog(String msgCatalog) {
        this.msgCatalog = msgCatalog;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgCatalogId(String)
     */
    public void setMsgCatalogId(String msgCatalogId) {
        this.msgCatalogId = msgCatalogId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgCatalogTokens(String[])
     */
    public void setMsgCatalogTokens(String[] msgCatalogTokens) {
        this.msgCatalogTokens = msgCatalogTokens;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgId(String)
     */
    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgIdType(String)
     */
    public void setMsgIdType(String msgIdType) {
        this.msgIdType = msgIdType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgLocale(String)
     */
    public void setMsgLocale(String msgLocale) {
        this.msgLocale = msgLocale;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#setMsgCatalogType(String)
     */
    public void setMsgCatalogType(String msgCatalogType) {
        this.msgCatalogType = msgCatalogType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IMsgDataElement#init()
     */
    public void init() {
        msgId = null;
        msgIdType = null;
        msgCatalogId = null;
        msgCatalog = null;
        msgLocale = null;
        msgCatalogType = null;
        msgCatalogTokens = null;
    }
    
    /**
     * Determines is two different objects are equal.
     */
    public boolean equals(Object obj)
    {
        boolean result = false;

        //It's the same object reference, so it HAS to be equal
        if(this == obj)
        {
            result = true;
        }
        else
        {
            //If the object is null or is not the correct type of object, it can't be
            //equal
            if((obj != null) && (obj instanceof MsgDataElementImpl) && 
               (getClass() == obj.getClass()))
            {
                MsgDataElementImpl msgDataElement = (MsgDataElementImpl) obj;

                Object          property1;
                Object          property2;

                property1 = getMsgId();
                property2 = msgDataElement.getMsgId();

                if(((property1 != null) && (property1.equals(property2))) || 
                   ((property1 == null) && (property2 == null)))
                {
                    property1 = getMsgIdType();
                    property2 = msgDataElement.getMsgIdType();

                    if(((property1 != null) && (property1.equals(property2))) || 
                       ((property1 == null) && (property2 == null)))
                    {
                        property1 = getMsgCatalogId();
                        property2 = msgDataElement.getMsgCatalogId();

                        if(((property1 != null) && (property1.equals(property2))) || 
                           ((property1 == null) && (property2 == null)))
                        {
                            property1 = getMsgCatalog();
                            property2 = msgDataElement.getMsgCatalog();

                            if(((property1 != null) && (property1.equals(property2))) || 
                               ((property1 == null) && (property2 == null)))
                            {
                                property1 = getMsgLocale();
                                property2 = msgDataElement.getMsgLocale();

                                if(((property1 != null) && 
                                       (property1.equals(property2))) || 
                                   ((property1 == null) && (property2 == null)))
                                {
                                    property1 = getMsgCatalogType();
                                    property2 = msgDataElement.getMsgCatalogType();

                                    if(((property1 != null) && 
                                           (property1.equals(property2))) || 
                                       ((property1 == null) && (property2 == null)))
                                    {
                                        if((getMsgCatalogTokens() == null) && (msgDataElement.getMsgCatalogTokens() == null))
                                        {
                                        	result = true;
                                        }
                                        else if(((getMsgCatalogTokens() == null) && (msgDataElement.getMsgCatalogTokens() != null)) || ((getMsgCatalogTokens() != null) && (msgDataElement.getMsgCatalogTokens() == null)))
                                        {
                                        	result = false;
                                        }          
                                        else if(getMsgCatalogTokens().length == msgDataElement.getMsgCatalogTokens().length)
                                        {
                                            int arraySize = getMsgCatalogTokens().length;
                                            result = true;

                                            for(int i = 0; i < arraySize; i++)
                                            {
                                                if(!getMsgCatalogTokens()[i].equals(
                                                            msgDataElement.getMsgCatalogTokens()[i]))
                                                {
                                                    result = false;

                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return result;
    }    
}
